/*
 * Decompiled with CFR 0.152.
 */
package net.starlark.java.syntax;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import net.starlark.java.syntax.Location;

public final class SyntaxError {
    private final Location location;
    private final String message;

    public SyntaxError(Location location, String message) {
        this.location = Preconditions.checkNotNull(location);
        this.message = Preconditions.checkNotNull(message);
    }

    public Location location() {
        return this.location;
    }

    public String message() {
        return this.message;
    }

    public String toString() {
        return this.location + ": " + this.message;
    }

    public static final class Exception
    extends java.lang.Exception {
        private final ImmutableList<SyntaxError> errors;

        public Exception(List<SyntaxError> errors) {
            if (errors.isEmpty()) {
                throw new IllegalArgumentException("no errors");
            }
            this.errors = ImmutableList.copyOf(errors);
        }

        public ImmutableList<SyntaxError> errors() {
            return this.errors;
        }

        @Override
        public String getMessage() {
            String first = ((SyntaxError)this.errors.get(0)).message();
            if (this.errors.size() > 1) {
                return String.format("%s (+ %d more)", first, this.errors.size() - 1);
            }
            return first;
        }
    }
}

