/*
 * Decompiled with CFR 0.152.
 */
package net.starlark.java.syntax;

import javax.annotation.Nullable;
import net.starlark.java.syntax.Expression;
import net.starlark.java.syntax.FileLocations;
import net.starlark.java.syntax.NodeVisitor;
import net.starlark.java.syntax.Statement;

public final class ReturnStatement
extends Statement {
    private final int returnOffset;
    @Nullable
    private final Expression result;

    ReturnStatement(FileLocations locs, int returnOffset, @Nullable Expression result) {
        super(locs, Statement.Kind.RETURN);
        this.returnOffset = returnOffset;
        this.result = result;
    }

    static ReturnStatement make(Expression expr) {
        return new ReturnStatement(expr.locs, expr.getStartOffset(), expr);
    }

    @Nullable
    public Expression getResult() {
        return this.result;
    }

    @Override
    public int getStartOffset() {
        return this.returnOffset;
    }

    @Override
    public int getEndOffset() {
        return this.result != null ? this.result.getEndOffset() : this.returnOffset + "return".length();
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }
}

