/*
 * Decompiled with CFR 0.152.
 */
package net.starlark.java.syntax;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.FormatMethod;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.starlark.java.spelling.SpellChecker;
import net.starlark.java.syntax.Argument;
import net.starlark.java.syntax.AssignmentStatement;
import net.starlark.java.syntax.CallExpression;
import net.starlark.java.syntax.Comprehension;
import net.starlark.java.syntax.DefStatement;
import net.starlark.java.syntax.DotExpression;
import net.starlark.java.syntax.Expression;
import net.starlark.java.syntax.ExpressionStatement;
import net.starlark.java.syntax.FileOptions;
import net.starlark.java.syntax.FlowStatement;
import net.starlark.java.syntax.ForStatement;
import net.starlark.java.syntax.Identifier;
import net.starlark.java.syntax.IfStatement;
import net.starlark.java.syntax.IndexExpression;
import net.starlark.java.syntax.LambdaExpression;
import net.starlark.java.syntax.ListExpression;
import net.starlark.java.syntax.LoadStatement;
import net.starlark.java.syntax.Location;
import net.starlark.java.syntax.Node;
import net.starlark.java.syntax.NodeVisitor;
import net.starlark.java.syntax.Parameter;
import net.starlark.java.syntax.ReturnStatement;
import net.starlark.java.syntax.StarlarkFile;
import net.starlark.java.syntax.Statement;
import net.starlark.java.syntax.StringLiteral;
import net.starlark.java.syntax.SyntaxError;
import net.starlark.java.syntax.TokenKind;

public final class Resolver
extends NodeVisitor {
    private final List<SyntaxError> errors;
    private final FileOptions options;
    private final Module module;
    private final List<String> globals = new ArrayList<String>();
    private final Map<String, Binding> toplevel = new HashMap<String, Binding>();
    private Block locals;
    private int loopCount;

    public static Module moduleWithPredeclared(String ... names) {
        ImmutableSet<String> predeclared = ImmutableSet.copyOf(names);
        return name -> {
            if (predeclared.contains(name)) {
                return Scope.PREDECLARED;
            }
            throw new Module.Undefined(String.format("name '%s' is not defined", name), predeclared);
        };
    }

    private Resolver(List<SyntaxError> errors, Module module, FileOptions options) {
        this.errors = errors;
        this.module = module;
        this.options = options;
    }

    @FormatMethod
    private void errorf(Node node, String format, Object ... args) {
        this.errorf(node.getStartLocation(), format, args);
    }

    @FormatMethod
    private void errorf(Location loc, String format, Object ... args) {
        this.errors.add(new SyntaxError(loc, String.format(format, args)));
    }

    private void createBindingsForBlock(Iterable<Statement> stmts) {
        for (Statement stmt : stmts) {
            this.createBindings(stmt);
        }
    }

    private void createBindings(Statement stmt) {
        switch (stmt.kind()) {
            case ASSIGNMENT: {
                this.createBindingsForLHS(((AssignmentStatement)stmt).getLHS());
                break;
            }
            case IF: {
                IfStatement ifStmt = (IfStatement)stmt;
                this.createBindingsForBlock(ifStmt.getThenBlock());
                if (ifStmt.getElseBlock() == null) break;
                this.createBindingsForBlock(ifStmt.getElseBlock());
                break;
            }
            case FOR: {
                ForStatement forStmt = (ForStatement)stmt;
                this.createBindingsForLHS(forStmt.getVars());
                this.createBindingsForBlock(forStmt.getBody());
                break;
            }
            case DEF: {
                DefStatement def = (DefStatement)stmt;
                this.bind(def.getIdentifier(), false);
                break;
            }
            case LOAD: {
                LoadStatement load = (LoadStatement)stmt;
                HashSet<String> names = new HashSet<String>();
                for (LoadStatement.Binding b : load.getBindings()) {
                    Identifier local;
                    Identifier orig = b.getOriginalName();
                    if (orig.isPrivate() && !this.options.allowLoadPrivateSymbols()) {
                        this.errorf(orig, "symbol '%s' is private and cannot be imported", orig.getName());
                    }
                    if (names.add((local = b.getLocalName()).getName())) {
                        this.bind(local, true);
                        continue;
                    }
                    this.errorf(local, "load statement defines '%s' more than once", local.getName());
                }
                break;
            }
        }
    }

    private void createBindingsForLHS(Expression lhs) {
        for (Identifier id : Identifier.boundIdentifiers(lhs)) {
            this.bind(id, false);
        }
    }

    private void assign(Expression lhs) {
        if (!(lhs instanceof Identifier)) {
            if (lhs instanceof IndexExpression) {
                this.visit(lhs);
            } else if (lhs instanceof ListExpression) {
                for (Expression elem : ((ListExpression)lhs).getElements()) {
                    this.assign(elem);
                }
            } else if (lhs instanceof DotExpression) {
                this.visit(((DotExpression)lhs).getObject());
            } else {
                this.errorf(lhs, "cannot assign to '%s'", lhs);
            }
        }
    }

    @Override
    public void visit(Identifier id) {
        Binding bind = this.use(id);
        if (bind != null) {
            id.setBinding(bind);
            return;
        }
    }

    @Override
    public void visit(ReturnStatement node) {
        if (this.locals.syntax instanceof StarlarkFile) {
            this.errorf(node, "return statements must be inside a function", new Object[0]);
        }
        super.visit(node);
    }

    @Override
    public void visit(CallExpression node) {
        boolean seenVarargs = false;
        boolean seenKwargs = false;
        HashSet<String> keywords = null;
        for (Argument arg : node.getArguments()) {
            if (arg instanceof Argument.Positional) {
                if (seenVarargs) {
                    this.errorf(arg, "positional argument may not follow *args", new Object[0]);
                    continue;
                }
                if (seenKwargs) {
                    this.errorf(arg, "positional argument may not follow **kwargs", new Object[0]);
                    continue;
                }
                if (keywords == null) continue;
                this.errorf(arg, "positional argument may not follow keyword argument", new Object[0]);
                continue;
            }
            if (arg instanceof Argument.Keyword) {
                String keyword = ((Argument.Keyword)arg).getName();
                if (seenVarargs) {
                    this.errorf(arg, "keyword argument %s may not follow *args", keyword);
                } else if (seenKwargs) {
                    this.errorf(arg, "keyword argument %s may not follow **kwargs", keyword);
                }
                if (keywords == null) {
                    keywords = new HashSet<String>();
                }
                if (keywords.add(keyword)) continue;
                this.errorf(arg, "duplicate keyword argument: %s", keyword);
                continue;
            }
            if (arg instanceof Argument.Star) {
                if (seenKwargs) {
                    this.errorf(arg, "*args may not follow **kwargs", new Object[0]);
                } else if (seenVarargs) {
                    this.errorf(arg, "multiple *args not allowed", new Object[0]);
                }
                seenVarargs = true;
                continue;
            }
            if (!(arg instanceof Argument.StarStar)) continue;
            if (seenKwargs) {
                this.errorf(arg, "multiple **kwargs not allowed", new Object[0]);
            }
            seenKwargs = true;
        }
        super.visit(node);
    }

    @Override
    public void visit(ForStatement node) {
        if (this.locals.syntax instanceof StarlarkFile) {
            this.errorf(node, "for loops are not allowed at the top level. You may move it inside a function or use a comprehension, [f(x) for x in sequence]", new Object[0]);
        }
        ++this.loopCount;
        this.visit(node.getCollection());
        this.assign(node.getVars());
        this.visitBlock(node.getBody());
        Preconditions.checkState(this.loopCount > 0);
        --this.loopCount;
    }

    @Override
    public void visit(LoadStatement node) {
        if (!(this.locals.syntax instanceof StarlarkFile)) {
            this.errorf(node, "load statement not at top level", new Object[0]);
        }
    }

    @Override
    public void visit(FlowStatement node) {
        if (node.getFlowKind() != TokenKind.PASS && this.loopCount <= 0) {
            this.errorf(node, "%s statement must be inside a for loop", new Object[]{node.getFlowKind()});
        }
        super.visit(node);
    }

    @Override
    public void visit(DotExpression node) {
        this.visit(node.getObject());
    }

    @Override
    public void visit(Comprehension node) {
        Comprehension.For forClause;
        ImmutableList<Comprehension.Clause> clauses = node.getClauses();
        Comprehension.For for0 = (Comprehension.For)clauses.get(0);
        this.visit(for0.getIterable());
        this.pushLocalBlock(node, this.locals.frame, this.locals.freevars);
        for (Comprehension.Clause clause : clauses) {
            if (!(clause instanceof Comprehension.For)) continue;
            forClause = (Comprehension.For)clause;
            this.createBindingsForLHS(forClause.getVars());
        }
        for (int i = 0; i < clauses.size(); ++i) {
            Comprehension.Clause clause;
            clause = (Comprehension.Clause)clauses.get(i);
            if (clause instanceof Comprehension.For) {
                forClause = (Comprehension.For)clause;
                if (i > 0) {
                    this.visit(forClause.getIterable());
                }
                this.assign(forClause.getVars());
                continue;
            }
            Comprehension.If ifClause = (Comprehension.If)clause;
            this.visit(ifClause.getCondition());
        }
        this.visit(node.getBody());
        this.popLocalBlock();
    }

    @Override
    public void visit(DefStatement node) {
        node.setResolvedFunction(this.resolveFunction(node, node.getIdentifier().getName(), node.getIdentifier().getStartLocation(), node.getParameters(), node.getBody()));
    }

    @Override
    public void visit(LambdaExpression expr) {
        expr.setResolvedFunction(this.resolveFunction(expr, "lambda", expr.getStartLocation(), expr.getParameters(), ImmutableList.of(ReturnStatement.make(expr.getBody()))));
    }

    @Override
    public void visit(IfStatement node) {
        if (this.locals.syntax instanceof StarlarkFile) {
            this.errorf(node, "if statements are not allowed at the top level. You may move it inside a function or use an if expression (x if condition else y).", new Object[0]);
        }
        super.visit(node);
    }

    @Override
    public void visit(AssignmentStatement node) {
        this.visit(node.getRHS());
        if (node.isAugmented() && node.getLHS() instanceof ListExpression) {
            this.errorf(node.getOperatorLocation(), "cannot perform augmented assignment on a list or tuple expression", new Object[0]);
        }
        this.assign(node.getLHS());
    }

    @Nullable
    private Binding use(Identifier id) {
        Scope scope;
        String name = id.getName();
        Binding bind = Resolver.lookupLexical(name, this.locals);
        if (bind != null) {
            return bind;
        }
        bind = this.toplevel.get(name);
        if (bind != null) {
            return bind;
        }
        try {
            scope = this.module.resolve(name);
        }
        catch (Module.Undefined ex) {
            if (!Identifier.isValid(name)) {
                this.errorf(id, "contains syntax errors", new Object[0]);
            } else if (ex.candidates != null) {
                String suggestion = SpellChecker.didYouMean(name, this.getAllSymbols(ex.candidates));
                this.errorf(id, "%s%s", ex.getMessage(), suggestion);
            } else {
                this.errorf(id, "%s", ex.getMessage());
            }
            return null;
        }
        switch (scope) {
            case GLOBAL: {
                bind = new Binding(scope, this.globals.size(), id);
                this.globals.add(name);
                break;
            }
            case PREDECLARED: 
            case UNIVERSAL: {
                bind = new Binding(scope, 0, id);
                break;
            }
            default: {
                throw new IllegalStateException("bad scope: " + scope);
            }
        }
        this.toplevel.put(name, bind);
        return bind;
    }

    private static Binding lookupLexical(String name, Block b) {
        Binding bind = b.bindings.get(name);
        if (bind != null) {
            return bind;
        }
        if (b.parent != null && (bind = Resolver.lookupLexical(name, b.parent)) != null) {
            Scope scope;
            if ((b.syntax instanceof DefStatement || b.syntax instanceof LambdaExpression) && ((scope = bind.getScope()) == Scope.LOCAL || scope == Scope.FREE || scope == Scope.CELL)) {
                if (scope == Scope.LOCAL) {
                    bind.scope = Scope.CELL;
                }
                int index = b.freevars.size();
                b.freevars.add(bind);
                bind = new Binding(Scope.FREE, index, bind.first);
            }
            b.bindings.put(name, bind);
        }
        return bind;
    }

    private Function resolveFunction(Node syntax, String name, Location loc, ImmutableList<Parameter> parameters, ImmutableList<Statement> body) {
        for (Parameter param : parameters) {
            if (!(param instanceof Parameter.Optional)) continue;
            this.visit(param.getDefaultValue());
        }
        ArrayList<Binding> frame = new ArrayList<Binding>();
        ArrayList<Binding> freevars = new ArrayList<Binding>();
        this.pushLocalBlock(syntax, frame, freevars);
        Parameter star = null;
        Parameter.StarStar starStar = null;
        boolean seenOptional = false;
        int numKeywordOnlyParams = 0;
        ImmutableList.Builder<Parameter> params = ImmutableList.builderWithExpectedSize(parameters.size());
        for (Parameter param : parameters) {
            if (param instanceof Parameter.Mandatory) {
                if (starStar != null) {
                    this.errorf(param, "required parameter %s may not follow **%s", param.getName(), starStar.getName());
                } else if (star != null) {
                    ++numKeywordOnlyParams;
                } else if (seenOptional) {
                    this.errorf(param, "required positional parameter %s may not follow an optional parameter", param.getName());
                }
                this.bindParam(params, param);
                continue;
            }
            if (param instanceof Parameter.Optional) {
                seenOptional = true;
                if (starStar != null) {
                    this.errorf(param, "optional parameter may not follow **%s", starStar.getName());
                } else if (star != null) {
                    ++numKeywordOnlyParams;
                }
                this.bindParam(params, param);
                continue;
            }
            if (param instanceof Parameter.Star) {
                if (starStar != null) {
                    this.errorf(param, "* parameter may not follow **%s", starStar.getName());
                    continue;
                }
                if (star != null) {
                    this.errorf(param, "multiple * parameters not allowed", new Object[0]);
                    continue;
                }
                star = (Parameter.Star)param;
                continue;
            }
            if (starStar != null) {
                this.errorf(param, "multiple ** parameters not allowed", new Object[0]);
            }
            starStar = (Parameter.StarStar)param;
        }
        if (star != null) {
            if (star.getIdentifier() != null) {
                this.bindParam(params, star);
            } else if (numKeywordOnlyParams == 0) {
                this.errorf(star, "bare * must be followed by keyword-only parameters", new Object[0]);
            }
        }
        if (starStar != null) {
            this.bindParam(params, starStar);
        }
        this.createBindingsForBlock(body);
        this.visitAll(body);
        this.popLocalBlock();
        return new Function(name, loc, (ImmutableList<Parameter>)params.build(), body, star != null && star.getIdentifier() != null, starStar != null, numKeywordOnlyParams, frame, freevars, this.globals);
    }

    private void bindParam(ImmutableList.Builder<Parameter> params, Parameter param) {
        if (this.bind(param.getIdentifier(), false)) {
            this.errorf(param, "duplicate parameter: %s", param.getName());
        }
        params.add((Object)param);
    }

    private boolean bind(Identifier id, boolean isLoad) {
        Binding bind;
        String name = id.getName();
        boolean isNew = false;
        if (this.locals.syntax instanceof StarlarkFile && (!isLoad || this.options.loadBindsGlobally())) {
            bind = this.toplevel.get(name);
            if (bind == null) {
                isNew = true;
                bind = new Binding(Scope.GLOBAL, this.globals.size(), id);
                this.globals.add(name);
                this.toplevel.put(name, bind);
                Binding prevLocal = this.locals.bindings.get(name);
                if (prevLocal != null) {
                    this.globalLocalConflict(id, bind.scope, prevLocal);
                }
            } else {
                this.toplevelRebinding(id, bind);
            }
        } else {
            bind = this.locals.bindings.get(name);
            if (bind == null) {
                isNew = true;
                bind = new Binding(Scope.LOCAL, this.locals.frame.size(), id);
                this.locals.bindings.put(name, bind);
                this.locals.frame.add(bind);
            }
            if (isLoad) {
                Binding prev;
                if (!isNew) {
                    this.toplevelRebinding(id, bind);
                }
                if ((prev = this.toplevel.get(name)) != null && prev.scope == Scope.GLOBAL) {
                    this.globalLocalConflict(id, bind.scope, prev);
                }
            }
        }
        id.setBinding(bind);
        return !isNew;
    }

    private void toplevelRebinding(Identifier id, Binding prev) {
        if (!this.options.allowToplevelRebinding()) {
            this.errorf(id, "'%s' redeclared at top level", id.getName());
            if (prev.first != null) {
                this.errorf(prev.first, "'%s' previously declared here", id.getName());
            }
        }
    }

    private void globalLocalConflict(Identifier id, Scope scope, Binding prev) {
        String newqual = scope == Scope.GLOBAL ? "global" : "file-local";
        String oldqual = prev.getScope() == Scope.GLOBAL ? "global" : "file-local";
        this.errorf(id, "conflicting %s declaration of '%s'", newqual, id.getName());
        if (prev.first != null) {
            this.errorf(prev.first, "'%s' previously declared as %s here", id.getName(), oldqual);
        }
    }

    private Set<String> getAllSymbols(Set<String> predeclared) {
        HashSet<String> all = new HashSet<String>();
        Block b = this.locals;
        while (b != null) {
            all.addAll(b.bindings.keySet());
            b = b.parent;
        }
        all.addAll(predeclared);
        all.addAll(this.toplevel.keySet());
        return all;
    }

    private void checkLoadAfterStatement(List<Statement> statements) {
        Statement firstStatement = null;
        for (Statement statement : statements) {
            if (statement instanceof ExpressionStatement && ((ExpressionStatement)statement).getExpression() instanceof StringLiteral) continue;
            if (statement instanceof LoadStatement) {
                if (firstStatement == null) continue;
                this.errorf(statement, "load statements must appear before any other statement", new Object[0]);
                this.errorf(firstStatement, "\tfirst non-load statement appears here", new Object[0]);
            }
            if (firstStatement != null) continue;
            firstStatement = statement;
        }
    }

    public static void resolveFile(StarlarkFile file, Module module) {
        Resolver r = new Resolver(file.errors, module, file.getOptions());
        ImmutableCollection stmts = file.getStatements();
        if (r.options.requireLoadStatementsFirst()) {
            r.checkLoadAfterStatement((List<Statement>)((Object)stmts));
        }
        ArrayList<Binding> frame = new ArrayList<Binding>();
        r.pushLocalBlock(file, frame, null);
        r.createBindingsForBlock(stmts);
        r.visitAll((List<? extends Node>)((Object)stmts));
        r.popLocalBlock();
        int n = stmts.size();
        if (n > 0 && stmts.get(n - 1) instanceof ExpressionStatement) {
            Expression expr = ((ExpressionStatement)stmts.get(n - 1)).getExpression();
            stmts = ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll((Iterable)stmts.subList(0, n - 1))).add(ReturnStatement.make(expr))).build();
        }
        file.setResolvedFunction(new Function("<toplevel>", file.getStartLocation(), ImmutableList.of(), (ImmutableList<Statement>)stmts, false, false, 0, (List<Binding>)frame, (List<Binding>)ImmutableList.of(), r.globals));
    }

    public static Function resolveExpr(Expression expr, Module module, FileOptions options) throws SyntaxError.Exception {
        ArrayList<SyntaxError> errors = new ArrayList<SyntaxError>();
        Resolver r = new Resolver(errors, module, options);
        ArrayList<Binding> frame = new ArrayList<Binding>();
        r.pushLocalBlock(null, frame, null);
        r.visit(expr);
        r.popLocalBlock();
        if (!errors.isEmpty()) {
            throw new SyntaxError.Exception(errors);
        }
        return new Function("<expr>", expr.getStartLocation(), ImmutableList.of(), ImmutableList.of(ReturnStatement.make(expr)), false, false, 0, frame, ImmutableList.of(), r.globals);
    }

    private void pushLocalBlock(Node syntax, ArrayList<Binding> frame, @Nullable ArrayList<Binding> freevars) {
        this.locals = new Block(this.locals, syntax, frame, freevars);
    }

    private void popLocalBlock() {
        this.locals = this.locals.parent;
    }

    private static class Block {
        @Nullable
        private final Block parent;
        @Nullable
        Node syntax;
        private final ArrayList<Binding> frame;
        @Nullable
        private final ArrayList<Binding> freevars;
        private final Map<String, Binding> bindings = new HashMap<String, Binding>();

        Block(@Nullable Block parent, @Nullable Node syntax, ArrayList<Binding> frame, @Nullable ArrayList<Binding> freevars) {
            this.parent = parent;
            this.syntax = syntax;
            this.frame = frame;
            this.freevars = freevars;
        }
    }

    public static interface Module {
        public Scope resolve(String var1) throws Undefined;

        public static final class Undefined
        extends Exception {
            @Nullable
            private final Set<String> candidates;

            public Undefined(String message, @Nullable Set<String> candidates) {
                super(message);
                this.candidates = candidates;
            }
        }
    }

    public static final class Function {
        private final String name;
        private final Location location;
        private final ImmutableList<Parameter> params;
        private final ImmutableList<Statement> body;
        private final boolean hasVarargs;
        private final boolean hasKwargs;
        private final int numKeywordOnlyParams;
        private final ImmutableList<String> parameterNames;
        private final boolean isToplevel;
        private final ImmutableList<Binding> locals;
        private final int[] cellIndices;
        private final ImmutableList<Binding> freevars;
        private final ImmutableList<String> globals;

        private Function(String name, Location loc, ImmutableList<Parameter> params, ImmutableList<Statement> body, boolean hasVarargs, boolean hasKwargs, int numKeywordOnlyParams, List<Binding> locals, List<Binding> freevars, List<String> globals) {
            int i;
            this.name = name;
            this.location = loc;
            this.params = params;
            this.body = body;
            this.hasVarargs = hasVarargs;
            this.hasKwargs = hasKwargs;
            this.numKeywordOnlyParams = numKeywordOnlyParams;
            ImmutableList.Builder names = ImmutableList.builderWithExpectedSize(params.size());
            for (Parameter p : params) {
                names.add(p.getName());
            }
            this.parameterNames = names.build();
            this.isToplevel = name.equals("<toplevel>");
            this.locals = ImmutableList.copyOf(locals);
            this.freevars = ImmutableList.copyOf(freevars);
            this.globals = ImmutableList.copyOf(globals);
            int ncells = 0;
            int nlocals = locals.size();
            for (i = 0; i < nlocals; ++i) {
                if (locals.get((int)i).scope != Scope.CELL) continue;
                ++ncells;
            }
            this.cellIndices = new int[ncells];
            int j = 0;
            for (i = 0; i < nlocals; ++i) {
                if (locals.get((int)i).scope != Scope.CELL) continue;
                this.cellIndices[j++] = i;
            }
        }

        public String getName() {
            return this.name;
        }

        @Nullable
        public String getDocumentation() {
            if (this.getBody().isEmpty()) {
                return null;
            }
            Statement first = (Statement)this.getBody().get(0);
            if (!(first instanceof ExpressionStatement)) {
                return null;
            }
            Expression expr = ((ExpressionStatement)first).getExpression();
            if (!(expr instanceof StringLiteral)) {
                return null;
            }
            return ((StringLiteral)expr).getValue();
        }

        public ImmutableList<Binding> getLocals() {
            return this.locals;
        }

        public int[] getCellIndices() {
            return this.cellIndices;
        }

        public ImmutableList<String> getGlobals() {
            return this.globals;
        }

        public ImmutableList<Binding> getFreeVars() {
            return this.freevars;
        }

        public Location getLocation() {
            return this.location;
        }

        public ImmutableList<Parameter> getParameters() {
            return this.params;
        }

        public ImmutableList<Statement> getBody() {
            return this.body;
        }

        public boolean hasVarargs() {
            return this.hasVarargs;
        }

        public boolean hasKwargs() {
            return this.hasKwargs;
        }

        public int numKeywordOnlyParams() {
            return this.numKeywordOnlyParams;
        }

        public ImmutableList<String> getParameterNames() {
            return this.parameterNames;
        }

        public boolean isToplevel() {
            return this.isToplevel;
        }
    }

    public static final class Binding {
        private Scope scope;
        private final int index;
        @Nullable
        private final Identifier first;

        private Binding(Scope scope, int index, @Nullable Identifier first) {
            this.scope = scope;
            this.index = index;
            this.first = first;
        }

        @Nullable
        public String getName() {
            return this.first != null ? this.first.getName() : null;
        }

        public Scope getScope() {
            return this.scope;
        }

        public int getIndex() {
            return this.index;
        }

        public String toString() {
            return this.first == null ? this.scope.toString() : String.format("%s[%d] %s @ %s", new Object[]{this.scope, this.index, this.first.getName(), this.first.getStartLocation()});
        }
    }

    public static enum Scope {
        LOCAL,
        GLOBAL,
        CELL,
        FREE,
        PREDECLARED,
        UNIVERSAL;


        public String toString() {
            return super.toString().toLowerCase();
        }
    }
}

