/*
 * Decompiled with CFR 0.152.
 */
package net.starlark.java.syntax;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import net.starlark.java.syntax.Expression;
import net.starlark.java.syntax.FileOptions;
import net.starlark.java.syntax.LoadStatement;
import net.starlark.java.syntax.Location;
import net.starlark.java.syntax.Resolver;
import net.starlark.java.syntax.StarlarkFile;
import net.starlark.java.syntax.Statement;
import net.starlark.java.syntax.SyntaxError;

public final class Program {
    private final Resolver.Function body;
    private final ImmutableList<String> loads;
    private final ImmutableList<Location> loadLocations;

    private Program(Resolver.Function body, ImmutableList<String> loads, ImmutableList<Location> loadLocations) {
        Preconditions.checkArgument(loads.size() == loadLocations.size(), "each load must have a corresponding location");
        this.body = body;
        this.loads = loads;
        this.loadLocations = loadLocations;
    }

    public Resolver.Function getResolvedFunction() {
        return this.body;
    }

    public String getFilename() {
        return this.body.getLocation().file();
    }

    public ImmutableList<String> getLoads() {
        return this.loads;
    }

    public Location getLoadLocation(int i) {
        return (Location)this.loadLocations.get(i);
    }

    public static Program compileFile(StarlarkFile file, Resolver.Module env) throws SyntaxError.Exception {
        Resolver.resolveFile(file, env);
        if (!file.ok()) {
            throw new SyntaxError.Exception(file.errors());
        }
        ImmutableList.Builder loads = ImmutableList.builder();
        ImmutableList.Builder loadLocations = ImmutableList.builder();
        for (Statement stmt : file.getStatements()) {
            if (!(stmt instanceof LoadStatement)) continue;
            LoadStatement load = (LoadStatement)stmt;
            String module = load.getImport().getValue();
            loads.add(module);
            loadLocations.add(load.getImport().getLocation());
        }
        return new Program(file.getResolvedFunction(), (ImmutableList<String>)loads.build(), (ImmutableList<Location>)loadLocations.build());
    }

    public static Program compileExpr(Expression expr, Resolver.Module module, FileOptions options) throws SyntaxError.Exception {
        Resolver.Function body = Resolver.resolveExpr(expr, module, options);
        return new Program(body, ImmutableList.of(), ImmutableList.of());
    }
}

