/*
 * Decompiled with CFR 0.152.
 */
package net.starlark.java.syntax;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;

public final class ParserInput {
    private final String file;
    private final char[] content;

    private ParserInput(char[] content, String file) {
        this.content = content;
        this.file = Preconditions.checkNotNull(file);
    }

    char[] getContent() {
        return this.content;
    }

    public String getFile() {
        return this.file;
    }

    public static ParserInput readFile(String file) throws IOException {
        byte[] utf8 = Files.readAllBytes(Paths.get(file, new String[0]));
        return ParserInput.fromUTF8(utf8, file);
    }

    public static ParserInput fromLines(String ... lines) {
        return ParserInput.fromString(Joiner.on("\n").join(lines), "");
    }

    public static ParserInput fromUTF8(byte[] bytes, String file) {
        CharBuffer cb = StandardCharsets.UTF_8.decode(ByteBuffer.wrap(bytes));
        char[] utf16 = new char[cb.length()];
        cb.get(utf16);
        return ParserInput.fromCharArray(utf16, file);
    }

    public static ParserInput fromLatin1(byte[] bytes, String file) {
        char[] chars = new char[bytes.length];
        for (int i = 0; i < bytes.length; ++i) {
            chars[i] = (char)(0xFF & bytes[i]);
        }
        return new ParserInput(chars, file);
    }

    public static ParserInput fromString(String content, String file) {
        return ParserInput.fromCharArray(content.toCharArray(), file);
    }

    public static ParserInput fromCharArray(char[] content, String file) {
        return new ParserInput(content, file);
    }
}

