/*
 * Decompiled with CFR 0.152.
 */
package net.starlark.java.syntax;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.FormatMethod;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.starlark.java.syntax.Argument;
import net.starlark.java.syntax.AssignmentStatement;
import net.starlark.java.syntax.BinaryOperatorExpression;
import net.starlark.java.syntax.CallExpression;
import net.starlark.java.syntax.Comment;
import net.starlark.java.syntax.Comprehension;
import net.starlark.java.syntax.ConditionalExpression;
import net.starlark.java.syntax.DefStatement;
import net.starlark.java.syntax.DictExpression;
import net.starlark.java.syntax.DotExpression;
import net.starlark.java.syntax.Expression;
import net.starlark.java.syntax.ExpressionStatement;
import net.starlark.java.syntax.FileLocations;
import net.starlark.java.syntax.FloatLiteral;
import net.starlark.java.syntax.FlowStatement;
import net.starlark.java.syntax.ForStatement;
import net.starlark.java.syntax.Identifier;
import net.starlark.java.syntax.IfStatement;
import net.starlark.java.syntax.IndexExpression;
import net.starlark.java.syntax.IntLiteral;
import net.starlark.java.syntax.LambdaExpression;
import net.starlark.java.syntax.Lexer;
import net.starlark.java.syntax.ListExpression;
import net.starlark.java.syntax.LoadStatement;
import net.starlark.java.syntax.Location;
import net.starlark.java.syntax.Node;
import net.starlark.java.syntax.Parameter;
import net.starlark.java.syntax.ParserInput;
import net.starlark.java.syntax.ReturnStatement;
import net.starlark.java.syntax.SliceExpression;
import net.starlark.java.syntax.StarlarkFile;
import net.starlark.java.syntax.Statement;
import net.starlark.java.syntax.StringLiteral;
import net.starlark.java.syntax.SyntaxError;
import net.starlark.java.syntax.TokenKind;
import net.starlark.java.syntax.UnaryOperatorExpression;

final class Parser {
    private static final EnumSet<TokenKind> STATEMENT_TERMINATOR_SET = EnumSet.of(TokenKind.EOF, TokenKind.NEWLINE, TokenKind.SEMI);
    private static final EnumSet<TokenKind> LIST_TERMINATOR_SET = EnumSet.of(TokenKind.EOF, TokenKind.RBRACKET, TokenKind.SEMI);
    private static final EnumSet<TokenKind> DICT_TERMINATOR_SET = EnumSet.of(TokenKind.EOF, TokenKind.RBRACE, TokenKind.SEMI);
    private static final EnumSet<TokenKind> EXPR_LIST_TERMINATOR_SET = EnumSet.of(TokenKind.EOF, new TokenKind[]{TokenKind.NEWLINE, TokenKind.EQUALS, TokenKind.RBRACE, TokenKind.RBRACKET, TokenKind.RPAREN, TokenKind.SEMI});
    private static final EnumSet<TokenKind> EXPR_TERMINATOR_SET = EnumSet.of(TokenKind.COLON, new TokenKind[]{TokenKind.COMMA, TokenKind.EOF, TokenKind.FOR, TokenKind.MINUS, TokenKind.PERCENT, TokenKind.PLUS, TokenKind.RBRACKET, TokenKind.RPAREN, TokenKind.SLASH});
    private final Lexer token;
    private static final boolean DEBUGGING = false;
    private final Lexer lexer;
    private final FileLocations locs;
    private final List<SyntaxError> errors;
    private static final Map<TokenKind, TokenKind> augmentedAssignments = new ImmutableMap.Builder<TokenKind, TokenKind>().put(TokenKind.PLUS_EQUALS, TokenKind.PLUS).put(TokenKind.MINUS_EQUALS, TokenKind.MINUS).put(TokenKind.STAR_EQUALS, TokenKind.STAR).put(TokenKind.SLASH_EQUALS, TokenKind.SLASH).put(TokenKind.SLASH_SLASH_EQUALS, TokenKind.SLASH_SLASH).put(TokenKind.PERCENT_EQUALS, TokenKind.PERCENT).put(TokenKind.AMPERSAND_EQUALS, TokenKind.AMPERSAND).put(TokenKind.CARET_EQUALS, TokenKind.CARET).put(TokenKind.PIPE_EQUALS, TokenKind.PIPE).put(TokenKind.GREATER_GREATER_EQUALS, TokenKind.GREATER_GREATER).put(TokenKind.LESS_LESS_EQUALS, TokenKind.LESS_LESS).buildOrThrow();
    private static final List<EnumSet<TokenKind>> operatorPrecedence = ImmutableList.of(EnumSet.of(TokenKind.OR), EnumSet.of(TokenKind.AND), EnumSet.of(TokenKind.NOT), EnumSet.of(TokenKind.EQUALS_EQUALS, new TokenKind[]{TokenKind.NOT_EQUALS, TokenKind.LESS, TokenKind.LESS_EQUALS, TokenKind.GREATER, TokenKind.GREATER_EQUALS, TokenKind.IN, TokenKind.NOT_IN}), EnumSet.of(TokenKind.PIPE), EnumSet.of(TokenKind.CARET), EnumSet.of(TokenKind.AMPERSAND), EnumSet.of(TokenKind.GREATER_GREATER, TokenKind.LESS_LESS), EnumSet.of(TokenKind.MINUS, TokenKind.PLUS), EnumSet.of(TokenKind.SLASH, TokenKind.SLASH_SLASH, TokenKind.STAR, TokenKind.PERCENT));
    private int errorsCount;
    private boolean recoveryMode;
    private final Map<String, String> stringInterner = new HashMap<String, String>();
    @Nullable
    static StarlarkFile.ParseProfiler profiler;
    private static final EnumSet<TokenKind> FORBIDDEN_KEYWORDS;

    private Parser(Lexer lexer, List<SyntaxError> errors) {
        this.lexer = lexer;
        this.locs = lexer.locs;
        this.errors = errors;
        this.token = lexer;
        this.nextToken();
    }

    private String intern(String s2) {
        String prev = this.stringInterner.putIfAbsent(s2, s2);
        return prev != null ? prev : s2;
    }

    private static String tokenString(TokenKind kind, @Nullable Object value) {
        return kind == TokenKind.STRING ? "\"" + value + "\"" : (value == null ? kind.toString() : value.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ParseResult parseFile(ParserInput input) {
        ArrayList<SyntaxError> errors = new ArrayList<SyntaxError>();
        Lexer lexer = new Lexer(input, errors);
        Parser parser = new Parser(lexer, errors);
        StarlarkFile.ParseProfiler profiler = Parser.profiler;
        Object span = profiler != null ? profiler.start(input.getFile()) : null;
        try {
            ImmutableList<Statement> statements = parser.parseFileInput();
            ParseResult parseResult = new ParseResult(lexer.locs, statements, lexer.getComments(), errors);
            return parseResult;
        }
        finally {
            if (profiler != null) {
                profiler.end(span);
            }
        }
    }

    private void parseStatement(ImmutableList.Builder<Statement> list) {
        if (this.token.kind == TokenKind.DEF) {
            list.add((Object)this.parseDefStatement());
        } else if (this.token.kind == TokenKind.IF) {
            list.add((Object)this.parseIfStatement());
        } else if (this.token.kind == TokenKind.FOR) {
            list.add((Object)this.parseForStatement());
        } else {
            this.parseSimpleStatement(list);
        }
    }

    static Expression parseExpression(ParserInput input) throws SyntaxError.Exception {
        ArrayList<SyntaxError> errors = new ArrayList<SyntaxError>();
        Lexer lexer = new Lexer(input, errors);
        Parser parser = new Parser(lexer, errors);
        Expression result = null;
        try {
            result = parser.parseExpression();
            while (parser.token.kind == TokenKind.NEWLINE) {
                parser.nextToken();
            }
            parser.expect(TokenKind.EOF);
        }
        catch (StackOverflowError ex) {
            parser.reportError(lexer.end, "internal error: stack overflow while parsing Starlark expression <<%s>>. Please report the bug.\n%s", new String(input.getContent()), Throwables.getStackTraceAsString(ex));
        }
        if (!errors.isEmpty()) {
            throw new SyntaxError.Exception(errors);
        }
        return result;
    }

    private Expression parseExpression() {
        Expression e = this.parseTest();
        if (this.token.kind != TokenKind.COMMA) {
            return e;
        }
        ArrayList<Expression> elems = new ArrayList<Expression>();
        elems.add(e);
        this.parseExprList(elems, false);
        return new ListExpression(this.locs, true, -1, elems, -1);
    }

    @FormatMethod
    private void reportError(int offset, String format, Object ... args) {
        ++this.errorsCount;
        if (this.errorsCount <= 5) {
            Location location = this.locs.getLocation(offset);
            this.errors.add(new SyntaxError(location, String.format(format, args)));
        }
    }

    private void syntaxError(String message) {
        if (!this.recoveryMode) {
            if (this.token.kind == TokenKind.INDENT) {
                this.reportError(this.token.start, "indentation error", new Object[0]);
            } else {
                this.reportError(this.token.start, "syntax error at '%s': %s", Parser.tokenString(this.token.kind, this.token.value), message);
            }
            this.recoveryMode = true;
        }
    }

    private int expect(TokenKind kind) {
        if (this.token.kind != kind) {
            this.syntaxError("expected " + kind);
        }
        return this.nextToken();
    }

    private int expectAndRecover(TokenKind kind) {
        if (this.token.kind != kind) {
            this.syntaxError("expected " + kind);
        } else {
            this.recoveryMode = false;
        }
        return this.nextToken();
    }

    private int syncPast(EnumSet<TokenKind> terminatingTokens) {
        Preconditions.checkState(terminatingTokens.contains((Object)TokenKind.EOF));
        while (!terminatingTokens.contains((Object)this.token.kind)) {
            this.nextToken();
        }
        int end = this.token.end;
        this.nextToken();
        return end;
    }

    private int syncTo(EnumSet<TokenKind> terminatingTokens) {
        Preconditions.checkState(terminatingTokens.contains((Object)TokenKind.EOF));
        int previous = this.token.end;
        this.nextToken();
        int current = previous;
        while (!terminatingTokens.contains((Object)this.token.kind)) {
            this.nextToken();
            previous = current;
            current = this.token.end;
        }
        return previous;
    }

    private void checkForbiddenKeywords() {
        Object error;
        if (!FORBIDDEN_KEYWORDS.contains((Object)this.token.kind)) {
            return;
        }
        switch (this.token.kind) {
            case ASSERT: {
                error = "'assert' not supported, use 'fail' instead";
                break;
            }
            case DEL: {
                error = "'del' not supported, use '.pop()' to delete an item from a dictionary or a list";
                break;
            }
            case IMPORT: {
                error = "'import' not supported, use 'load' instead";
                break;
            }
            case IS: {
                error = "'is' not supported, use '==' instead";
                break;
            }
            case RAISE: {
                error = "'raise' not supported, use 'fail' instead";
                break;
            }
            case TRY: {
                error = "'try' not supported, all exceptions are fatal";
                break;
            }
            case WHILE: {
                error = "'while' not supported, use 'for' instead";
                break;
            }
            default: {
                error = "keyword '" + this.token.kind + "' not supported";
            }
        }
        this.reportError(this.token.start, "%s", error);
    }

    private int nextToken() {
        int prev = this.token.start;
        if (this.token.kind != TokenKind.EOF) {
            this.lexer.nextToken();
        }
        this.checkForbiddenKeywords();
        return prev;
    }

    private Identifier makeErrorExpression(int start, int end) {
        return new Identifier(this.locs, this.lexer.bufferSlice(start, end), start);
    }

    private Argument parseArgument() {
        if (this.token.kind == TokenKind.STAR_STAR) {
            int starStarOffset = this.nextToken();
            Expression expr = this.parseTest();
            return new Argument.StarStar(this.locs, starStarOffset, expr);
        }
        if (this.token.kind == TokenKind.STAR) {
            int starOffset = this.nextToken();
            Expression expr = this.parseTest();
            return new Argument.Star(this.locs, starOffset, expr);
        }
        Expression expr = this.parseTest();
        if (expr instanceof Identifier) {
            Identifier id = (Identifier)expr;
            if (this.token.kind == TokenKind.EQUALS) {
                this.nextToken();
                Expression arg = this.parseTest();
                return new Argument.Keyword(this.locs, id, arg);
            }
        }
        return new Argument.Positional(this.locs, expr);
    }

    private Parameter parseParameter() {
        if (this.token.kind == TokenKind.STAR_STAR) {
            int starStarOffset = this.nextToken();
            Identifier id = this.parseIdent();
            return new Parameter.StarStar(this.locs, starStarOffset, id);
        }
        if (this.token.kind == TokenKind.STAR) {
            int starOffset = this.nextToken();
            if (this.token.kind == TokenKind.IDENTIFIER) {
                Identifier id = this.parseIdent();
                return new Parameter.Star(this.locs, starOffset, id);
            }
            return new Parameter.Star(this.locs, starOffset, null);
        }
        Identifier id = this.parseIdent();
        if (this.token.kind == TokenKind.EQUALS) {
            this.nextToken();
            Expression expr = this.parseTest();
            return new Parameter.Optional(this.locs, id, expr);
        }
        return new Parameter.Mandatory(this.locs, id);
    }

    private Expression parseCallSuffix(Expression fn) {
        ImmutableList<Argument> args = ImmutableList.of();
        int lparenOffset = this.expect(TokenKind.LPAREN);
        if (this.token.kind != TokenKind.RPAREN) {
            args = this.parseArguments();
        }
        int rparenOffset = this.expect(TokenKind.RPAREN);
        return new CallExpression(this.locs, fn, this.locs.getLocation(lparenOffset), args, rparenOffset);
    }

    private ImmutableList<Argument> parseArguments() {
        boolean seenArg = false;
        ImmutableList.Builder list = ImmutableList.builder();
        while (this.token.kind != TokenKind.RPAREN && this.token.kind != TokenKind.EOF) {
            if (seenArg) {
                if (this.token.kind == TokenKind.FOR) {
                    this.syntaxError("Starlark does not support Python-style generator expressions");
                }
                this.expect(TokenKind.COMMA);
                if (this.token.kind == TokenKind.RPAREN) break;
            }
            list.add(this.parseArgument());
            seenArg = true;
        }
        return list.build();
    }

    private Expression parseSelectorSuffix(Expression e) {
        int dotOffset = this.expect(TokenKind.DOT);
        if (this.token.kind == TokenKind.IDENTIFIER) {
            Identifier id = this.parseIdent();
            return new DotExpression(this.locs, e, dotOffset, id);
        }
        this.syntaxError("expected identifier after dot");
        this.syncTo(EXPR_TERMINATOR_SET);
        return e;
    }

    private void parseExprList(List<Expression> list, boolean trailingCommaAllowed) {
        while (this.token.kind == TokenKind.COMMA) {
            this.expect(TokenKind.COMMA);
            if (EXPR_LIST_TERMINATOR_SET.contains((Object)this.token.kind)) {
                if (trailingCommaAllowed) break;
                this.reportError(this.token.start, "Trailing comma is allowed only in parenthesized tuples.", new Object[0]);
                break;
            }
            list.add(this.parseTest());
        }
    }

    private List<DictExpression.Entry> parseDictEntryList() {
        ArrayList<DictExpression.Entry> list = new ArrayList<DictExpression.Entry>();
        while (this.token.kind != TokenKind.RBRACE) {
            list.add(this.parseDictEntry());
            if (this.token.kind != TokenKind.COMMA) break;
            this.nextToken();
        }
        return list;
    }

    private DictExpression.Entry parseDictEntry() {
        Expression key = this.parseTest();
        int colonOffset = this.expect(TokenKind.COLON);
        Expression value = this.parseTest();
        return new DictExpression.Entry(this.locs, key, colonOffset, value);
    }

    private StringLiteral parseStringLiteral() {
        Preconditions.checkState(this.token.kind == TokenKind.STRING);
        StringLiteral literal = new StringLiteral(this.locs, this.token.start, this.intern((String)this.token.value), this.token.end);
        this.nextToken();
        if (this.token.kind == TokenKind.STRING) {
            this.reportError(this.token.start, "Implicit string concatenation is forbidden, use the + operator", new Object[0]);
        }
        return literal;
    }

    private Expression parsePrimary() {
        switch (this.token.kind) {
            case INT: {
                IntLiteral literal = new IntLiteral(this.locs, this.token.getRaw(), this.token.start, (Number)this.token.value);
                this.nextToken();
                return literal;
            }
            case FLOAT: {
                FloatLiteral literal = new FloatLiteral(this.locs, this.token.getRaw(), this.token.start, (Double)this.token.value);
                this.nextToken();
                return literal;
            }
            case STRING: {
                return this.parseStringLiteral();
            }
            case IDENTIFIER: {
                return this.parseIdent();
            }
            case LBRACKET: {
                return this.parseListMaker();
            }
            case LBRACE: {
                return this.parseDictExpression();
            }
            case LPAREN: {
                int lparenOffset = this.nextToken();
                if (this.token.kind == TokenKind.RPAREN) {
                    int rparen = this.nextToken();
                    return new ListExpression(this.locs, true, lparenOffset, ImmutableList.of(), rparen);
                }
                Expression e = this.parseTest();
                if (this.token.kind == TokenKind.RPAREN) {
                    this.nextToken();
                    return e;
                }
                if (this.token.kind == TokenKind.COMMA) {
                    ArrayList<Expression> elems = new ArrayList<Expression>();
                    elems.add(e);
                    this.parseExprList(elems, true);
                    int rparenOffset = this.expect(TokenKind.RPAREN);
                    return new ListExpression(this.locs, true, lparenOffset, elems, rparenOffset);
                }
                if (this.token.kind == TokenKind.FOR) {
                    this.syntaxError("Starlark does not support Python-style generator expressions");
                }
                this.expect(TokenKind.RPAREN);
                int end = this.syncTo(EXPR_TERMINATOR_SET);
                return this.makeErrorExpression(lparenOffset, end);
            }
            case MINUS: 
            case PLUS: 
            case TILDE: {
                TokenKind op = this.token.kind;
                int offset = this.nextToken();
                Expression x = this.parsePrimaryWithSuffix();
                return new UnaryOperatorExpression(this.locs, op, offset, x);
            }
        }
        int start = this.token.start;
        this.syntaxError("expected expression");
        int end = this.syncTo(EXPR_TERMINATOR_SET);
        return this.makeErrorExpression(start, end);
    }

    private Expression parsePrimaryWithSuffix() {
        Expression e = this.parsePrimary();
        while (true) {
            if (this.token.kind == TokenKind.DOT) {
                e = this.parseSelectorSuffix(e);
                continue;
            }
            if (this.token.kind == TokenKind.LBRACKET) {
                e = this.parseSliceSuffix(e);
                continue;
            }
            if (this.token.kind != TokenKind.LPAREN) break;
            e = this.parseCallSuffix(e);
        }
        return e;
    }

    private Expression parseSliceSuffix(Expression e) {
        int lbracketOffset = this.expect(TokenKind.LBRACKET);
        Expression start = null;
        Expression end = null;
        Expression step = null;
        if (this.token.kind != TokenKind.COLON) {
            start = this.parseExpression();
            if (this.token.kind == TokenKind.RBRACKET) {
                int rbracketOffset = this.expect(TokenKind.RBRACKET);
                return new IndexExpression(this.locs, e, lbracketOffset, start, rbracketOffset);
            }
        }
        this.expect(TokenKind.COLON);
        if (this.token.kind != TokenKind.COLON && this.token.kind != TokenKind.RBRACKET) {
            end = this.parseTest();
        }
        if (this.token.kind == TokenKind.COLON) {
            this.expect(TokenKind.COLON);
            if (this.token.kind != TokenKind.RBRACKET) {
                step = this.parseTest();
            }
        }
        int rbracketOffset = this.expect(TokenKind.RBRACKET);
        return new SliceExpression(this.locs, e, lbracketOffset, start, end, step, rbracketOffset);
    }

    private Expression parseForLoopVariables() {
        Expression e1 = this.parsePrimaryWithSuffix();
        if (this.token.kind != TokenKind.COMMA) {
            return e1;
        }
        ArrayList<Expression> elems = new ArrayList<Expression>();
        elems.add(e1);
        while (this.token.kind == TokenKind.COMMA) {
            this.expect(TokenKind.COMMA);
            if (EXPR_LIST_TERMINATOR_SET.contains((Object)this.token.kind)) break;
            elems.add(this.parsePrimaryWithSuffix());
        }
        return new ListExpression(this.locs, true, -1, elems, -1);
    }

    private Expression parseComprehensionSuffix(int loffset, Node body, TokenKind closingBracket) {
        ImmutableList.Builder clauses = ImmutableList.builder();
        while (true) {
            if (this.token.kind == TokenKind.FOR) {
                int forOffset = this.nextToken();
                Expression vars = this.parseForLoopVariables();
                this.expect(TokenKind.IN);
                Expression seq = this.parseTest(0);
                clauses.add(new Comprehension.For(this.locs, forOffset, vars, seq));
                continue;
            }
            if (this.token.kind != TokenKind.IF) break;
            int ifOffset = this.nextToken();
            Expression cond = this.parseTestNoCond();
            clauses.add(new Comprehension.If(this.locs, ifOffset, cond));
        }
        if (this.token.kind != closingBracket) {
            this.syntaxError("expected '" + closingBracket + "', 'for' or 'if'");
            int end = this.syncPast(LIST_TERMINATOR_SET);
            return this.makeErrorExpression(loffset, end);
        }
        boolean isDict = closingBracket == TokenKind.RBRACE;
        int roffset = this.expect(closingBracket);
        return new Comprehension(this.locs, isDict, loffset, body, (ImmutableList<Comprehension.Clause>)clauses.build(), roffset);
    }

    private Expression parseListMaker() {
        int lbracketOffset = this.expect(TokenKind.LBRACKET);
        if (this.token.kind == TokenKind.RBRACKET) {
            int rbracketOffset = this.nextToken();
            return new ListExpression(this.locs, false, lbracketOffset, ImmutableList.of(), rbracketOffset);
        }
        Expression expression = this.parseTest();
        switch (this.token.kind) {
            case RBRACKET: {
                int rbracketOffset = this.nextToken();
                return new ListExpression(this.locs, false, lbracketOffset, ImmutableList.of(expression), rbracketOffset);
            }
            case FOR: {
                return this.parseComprehensionSuffix(lbracketOffset, expression, TokenKind.RBRACKET);
            }
            case COMMA: {
                ArrayList<Expression> elems = new ArrayList<Expression>();
                elems.add(expression);
                this.parseExprList(elems, true);
                if (this.token.kind == TokenKind.RBRACKET) {
                    int rbracketOffset = this.nextToken();
                    return new ListExpression(this.locs, false, lbracketOffset, elems, rbracketOffset);
                }
                this.expect(TokenKind.RBRACKET);
                int end = this.syncPast(LIST_TERMINATOR_SET);
                return this.makeErrorExpression(lbracketOffset, end);
            }
        }
        this.syntaxError("expected ',', 'for' or ']'");
        int end = this.syncPast(LIST_TERMINATOR_SET);
        return this.makeErrorExpression(lbracketOffset, end);
    }

    private Expression parseDictExpression() {
        int lbraceOffset = this.expect(TokenKind.LBRACE);
        if (this.token.kind == TokenKind.RBRACE) {
            int rbraceOffset = this.nextToken();
            return new DictExpression(this.locs, lbraceOffset, ImmutableList.of(), rbraceOffset);
        }
        DictExpression.Entry entry = this.parseDictEntry();
        if (this.token.kind == TokenKind.FOR) {
            return this.parseComprehensionSuffix(lbraceOffset, entry, TokenKind.RBRACE);
        }
        ArrayList<DictExpression.Entry> entries = new ArrayList<DictExpression.Entry>();
        entries.add(entry);
        if (this.token.kind == TokenKind.COMMA) {
            this.expect(TokenKind.COMMA);
            entries.addAll(this.parseDictEntryList());
        }
        if (this.token.kind == TokenKind.RBRACE) {
            int rbraceOffset = this.nextToken();
            return new DictExpression(this.locs, lbraceOffset, entries, rbraceOffset);
        }
        this.expect(TokenKind.RBRACE);
        int end = this.syncPast(DICT_TERMINATOR_SET);
        return this.makeErrorExpression(lbraceOffset, end);
    }

    private Identifier parseIdent() {
        if (this.token.kind != TokenKind.IDENTIFIER) {
            int start = this.token.start;
            int end = this.expect(TokenKind.IDENTIFIER);
            return this.makeErrorExpression(start, end);
        }
        String name = (String)this.token.value;
        int offset = this.nextToken();
        return new Identifier(this.locs, name, offset);
    }

    private Expression parseBinOpExpression(int prec) {
        Expression x = this.parseTest(prec + 1);
        TokenKind lastOp = null;
        while (true) {
            if (this.token.kind == TokenKind.NOT) {
                this.expect(TokenKind.NOT);
                if (this.token.kind != TokenKind.IN) {
                    this.syntaxError("expected 'in'");
                }
                this.token.kind = TokenKind.NOT_IN;
            }
            TokenKind op = this.token.kind;
            if (!operatorPrecedence.get(prec).contains((Object)op)) {
                return x;
            }
            if (lastOp != null && operatorPrecedence.get(prec).contains((Object)TokenKind.EQUALS_EQUALS)) {
                this.reportError(this.token.start, "Operator '%s' is not associative with operator '%s'. Use parens.", new Object[]{lastOp, op});
            }
            int opOffset = this.nextToken();
            Expression y = this.parseTest(prec + 1);
            x = this.optimizeBinOpExpression(x, op, opOffset, y);
            lastOp = op;
        }
    }

    private Expression optimizeBinOpExpression(Expression x, TokenKind op, int opOffset, Expression y) {
        if (op == TokenKind.PLUS && x instanceof StringLiteral && y instanceof StringLiteral) {
            return new StringLiteral(this.locs, x.getStartOffset(), this.intern(((StringLiteral)x).getValue() + ((StringLiteral)y).getValue()), y.getEndOffset());
        }
        return new BinaryOperatorExpression(this.locs, x, op, opOffset, y);
    }

    private Expression parseTest() {
        int start = this.token.start;
        if (this.token.kind == TokenKind.LAMBDA) {
            return this.parseLambda(true);
        }
        Expression expr = this.parseTest(0);
        if (this.token.kind == TokenKind.IF) {
            this.nextToken();
            Expression condition = this.parseTest(0);
            if (this.token.kind == TokenKind.ELSE) {
                this.nextToken();
                Expression elseClause = this.parseTest();
                return new ConditionalExpression(this.locs, expr, condition, elseClause);
            }
            this.reportError(start, "missing else clause in conditional expression or semicolon before if", new Object[0]);
            return expr;
        }
        return expr;
    }

    private Expression parseTest(int prec) {
        if (prec >= operatorPrecedence.size()) {
            return this.parsePrimaryWithSuffix();
        }
        if (this.token.kind == TokenKind.NOT && operatorPrecedence.get(prec).contains((Object)TokenKind.NOT)) {
            return this.parseNotExpression(prec);
        }
        return this.parseBinOpExpression(prec);
    }

    private LambdaExpression parseLambda(boolean allowCond) {
        int lambdaOffset = this.expect(TokenKind.LAMBDA);
        ImmutableList<Parameter> params = this.parseParameters();
        this.expect(TokenKind.COLON);
        Expression body = allowCond ? this.parseTest() : this.parseTestNoCond();
        return new LambdaExpression(this.locs, lambdaOffset, params, body);
    }

    private Expression parseTestNoCond() {
        if (this.token.kind == TokenKind.LAMBDA) {
            return this.parseLambda(false);
        }
        return this.parseTest(0);
    }

    private Expression parseNotExpression(int prec) {
        int notOffset = this.expect(TokenKind.NOT);
        Expression x = this.parseTest(prec);
        return new UnaryOperatorExpression(this.locs, TokenKind.NOT, notOffset, x);
    }

    private ImmutableList<Statement> parseFileInput() {
        ImmutableList.Builder<Statement> list = ImmutableList.builder();
        try {
            while (this.token.kind != TokenKind.EOF) {
                if (this.token.kind == TokenKind.NEWLINE) {
                    this.expectAndRecover(TokenKind.NEWLINE);
                    continue;
                }
                if (this.recoveryMode) {
                    this.syncTo(STATEMENT_TERMINATOR_SET);
                    this.recoveryMode = false;
                    continue;
                }
                this.parseStatement(list);
            }
        }
        catch (StackOverflowError ex) {
            this.reportError(this.token.end, "internal error: stack overflow in Starlark parser. Please report the bug and include the text of %s.\n%s", this.locs.file(), Throwables.getStackTraceAsString(ex));
        }
        return list.build();
    }

    private Statement parseLoadStatement() {
        int loadOffset = this.expect(TokenKind.LOAD);
        this.expect(TokenKind.LPAREN);
        if (this.token.kind != TokenKind.STRING) {
            StringLiteral module = new StringLiteral(this.locs, this.token.start, "", this.token.end);
            this.expect(TokenKind.STRING);
            return new LoadStatement(this.locs, loadOffset, module, ImmutableList.of(), this.token.end);
        }
        StringLiteral module = this.parseStringLiteral();
        if (this.token.kind == TokenKind.RPAREN) {
            this.syntaxError("expected at least one symbol to load");
            return new LoadStatement(this.locs, loadOffset, module, ImmutableList.of(), this.token.end);
        }
        this.expect(TokenKind.COMMA);
        ImmutableList.Builder<LoadStatement.Binding> bindings = ImmutableList.builder();
        this.parseLoadSymbol(bindings);
        while (this.token.kind != TokenKind.RPAREN && this.token.kind != TokenKind.EOF) {
            this.expect(TokenKind.COMMA);
            if (this.token.kind == TokenKind.RPAREN) break;
            this.parseLoadSymbol(bindings);
        }
        int rparen = this.expect(TokenKind.RPAREN);
        return new LoadStatement(this.locs, loadOffset, module, (ImmutableList<LoadStatement.Binding>)bindings.build(), rparen);
    }

    private void parseLoadSymbol(ImmutableList.Builder<LoadStatement.Binding> symbols) {
        Identifier original;
        if (this.token.kind != TokenKind.STRING && this.token.kind != TokenKind.IDENTIFIER) {
            this.syntaxError("expected either a literal string or an identifier");
            return;
        }
        String name = (String)this.token.value;
        int nameOffset = this.token.start + (this.token.kind == TokenKind.STRING ? 1 : 0);
        Identifier local = new Identifier(this.locs, name, nameOffset);
        if (this.token.kind == TokenKind.STRING) {
            original = local;
        } else {
            this.expect(TokenKind.IDENTIFIER);
            this.expect(TokenKind.EQUALS);
            if (this.token.kind != TokenKind.STRING) {
                this.syntaxError("expected string");
                return;
            }
            original = new Identifier(this.locs, (String)this.token.value, this.token.start + 1);
        }
        this.nextToken();
        symbols.add((Object)new LoadStatement.Binding(local, original));
    }

    private void parseSimpleStatement(ImmutableList.Builder<Statement> list) {
        list.add((Object)this.parseSmallStatement());
        while (this.token.kind == TokenKind.SEMI) {
            this.nextToken();
            if (this.token.kind == TokenKind.NEWLINE) break;
            list.add((Object)this.parseSmallStatement());
        }
        this.expectAndRecover(TokenKind.NEWLINE);
    }

    private Statement parseSmallStatement() {
        if (this.token.kind == TokenKind.RETURN) {
            return this.parseReturnStatement();
        }
        if (this.token.kind == TokenKind.BREAK || this.token.kind == TokenKind.CONTINUE || this.token.kind == TokenKind.PASS) {
            TokenKind kind = this.token.kind;
            int offset = this.nextToken();
            return new FlowStatement(this.locs, kind, offset);
        }
        if (this.token.kind == TokenKind.LOAD) {
            return this.parseLoadStatement();
        }
        Expression lhs = this.parseExpression();
        TokenKind op = augmentedAssignments.get((Object)this.token.kind);
        if (this.token.kind == TokenKind.EQUALS || op != null) {
            int opOffset = this.nextToken();
            Expression rhs = this.parseExpression();
            return new AssignmentStatement(this.locs, lhs, op, opOffset, rhs);
        }
        return new ExpressionStatement(this.locs, lhs);
    }

    private IfStatement parseIfStatement() {
        IfStatement ifStmt;
        int ifOffset = this.expect(TokenKind.IF);
        Expression cond = this.parseTest();
        this.expect(TokenKind.COLON);
        ImmutableList<Statement> body = this.parseSuite();
        IfStatement tail = ifStmt = new IfStatement(this.locs, TokenKind.IF, ifOffset, cond, body);
        while (this.token.kind == TokenKind.ELIF) {
            int elifOffset = this.expect(TokenKind.ELIF);
            cond = this.parseTest();
            this.expect(TokenKind.COLON);
            body = this.parseSuite();
            IfStatement elif = new IfStatement(this.locs, TokenKind.ELIF, elifOffset, cond, body);
            tail.setElseBlock(ImmutableList.of(elif));
            tail = elif;
        }
        if (this.token.kind == TokenKind.ELSE) {
            this.expect(TokenKind.ELSE);
            this.expect(TokenKind.COLON);
            body = this.parseSuite();
            tail.setElseBlock(body);
        }
        return ifStmt;
    }

    private ForStatement parseForStatement() {
        int forOffset = this.expect(TokenKind.FOR);
        Expression vars = this.parseForLoopVariables();
        this.expect(TokenKind.IN);
        Expression collection = this.parseExpression();
        this.expect(TokenKind.COLON);
        ImmutableList<Statement> body = this.parseSuite();
        return new ForStatement(this.locs, forOffset, vars, collection, body);
    }

    private DefStatement parseDefStatement() {
        int defOffset = this.expect(TokenKind.DEF);
        Identifier ident = this.parseIdent();
        this.expect(TokenKind.LPAREN);
        ImmutableList<Parameter> params = this.parseParameters();
        this.expect(TokenKind.RPAREN);
        this.expect(TokenKind.COLON);
        ImmutableList<Statement> block = this.parseSuite();
        return new DefStatement(this.locs, defOffset, ident, params, block);
    }

    private ImmutableList<Parameter> parseParameters() {
        boolean hasParam = false;
        ImmutableList.Builder list = ImmutableList.builder();
        while (this.token.kind != TokenKind.RPAREN && this.token.kind != TokenKind.COLON && this.token.kind != TokenKind.EOF) {
            if (hasParam) {
                this.expect(TokenKind.COMMA);
                if (this.token.kind == TokenKind.RPAREN) break;
            }
            Parameter param = this.parseParameter();
            hasParam = true;
            list.add(param);
        }
        return list.build();
    }

    private ImmutableList<Statement> parseSuite() {
        ImmutableList.Builder<Statement> list = ImmutableList.builder();
        if (this.token.kind == TokenKind.NEWLINE) {
            this.expect(TokenKind.NEWLINE);
            if (this.token.kind != TokenKind.INDENT) {
                this.reportError(this.token.start, "expected an indented block", new Object[0]);
                return list.build();
            }
            this.expect(TokenKind.INDENT);
            while (this.token.kind != TokenKind.OUTDENT && this.token.kind != TokenKind.EOF) {
                this.parseStatement(list);
            }
            this.expectAndRecover(TokenKind.OUTDENT);
        } else {
            this.parseSimpleStatement(list);
        }
        return list.build();
    }

    private ReturnStatement parseReturnStatement() {
        int returnOffset = this.expect(TokenKind.RETURN);
        Expression result = null;
        if (!STATEMENT_TERMINATOR_SET.contains((Object)this.token.kind)) {
            result = this.parseExpression();
        }
        return new ReturnStatement(this.locs, returnOffset, result);
    }

    static {
        FORBIDDEN_KEYWORDS = EnumSet.of(TokenKind.AS, new TokenKind[]{TokenKind.ASSERT, TokenKind.CLASS, TokenKind.DEL, TokenKind.EXCEPT, TokenKind.FINALLY, TokenKind.FROM, TokenKind.GLOBAL, TokenKind.IMPORT, TokenKind.IS, TokenKind.NONLOCAL, TokenKind.RAISE, TokenKind.TRY, TokenKind.WITH, TokenKind.WHILE, TokenKind.YIELD});
    }

    static final class ParseResult {
        final FileLocations locs;
        final ImmutableList<Statement> statements;
        final ImmutableList<Comment> comments;
        final List<SyntaxError> errors;

        private ParseResult(FileLocations locs, ImmutableList<Statement> statements, ImmutableList<Comment> comments, List<SyntaxError> errors) {
            this.locs = locs;
            this.statements = Preconditions.checkNotNull(statements);
            this.comments = Preconditions.checkNotNull(comments);
            this.errors = errors;
        }
    }
}

