/*
 * Decompiled with CFR 0.152.
 */
package net.starlark.java.syntax;

import javax.annotation.Nullable;
import net.starlark.java.syntax.Expression;
import net.starlark.java.syntax.FileLocations;
import net.starlark.java.syntax.Identifier;
import net.starlark.java.syntax.Node;
import net.starlark.java.syntax.NodeVisitor;

public abstract class Parameter
extends Node {
    @Nullable
    private final Identifier id;

    private Parameter(FileLocations locs, @Nullable Identifier id) {
        super(locs);
        this.id = id;
    }

    @Nullable
    public String getName() {
        return this.id != null ? this.id.getName() : null;
    }

    @Nullable
    public Identifier getIdentifier() {
        return this.id;
    }

    @Nullable
    public Expression getDefaultValue() {
        return null;
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    public static final class StarStar
    extends Parameter {
        private final int starStarOffset;

        StarStar(FileLocations locs, int starStarOffset, Identifier id) {
            super(locs, id);
            this.starStarOffset = starStarOffset;
        }

        @Override
        public int getStartOffset() {
            return this.starStarOffset;
        }

        @Override
        public int getEndOffset() {
            return this.getIdentifier().getEndOffset();
        }
    }

    public static final class Star
    extends Parameter {
        private final int starOffset;

        Star(FileLocations locs, int starOffset, @Nullable Identifier id) {
            super(locs, id);
            this.starOffset = starOffset;
        }

        @Override
        public int getStartOffset() {
            return this.starOffset;
        }

        @Override
        public int getEndOffset() {
            return this.getIdentifier().getEndOffset();
        }
    }

    public static final class Optional
    extends Parameter {
        public final Expression defaultValue;

        Optional(FileLocations locs, Identifier id, @Nullable Expression defaultValue) {
            super(locs, id);
            this.defaultValue = defaultValue;
        }

        @Override
        @Nullable
        public Expression getDefaultValue() {
            return this.defaultValue;
        }

        @Override
        public int getStartOffset() {
            return this.getIdentifier().getStartOffset();
        }

        @Override
        public int getEndOffset() {
            return this.getDefaultValue().getEndOffset();
        }

        @Override
        public String toString() {
            return this.getName() + "=" + this.defaultValue;
        }
    }

    public static final class Mandatory
    extends Parameter {
        Mandatory(FileLocations locs, Identifier id) {
            super(locs, id);
        }

        @Override
        public int getStartOffset() {
            return this.getIdentifier().getStartOffset();
        }

        @Override
        public int getEndOffset() {
            return this.getIdentifier().getEndOffset();
        }
    }
}

