/*
 * Decompiled with CFR 0.152.
 */
package net.starlark.java.syntax;

import java.util.List;
import net.starlark.java.syntax.Argument;
import net.starlark.java.syntax.AssignmentStatement;
import net.starlark.java.syntax.BinaryOperatorExpression;
import net.starlark.java.syntax.CallExpression;
import net.starlark.java.syntax.Comment;
import net.starlark.java.syntax.Comprehension;
import net.starlark.java.syntax.ConditionalExpression;
import net.starlark.java.syntax.DefStatement;
import net.starlark.java.syntax.DictExpression;
import net.starlark.java.syntax.DotExpression;
import net.starlark.java.syntax.ExpressionStatement;
import net.starlark.java.syntax.FloatLiteral;
import net.starlark.java.syntax.FlowStatement;
import net.starlark.java.syntax.ForStatement;
import net.starlark.java.syntax.Identifier;
import net.starlark.java.syntax.IfStatement;
import net.starlark.java.syntax.IndexExpression;
import net.starlark.java.syntax.IntLiteral;
import net.starlark.java.syntax.LambdaExpression;
import net.starlark.java.syntax.ListExpression;
import net.starlark.java.syntax.LoadStatement;
import net.starlark.java.syntax.Node;
import net.starlark.java.syntax.Parameter;
import net.starlark.java.syntax.ReturnStatement;
import net.starlark.java.syntax.SliceExpression;
import net.starlark.java.syntax.StarlarkFile;
import net.starlark.java.syntax.Statement;
import net.starlark.java.syntax.StringLiteral;
import net.starlark.java.syntax.UnaryOperatorExpression;

public class NodeVisitor {
    public void visit(Node node) {
        node.accept(this);
    }

    public void visit(Argument node) {
        this.visit(node.getValue());
    }

    public void visit(Parameter node) {
        this.visit(node.getIdentifier());
        if (node.getDefaultValue() != null) {
            this.visit(node.getDefaultValue());
        }
    }

    public void visit(StarlarkFile node) {
        this.visitBlock(node.getStatements());
        this.visitAll(node.getComments());
    }

    public void visit(BinaryOperatorExpression node) {
        this.visit(node.getX());
        this.visit(node.getY());
    }

    public void visit(CallExpression node) {
        this.visit(node.getFunction());
        this.visitAll(node.getArguments());
    }

    public void visit(Identifier node) {
    }

    public void visit(Comprehension node) {
        for (Comprehension.Clause clause : node.getClauses()) {
            if (clause instanceof Comprehension.For) {
                this.visit((Comprehension.For)clause);
                continue;
            }
            this.visit((Comprehension.If)clause);
        }
        this.visit(node.getBody());
    }

    public void visit(Comprehension.For node) {
        this.visit(node.getVars());
        this.visit(node.getIterable());
    }

    public void visit(Comprehension.If node) {
        this.visit(node.getCondition());
    }

    public void visit(ForStatement node) {
        this.visit(node.getCollection());
        this.visit(node.getVars());
        this.visitBlock(node.getBody());
    }

    public void visit(LoadStatement node) {
        for (LoadStatement.Binding binding : node.getBindings()) {
            this.visit(binding.getLocalName());
        }
    }

    public void visit(ListExpression node) {
        this.visitAll(node.getElements());
    }

    public void visit(IntLiteral node) {
    }

    public void visit(FloatLiteral node) {
    }

    public void visit(StringLiteral node) {
    }

    public void visit(AssignmentStatement node) {
        this.visit(node.getRHS());
        this.visit(node.getLHS());
    }

    public void visit(ExpressionStatement node) {
        this.visit(node.getExpression());
    }

    public void visit(IfStatement node) {
        this.visit(node.getCondition());
        this.visitBlock(node.getThenBlock());
        if (node.getElseBlock() != null) {
            this.visitBlock(node.getElseBlock());
        }
    }

    public void visit(DefStatement node) {
        this.visit(node.getIdentifier());
        this.visitAll(node.getParameters());
        this.visitBlock(node.getBody());
    }

    public void visit(ReturnStatement node) {
        if (node.getResult() != null) {
            this.visit(node.getResult());
        }
    }

    public void visit(FlowStatement node) {
    }

    public void visit(DictExpression node) {
        this.visitAll(node.getEntries());
    }

    public void visit(DictExpression.Entry node) {
        this.visit(node.getKey());
        this.visit(node.getValue());
    }

    public void visit(UnaryOperatorExpression node) {
        this.visit(node.getX());
    }

    public void visit(DotExpression node) {
        this.visit(node.getObject());
        this.visit(node.getField());
    }

    public void visit(IndexExpression node) {
        this.visit(node.getObject());
        this.visit(node.getKey());
    }

    public void visit(LambdaExpression node) {
        this.visitAll(node.getParameters());
        this.visit(node.getBody());
    }

    public void visit(SliceExpression node) {
        this.visit(node.getObject());
        if (node.getStart() != null) {
            this.visit(node.getStart());
        }
        if (node.getStop() != null) {
            this.visit(node.getStop());
        }
        if (node.getStep() != null) {
            this.visit(node.getStep());
        }
    }

    public void visit(Comment node) {
    }

    public void visit(ConditionalExpression node) {
        this.visit(node.getCondition());
        this.visit(node.getThenCase());
        if (node.getElseCase() != null) {
            this.visit(node.getElseCase());
        }
    }

    public void visitAll(List<? extends Node> nodes) {
        for (Node node : nodes) {
            this.visit(node);
        }
    }

    public void visitBlock(List<Statement> statements) {
        this.visitAll(statements);
    }
}

