/*
 * Decompiled with CFR 0.152.
 */
package net.starlark.java.syntax;

import com.google.common.base.Preconditions;
import net.starlark.java.syntax.FileLocations;
import net.starlark.java.syntax.Location;
import net.starlark.java.syntax.NodePrinter;
import net.starlark.java.syntax.NodeVisitor;

public abstract class Node {
    final FileLocations locs;

    Node(FileLocations locs) {
        this.locs = Preconditions.checkNotNull(locs);
    }

    public abstract int getStartOffset();

    public final Location getStartLocation() {
        return this.locs.getLocation(this.getStartOffset());
    }

    public abstract int getEndOffset();

    public final Location getEndLocation() {
        return this.locs.getLocation(this.getEndOffset());
    }

    public final String prettyPrint() {
        StringBuilder buf = new StringBuilder();
        new NodePrinter(buf).printNode(this);
        return buf.toString();
    }

    public String toString() {
        return this.prettyPrint();
    }

    public abstract void accept(NodeVisitor var1);
}

