/*
 * Decompiled with CFR 0.152.
 */
package net.starlark.java.syntax;

import com.google.common.base.Preconditions;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class Location
implements Comparable<Location> {
    private final String file;
    private final int line;
    private final int column;
    public static final Location BUILTIN = Location.fromFile("<builtin>");

    public Location(String file, int line, int column) {
        this.file = Preconditions.checkNotNull(file);
        this.line = line;
        this.column = column;
    }

    public String file() {
        return this.file;
    }

    public int line() {
        return this.line;
    }

    public int column() {
        return this.column;
    }

    public static Location fromFileLineColumn(String file, int line, int column) {
        Preconditions.checkArgument(line != 0 || column == 0, "non-zero column but no line number");
        return new Location(file, line, column);
    }

    public static Location fromFile(String file) {
        return new Location(file, 0, 0);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.file);
        if (this.line != 0) {
            buf.append(':').append(this.line);
            if (this.column != 0) {
                buf.append(':').append(this.column);
            }
        }
        return buf.toString();
    }

    @Override
    public int compareTo(Location that) {
        int cmp = this.file().compareTo(that.file());
        if (cmp != 0) {
            return cmp;
        }
        return Long.compare((long)this.line << 32 | (long)this.column, (long)that.line << 32 | (long)that.column);
    }

    public int hashCode() {
        return 97 * this.file.hashCode() + 37 * this.line + this.column;
    }

    public boolean equals(Object that) {
        return this == that || that instanceof Location && this.file.equals(((Location)that).file) && this.line == ((Location)that).line && this.column == ((Location)that).column;
    }
}

