/*
 * Decompiled with CFR 0.152.
 */
package net.starlark.java.syntax;

import com.google.common.collect.ImmutableList;
import net.starlark.java.syntax.FileLocations;
import net.starlark.java.syntax.Identifier;
import net.starlark.java.syntax.NodeVisitor;
import net.starlark.java.syntax.Statement;
import net.starlark.java.syntax.StringLiteral;

public final class LoadStatement
extends Statement {
    private final int loadOffset;
    private final StringLiteral module;
    private final ImmutableList<Binding> bindings;
    private final int rparenOffset;

    LoadStatement(FileLocations locs, int loadOffset, StringLiteral module, ImmutableList<Binding> bindings, int rparenOffset) {
        super(locs, Statement.Kind.LOAD);
        this.loadOffset = loadOffset;
        this.module = module;
        this.bindings = bindings;
        this.rparenOffset = rparenOffset;
    }

    public ImmutableList<Binding> getBindings() {
        return this.bindings;
    }

    public StringLiteral getImport() {
        return this.module;
    }

    @Override
    public int getStartOffset() {
        return this.loadOffset;
    }

    @Override
    public int getEndOffset() {
        return this.rparenOffset + 1;
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    public static final class Binding {
        private final Identifier local;
        private final Identifier orig;

        public Identifier getLocalName() {
            return this.local;
        }

        public Identifier getOriginalName() {
            return this.orig;
        }

        Binding(Identifier localName, Identifier originalName) {
            this.local = localName;
            this.orig = originalName;
        }
    }
}

