/*
 * Decompiled with CFR 0.152.
 */
package net.starlark.java.syntax;

import com.google.common.base.Preconditions;
import java.util.List;
import net.starlark.java.syntax.Expression;
import net.starlark.java.syntax.FileLocations;
import net.starlark.java.syntax.Node;
import net.starlark.java.syntax.NodeVisitor;

public final class ListExpression
extends Expression {
    private final boolean isTuple;
    private final int lbracketOffset;
    private final List<Expression> elements;
    private final int rbracketOffset;

    ListExpression(FileLocations locs, boolean isTuple, int lbracketOffset, List<Expression> elements, int rbracketOffset) {
        super(locs, Expression.Kind.LIST_EXPR);
        Preconditions.checkArgument(!elements.isEmpty() || lbracketOffset >= 0 && rbracketOffset >= 0);
        this.lbracketOffset = lbracketOffset;
        this.isTuple = isTuple;
        this.elements = elements;
        this.rbracketOffset = rbracketOffset;
    }

    public List<Expression> getElements() {
        return this.elements;
    }

    public boolean isTuple() {
        return this.isTuple;
    }

    @Override
    public int getStartOffset() {
        return this.lbracketOffset < 0 ? this.elements.get(0).getStartOffset() : this.lbracketOffset;
    }

    @Override
    public int getEndOffset() {
        return this.rbracketOffset < 0 ? this.elements.get(this.elements.size() - 1).getEndOffset() : this.rbracketOffset + 1;
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.isTuple() ? (char)'(' : '[');
        ListExpression.appendNodes(buf, this.elements);
        if (this.isTuple() && this.elements.size() == 1) {
            buf.append(',');
        }
        buf.append(this.isTuple() ? (char)')' : ']');
        return buf.toString();
    }

    static void appendNodes(StringBuilder buf, List<? extends Node> elements) {
        int n = elements.size();
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                buf.append(", ");
            }
            int mark = buf.length();
            buf.append(elements.get(i));
            if (buf.length() < 32 && (i != 4 || i + 1 >= n)) continue;
            buf.setLength(mark);
            buf.append(String.format("+%d more", n - i));
            break;
        }
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }
}

