/*
 * Decompiled with CFR 0.152.
 */
package net.starlark.java.syntax;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import javax.annotation.Nullable;
import net.starlark.java.syntax.Expression;
import net.starlark.java.syntax.FileLocations;
import net.starlark.java.syntax.NodeVisitor;
import net.starlark.java.syntax.Parameter;
import net.starlark.java.syntax.Resolver;

public final class LambdaExpression
extends Expression {
    private final int lambdaOffset;
    private final ImmutableList<Parameter> parameters;
    private final Expression body;
    @Nullable
    private Resolver.Function resolved;

    LambdaExpression(FileLocations locs, int lambdaOffset, ImmutableList<Parameter> parameters, Expression body) {
        super(locs, Expression.Kind.LAMBDA);
        this.lambdaOffset = lambdaOffset;
        this.parameters = Preconditions.checkNotNull(parameters);
        this.body = Preconditions.checkNotNull(body);
    }

    public ImmutableList<Parameter> getParameters() {
        return this.parameters;
    }

    public Expression getBody() {
        return this.body;
    }

    @Nullable
    public Resolver.Function getResolvedFunction() {
        return this.resolved;
    }

    void setResolvedFunction(Resolver.Function resolved) {
        this.resolved = resolved;
    }

    @Override
    public int getStartOffset() {
        return this.lambdaOffset;
    }

    @Override
    public int getEndOffset() {
        return this.body.getEndOffset();
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }
}

