/*
 * Decompiled with CFR 0.152.
 */
package net.starlark.java.syntax;

import java.math.BigInteger;
import net.starlark.java.syntax.Expression;
import net.starlark.java.syntax.FileLocations;
import net.starlark.java.syntax.NodeVisitor;

public final class IntLiteral
extends Expression {
    private final String raw;
    private final int tokenOffset;
    private final Number value;

    IntLiteral(FileLocations locs, String raw, int tokenOffset, Number value) {
        super(locs, Expression.Kind.INT_LITERAL);
        this.raw = raw;
        this.tokenOffset = tokenOffset;
        this.value = value;
    }

    public Number getValue() {
        return this.value;
    }

    public String getRaw() {
        return this.raw;
    }

    @Override
    public int getStartOffset() {
        return this.tokenOffset;
    }

    @Override
    public int getEndOffset() {
        return this.tokenOffset + this.raw.length();
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    public static Number scan(String str) {
        String orig = str;
        int radix = 10;
        if (str.length() > 1 && str.charAt(0) == '0') {
            switch (str.charAt(1)) {
                case 'X': 
                case 'x': {
                    radix = 16;
                    str = str.substring(2);
                    break;
                }
                case 'O': 
                case 'o': {
                    radix = 8;
                    str = str.substring(2);
                    break;
                }
                default: {
                    throw new NumberFormatException("invalid octal literal: " + str + " (use '0o" + str.substring(1) + "')");
                }
            }
        }
        try {
            long v = Long.parseLong(str, radix);
            if (v == (long)((int)v)) {
                return (int)v;
            }
            return v;
        }
        catch (NumberFormatException v) {
            try {
                return new BigInteger(str, radix);
            }
            catch (NumberFormatException unused) {
                throw new NumberFormatException("invalid base-" + radix + " integer literal: " + orig);
            }
        }
    }
}

