/*
 * Decompiled with CFR 0.152.
 */
package net.starlark.java.syntax;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import net.starlark.java.syntax.Expression;
import net.starlark.java.syntax.FileLocations;
import net.starlark.java.syntax.NodeVisitor;
import net.starlark.java.syntax.Statement;

public final class ForStatement
extends Statement {
    private final int forOffset;
    private final Expression vars;
    private final Expression iterable;
    private final ImmutableList<Statement> body;

    ForStatement(FileLocations locs, int forOffset, Expression vars, Expression iterable, ImmutableList<Statement> body) {
        super(locs, Statement.Kind.FOR);
        this.forOffset = forOffset;
        this.vars = Preconditions.checkNotNull(vars);
        this.iterable = Preconditions.checkNotNull(iterable);
        this.body = body;
    }

    public Expression getVars() {
        return this.vars;
    }

    public Expression getCollection() {
        return this.iterable;
    }

    public ImmutableList<Statement> getBody() {
        return this.body;
    }

    @Override
    public int getStartOffset() {
        return this.forOffset;
    }

    @Override
    public int getEndOffset() {
        return this.body.isEmpty() ? this.iterable.getEndOffset() : ((Statement)this.body.get(this.body.size() - 1)).getEndOffset();
    }

    @Override
    public String toString() {
        return "for " + this.vars + " in " + this.iterable + ": ...\n";
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }
}

