/*
 * Decompiled with CFR 0.152.
 */
package net.starlark.java.syntax;

import net.starlark.java.syntax.FileLocations;
import net.starlark.java.syntax.NodeVisitor;
import net.starlark.java.syntax.Statement;
import net.starlark.java.syntax.TokenKind;

public final class FlowStatement
extends Statement {
    private final TokenKind flowKind;
    private final int offset;

    FlowStatement(FileLocations locs, TokenKind flowKind, int offset) {
        super(locs, Statement.Kind.FLOW);
        this.flowKind = flowKind;
        this.offset = offset;
    }

    public TokenKind getFlowKind() {
        return this.flowKind;
    }

    @Override
    public String toString() {
        return this.flowKind.toString() + "\n";
    }

    @Override
    public int getStartOffset() {
        return this.offset;
    }

    @Override
    public int getEndOffset() {
        return this.offset + this.flowKind.toString().length();
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }
}

