/*
 * Decompiled with CFR 0.152.
 */
package net.starlark.java.syntax;

import java.util.Arrays;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;
import net.starlark.java.syntax.Location;

@Immutable
final class FileLocations {
    private final int[] linestart;
    private final String file;
    private final int size;

    private FileLocations(int[] linestart, String file, int size) {
        this.linestart = linestart;
        this.file = file;
        this.size = size;
    }

    static FileLocations create(char[] buffer, String file) {
        return new FileLocations(FileLocations.computeLinestart(buffer), file, buffer.length);
    }

    String file() {
        return this.file;
    }

    private int getLineAt(int offset) {
        if (offset < 0 || offset > this.size) {
            throw new IllegalStateException("Illegal position: " + offset);
        }
        int lowBoundary = 1;
        int highBoundary = this.linestart.length - 1;
        while (true) {
            if (highBoundary - lowBoundary <= 1) {
                if (this.linestart[highBoundary] > offset) {
                    return lowBoundary;
                }
                return highBoundary;
            }
            int medium = lowBoundary + (highBoundary - lowBoundary >> 1);
            if (this.linestart[medium] > offset) {
                highBoundary = medium;
                continue;
            }
            lowBoundary = medium;
        }
    }

    Location getLocation(int offset) {
        int line = this.getLineAt(offset);
        int column = offset - this.linestart[line] + 1;
        return new Location(this.file, line, column);
    }

    int size() {
        return this.size;
    }

    public int hashCode() {
        return Objects.hash(Arrays.hashCode(this.linestart), this.file, this.size);
    }

    public boolean equals(Object other) {
        if (!(other instanceof FileLocations)) {
            return false;
        }
        FileLocations that = (FileLocations)other;
        return this.size == that.size && Arrays.equals(this.linestart, that.linestart) && this.file.equals(that.file);
    }

    private static int[] computeLinestart(char[] buffer) {
        int size = 2;
        for (int i = 0; i < buffer.length; ++i) {
            if (buffer[i] != '\n') continue;
            ++size;
        }
        int[] linestart = new int[size];
        int index = 0;
        linestart[index++] = 0;
        linestart[index++] = 0;
        for (int i = 0; i < buffer.length; ++i) {
            if (buffer[i] != '\n') continue;
            linestart[index++] = i + 1;
        }
        return linestart;
    }
}

