/*
 * Decompiled with CFR 0.152.
 */
package net.starlark.java.syntax;

import net.starlark.java.syntax.Expression;
import net.starlark.java.syntax.FileLocations;
import net.starlark.java.syntax.Identifier;
import net.starlark.java.syntax.Location;
import net.starlark.java.syntax.NodeVisitor;

public final class DotExpression
extends Expression {
    private final Expression object;
    private final int dotOffset;
    private final Identifier field;

    DotExpression(FileLocations locs, Expression object, int dotOffset, Identifier field) {
        super(locs, Expression.Kind.DOT);
        this.object = object;
        this.dotOffset = dotOffset;
        this.field = field;
    }

    public Expression getObject() {
        return this.object;
    }

    public Identifier getField() {
        return this.field;
    }

    @Override
    public int getStartOffset() {
        return this.object.getStartOffset();
    }

    @Override
    public int getEndOffset() {
        return this.field.getEndOffset();
    }

    public Location getDotLocation() {
        return this.locs.getLocation(this.dotOffset);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }
}

