/*
 * Decompiled with CFR 0.152.
 */
package net.starlark.java.syntax;

import java.util.EnumSet;
import net.starlark.java.syntax.Expression;
import net.starlark.java.syntax.FileLocations;
import net.starlark.java.syntax.Location;
import net.starlark.java.syntax.NodeVisitor;
import net.starlark.java.syntax.TokenKind;

public final class BinaryOperatorExpression
extends Expression {
    private final Expression x;
    private final TokenKind op;
    private final int opOffset;
    private final Expression y;
    public static final EnumSet<TokenKind> operators = EnumSet.of(TokenKind.AND, new TokenKind[]{TokenKind.EQUALS_EQUALS, TokenKind.GREATER, TokenKind.GREATER_EQUALS, TokenKind.IN, TokenKind.LESS, TokenKind.LESS_EQUALS, TokenKind.MINUS, TokenKind.NOT_EQUALS, TokenKind.NOT_IN, TokenKind.OR, TokenKind.PERCENT, TokenKind.SLASH, TokenKind.SLASH_SLASH, TokenKind.PLUS, TokenKind.PIPE, TokenKind.STAR});

    BinaryOperatorExpression(FileLocations locs, Expression x, TokenKind op, int opOffset, Expression y) {
        super(locs, Expression.Kind.BINARY_OPERATOR);
        this.x = x;
        this.op = op;
        this.opOffset = opOffset;
        this.y = y;
    }

    public Expression getX() {
        return this.x;
    }

    public TokenKind getOperator() {
        return this.op;
    }

    public Location getOperatorLocation() {
        return this.locs.getLocation(this.opOffset);
    }

    public Expression getY() {
        return this.y;
    }

    @Override
    public int getStartOffset() {
        return this.x.getStartOffset();
    }

    @Override
    public int getEndOffset() {
        return this.y.getEndOffset();
    }

    @Override
    public String toString() {
        return this.x + " " + this.op + " " + this.y;
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }
}

