/*
 * Decompiled with CFR 0.152.
 */
package net.starlark.java.eval;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import net.starlark.java.eval.CpuProfiler;
import net.starlark.java.eval.Debug;
import net.starlark.java.eval.Module;
import net.starlark.java.eval.Mutability;
import net.starlark.java.eval.Starlark;
import net.starlark.java.eval.StarlarkCallable;
import net.starlark.java.eval.StarlarkFunction;
import net.starlark.java.eval.StarlarkSemantics;
import net.starlark.java.syntax.Location;
import net.starlark.java.syntax.Resolver;

public final class StarlarkThread {
    private final Mutability mutability;
    final AtomicInteger cpuTicks = new AtomicInteger();
    @Nullable
    private CpuProfiler profiler;
    private StarlarkThread savedThread;
    private final Map<Class<?>, Object> threadLocals = new HashMap();
    private boolean interruptible = true;
    long steps;
    long stepLimit = Long.MAX_VALUE;
    private final StarlarkSemantics semantics;
    private final boolean allowRecursion;
    private PrintHandler printHandler = StarlarkThread::defaultPrintHandler;
    @Nullable
    private Loader loader = null;
    private UncheckedExceptionContext uncheckedExceptionContext = () -> "";
    private final ArrayList<Frame> callstack = new ArrayList();
    PostAssignHook postAssignHook;
    public static final String TOP_LEVEL = "<toplevel>";
    @Nullable
    private static CallProfiler callProfiler = null;

    public long getExecutedSteps() {
        return this.steps;
    }

    public void setMaxExecutionSteps(long steps) {
        this.stepLimit = steps;
    }

    void ignoreThreadInterrupts() {
        this.interruptible = false;
    }

    void checkInterrupt() throws InterruptedException {
        if (this.interruptible && Thread.interrupted()) {
            throw new InterruptedException();
        }
    }

    public <T> void setThreadLocal(Class<T> key, T value) {
        this.threadLocals.put(key, value);
    }

    public <T> T getThreadLocal(Class<T> key) {
        Object v = this.threadLocals.get(key);
        return v == null ? null : (T)key.cast(v);
    }

    void push(StarlarkCallable fn) {
        Frame fr = new Frame(this, fn);
        this.callstack.add(fr);
        if (this.callstack.size() == 1 && Debug.threadHook != null) {
            Debug.threadHook.onPushFirst(this);
        }
        fr.loc = fn.getLocation();
        CallProfiler callProfiler = StarlarkThread.callProfiler;
        if (callProfiler != null) {
            fr.profileSpan = callProfiler.start(fn);
        }
        if (this.profiler == null) {
            this.profiler = CpuProfiler.get();
            if (this.profiler != null) {
                this.cpuTicks.set(0);
                this.savedThread = CpuProfiler.setStarlarkThread(this);
            }
        }
    }

    void pop() {
        int last = this.callstack.size() - 1;
        Frame fr = this.callstack.get(last);
        if (this.profiler != null) {
            int ticks = this.cpuTicks.getAndSet(0);
            if (ticks > 0) {
                this.profiler.addEvent(ticks, this.getDebugCallStack());
            }
            if (last == 0) {
                CpuProfiler.setStarlarkThread(this.savedThread);
                this.savedThread = null;
                this.profiler = null;
            }
        }
        this.callstack.remove(last);
        CallProfiler callProfiler = StarlarkThread.callProfiler;
        if (callProfiler != null && fr.profileSpan != null) {
            callProfiler.end(fr.profileSpan);
        }
        if (last == 0 && Debug.threadHook != null) {
            Debug.threadHook.onPopLast(this);
        }
    }

    public Mutability mutability() {
        return this.mutability;
    }

    PrintHandler getPrintHandler() {
        return this.printHandler;
    }

    public void setPrintHandler(PrintHandler h2) {
        this.printHandler = Preconditions.checkNotNull(h2);
    }

    private static void defaultPrintHandler(StarlarkThread thread, String msg) {
        System.err.println(thread.getCallerLocation() + ": " + msg);
    }

    Loader getLoader() {
        return this.loader;
    }

    public void setLoader(Loader loader) {
        this.loader = Preconditions.checkNotNull(loader);
    }

    public void setUncheckedExceptionContext(UncheckedExceptionContext uncheckedExceptionContext) {
        this.uncheckedExceptionContext = Preconditions.checkNotNull(uncheckedExceptionContext);
    }

    String getContextForUncheckedException() {
        return this.uncheckedExceptionContext.getContextForUncheckedException();
    }

    boolean isRecursiveCall(StarlarkFunction fn) {
        for (int i = this.callstack.size() - 2; i >= 0; --i) {
            Frame fr = this.callstack.get(i);
            if (!(fr.fn instanceof StarlarkFunction) || !((StarlarkFunction)fr.fn).rfn.equals(fn.rfn)) continue;
            return true;
        }
        return false;
    }

    public Location getCallerLocation() {
        return this.toplevel() ? Location.BUILTIN : this.frame((int)1).loc;
    }

    private boolean toplevel() {
        return this.callstack.size() < 2;
    }

    Frame frame(int depth) {
        return this.callstack.get(this.callstack.size() - 1 - depth);
    }

    public StarlarkThread(Mutability mu, StarlarkSemantics semantics) {
        Preconditions.checkArgument(!mu.isFrozen());
        this.mutability = mu;
        this.semantics = semantics;
        this.allowRecursion = semantics.getBool("-allow_recursion");
    }

    public void setPostAssignHook(PostAssignHook postAssignHook) {
        this.postAssignHook = postAssignHook;
    }

    public StarlarkSemantics getSemantics() {
        return this.semantics;
    }

    boolean isRecursionAllowed() {
        return this.allowRecursion;
    }

    ImmutableList<Debug.Frame> getDebugCallStack() {
        return ImmutableList.copyOf(this.callstack);
    }

    @Nullable
    StarlarkFunction getInnermostEnclosingStarlarkFunction(int depth) {
        Preconditions.checkArgument(depth >= 0);
        for (int i = this.callstack.size() - 1; i >= 0; --i) {
            Debug.Frame fr = this.callstack.get(i);
            if (!(fr.getFunction() instanceof StarlarkFunction)) continue;
            if (depth == 0) {
                return (StarlarkFunction)fr.getFunction();
            }
            --depth;
        }
        return null;
    }

    int getCallStackSize() {
        return this.callstack.size();
    }

    public static CallStackEntry callStackEntry(String name, Location location) {
        return new CallStackEntry(name, location);
    }

    public ImmutableList<CallStackEntry> getCallStack() {
        ImmutableList.Builder stack = ImmutableList.builderWithExpectedSize(this.callstack.size());
        for (Frame fr : this.callstack) {
            stack.add(StarlarkThread.callStackEntry(fr.fn.getName(), fr.loc));
        }
        return stack.build();
    }

    void fillInStackTrace(Throwable throwable) {
        StackTraceElement[] trace = new StackTraceElement[this.callstack.size()];
        for (int i = 0; i < this.callstack.size(); ++i) {
            Frame frame = this.callstack.get(i);
            trace[trace.length - i - 1] = new StackTraceElement("<starlark>", frame.fn.getName(), frame.loc.file(), frame.loc.line());
        }
        throwable.setStackTrace(trace);
    }

    public int hashCode() {
        throw new UnsupportedOperationException();
    }

    public boolean equals(Object that) {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return String.format("<StarlarkThread%s>", this.mutability);
    }

    public static void setCallProfiler(@Nullable CallProfiler p) {
        callProfiler = p;
    }

    public static interface CallProfiler {
        public Object start(StarlarkCallable var1);

        public void end(Object var1);
    }

    @Immutable
    public static final class CallStackEntry {
        public final String name;
        public final Location location;

        private CallStackEntry(String name, Location location) {
            this.name = Preconditions.checkNotNull(name);
            this.location = Preconditions.checkNotNull(location);
        }

        public String toString() {
            return this.name + "@" + this.location;
        }

        public int hashCode() {
            return 31 * this.name.hashCode() + this.location.hashCode();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof CallStackEntry)) {
                return false;
            }
            CallStackEntry that = (CallStackEntry)o;
            return this.name.equals(that.name) && this.location.equals(that.location);
        }
    }

    @FunctionalInterface
    public static interface PostAssignHook {
        public void assign(String var1, Object var2);
    }

    public static interface UncheckedExceptionContext {
        public String getContextForUncheckedException();
    }

    @FunctionalInterface
    public static interface Loader {
        @Nullable
        public Module load(String var1);
    }

    @FunctionalInterface
    public static interface PrintHandler {
        public void print(StarlarkThread var1, String var2);
    }

    static final class Frame
    implements Debug.Frame {
        final StarlarkThread thread;
        final StarlarkCallable fn;
        @Nullable
        final Debug.Debugger dbg = Debug.debugger.get();
        Object result = Starlark.NONE;
        private Location loc;
        private boolean errorLocationSet;
        @Nullable
        Object[] locals;
        @Nullable
        private Object profileSpan;

        private Frame(StarlarkThread thread, StarlarkCallable fn) {
            this.thread = thread;
            this.fn = fn;
        }

        void setLocation(Location loc) {
            this.loc = loc;
        }

        void setErrorLocation(Location loc) {
            if (!this.errorLocationSet) {
                this.errorLocationSet = true;
                this.loc = loc;
            }
        }

        @Override
        public StarlarkCallable getFunction() {
            return this.fn;
        }

        @Override
        public Location getLocation() {
            return this.loc;
        }

        @Override
        public ImmutableMap<String, Object> getLocals() {
            ImmutableMap.Builder<String, Object> env = ImmutableMap.builder();
            if (this.fn instanceof StarlarkFunction) {
                for (int i = 0; i < this.locals.length; ++i) {
                    Object local = this.locals[i];
                    if (local == null) continue;
                    if (local instanceof StarlarkFunction.Cell) {
                        local = ((StarlarkFunction.Cell)local).x;
                    }
                    env.put(((Resolver.Binding)((StarlarkFunction)this.fn).rfn.getLocals().get(i)).getName(), local);
                }
            }
            return env.buildOrThrow();
        }

        public String toString() {
            return this.fn.getName() + "@" + this.loc;
        }
    }
}

