/*
 * Decompiled with CFR 0.152.
 */
package net.starlark.java.eval;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Map;
import java.util.TreeMap;

public final class StarlarkSemantics {
    public static final StarlarkSemantics DEFAULT = new StarlarkSemantics(ImmutableMap.of());
    private final ImmutableMap<String, Object> map;
    private final int hashCode;
    public static final String PRINT_TEST_MARKER = "-print_test_marker";
    public static final String ALLOW_RECURSION = "-allow_recursion";

    private StarlarkSemantics(ImmutableMap<String, Object> map) {
        this.map = map;
        this.hashCode = map.hashCode();
    }

    public boolean getBool(String name) {
        char prefix = name.charAt(0);
        Preconditions.checkArgument(prefix == '+' || prefix == '-');
        boolean defaultValue = prefix == '+';
        Boolean v = (Boolean)this.map.get(name);
        return v != null ? v : defaultValue;
    }

    public <T> T get(Key<T> key) {
        Object v = this.map.get(key.name);
        return (T)(v != null ? v : key.defaultValue);
    }

    public Object getGeneric(String name, Object defaultValue) {
        Object v = this.map.get(name);
        if (v == null) {
            v = this.map.get("+" + name);
        }
        if (v == null) {
            v = this.map.get("-" + name);
        }
        return v != null ? v : defaultValue;
    }

    public Builder toBuilder() {
        return new Builder(new TreeMap<String, Object>(this.map));
    }

    public static Builder builder() {
        return new Builder(new TreeMap<String, Object>());
    }

    boolean isFeatureEnabledBasedOnTogglingFlags(String enablingFlag, String disablingFlag) {
        Preconditions.checkArgument(enablingFlag.isEmpty() || disablingFlag.isEmpty(), "at least one of 'enablingFlag' or 'disablingFlag' must be empty");
        if (!enablingFlag.isEmpty()) {
            return this.getBool(enablingFlag);
        }
        if (!disablingFlag.isEmpty()) {
            return !this.getBool(disablingFlag);
        }
        return true;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object that) {
        return this == that || that instanceof StarlarkSemantics && this.map.equals(((StarlarkSemantics)that).map);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("StarlarkSemantics{");
        String sep = "";
        for (Map.Entry e : this.map.entrySet()) {
            String key = (String)e.getKey();
            buf.append(sep);
            sep = ", ";
            if (key.charAt(0) == '+' || key.charAt(0) == '-') {
                buf.append(key, 1, key.length());
            } else {
                buf.append(key);
            }
            buf.append('=').append(e.getValue());
        }
        return buf.append('}').toString();
    }

    public static final class Builder {
        private final TreeMap<String, Object> map;

        private Builder(TreeMap<String, Object> map) {
            this.map = map;
        }

        @CanIgnoreReturnValue
        public <T> Builder set(Key<T> key, T value) {
            if (!value.equals(key.defaultValue)) {
                this.map.put(key.name, value);
            } else {
                this.map.remove(key.name);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setBool(String name, boolean value) {
            boolean defaultValue;
            char prefix = name.charAt(0);
            Preconditions.checkArgument(prefix == '+' || prefix == '-');
            boolean bl = defaultValue = prefix == '+';
            if (value != defaultValue) {
                this.map.put(name, value);
            } else {
                this.map.remove(name);
            }
            return this;
        }

        public StarlarkSemantics build() {
            return new StarlarkSemantics(ImmutableMap.copyOf(this.map));
        }
    }

    public static class Key<T> {
        public final String name;
        public final T defaultValue;

        public Key(String name, T defaultValue) {
            char prefix = name.charAt(0);
            Preconditions.checkArgument(prefix != '-' && prefix != '+');
            this.name = name;
            this.defaultValue = Preconditions.checkNotNull(defaultValue);
        }

        public String toString() {
            return this.name;
        }
    }
}

