/*
 * Decompiled with CFR 0.152.
 */
package net.starlark.java.eval;

import com.google.common.collect.Iterables;
import java.util.AbstractList;
import java.util.Arrays;
import javax.annotation.Nullable;
import net.starlark.java.annot.Param;
import net.starlark.java.annot.ParamType;
import net.starlark.java.annot.StarlarkBuiltin;
import net.starlark.java.annot.StarlarkMethod;
import net.starlark.java.eval.EvalException;
import net.starlark.java.eval.EvalUtils;
import net.starlark.java.eval.ImmutableSingletonStarlarkList;
import net.starlark.java.eval.ImmutableStarlarkList;
import net.starlark.java.eval.Mutability;
import net.starlark.java.eval.MutableStarlarkList;
import net.starlark.java.eval.NoneType;
import net.starlark.java.eval.Printer;
import net.starlark.java.eval.RangeList;
import net.starlark.java.eval.Sequence;
import net.starlark.java.eval.Starlark;
import net.starlark.java.eval.StarlarkInt;
import net.starlark.java.eval.StarlarkValue;

@StarlarkBuiltin(name="list", category="core", doc="The built-in list type. Example list expressions:<br><pre class=language-python>x = [1, 2, 3]</pre>Accessing elements is possible using indexing (starts from <code>0</code>):<br><pre class=language-python>e = x[1]   # e == 2</pre>Lists support the <code>+</code> operator to concatenate two lists. Example:<br><pre class=language-python>x = [1, 2] + [3, 4]   # x == [1, 2, 3, 4]\nx = [\"a\", \"b\"]\nx += [\"c\"]            # x == [\"a\", \"b\", \"c\"]</pre>Similar to strings, lists support slice operations:<pre class=language-python>['a', 'b', 'c', 'd'][1:3]   # ['b', 'c']\n['a', 'b', 'c', 'd'][::2]  # ['a', 'c']\n['a', 'b', 'c', 'd'][3:0:-1]  # ['d', 'c', 'b']</pre>Lists are mutable, as in Python.")
public abstract class StarlarkList<E>
extends AbstractList<E>
implements Sequence<E>,
StarlarkValue,
Mutability.Freezable,
Comparable<StarlarkList<?>> {
    static final int MAX_ALLOC = 0x40000000;
    static final Object[] EMPTY_ARRAY = new Object[0];
    private static final StarlarkList<?> EMPTY = new ImmutableStarlarkList(EMPTY_ARRAY);

    StarlarkList() {
    }

    static <T> StarlarkList<T> wrap(@Nullable Mutability mutability, Object[] elems) {
        if (mutability == null || mutability.isFrozen()) {
            switch (elems.length) {
                case 0: {
                    return StarlarkList.empty();
                }
                case 1: {
                    return new ImmutableSingletonStarlarkList(elems[0]);
                }
            }
            return new ImmutableStarlarkList(elems);
        }
        return new MutableStarlarkList(mutability, elems, elems.length);
    }

    @Override
    public void checkHashable() throws EvalException {
        throw Starlark.errorf("unhashable type: 'list'", new Object[0]);
    }

    public static <T> StarlarkList<T> empty() {
        return EMPTY;
    }

    public static <T> StarlarkList<T> newList(Mutability mutability) {
        return StarlarkList.wrap(mutability, EMPTY_ARRAY);
    }

    public static <T> StarlarkList<T> copyOf(@Nullable Mutability mutability, Iterable<? extends T> elems) {
        if (mutability == null && elems instanceof StarlarkList && ((StarlarkList)elems).isImmutable()) {
            StarlarkList list = (StarlarkList)elems;
            return list;
        }
        Object[] array = Iterables.toArray(elems, Object.class);
        StarlarkList.checkElemsValid(array);
        return StarlarkList.wrap(mutability, array);
    }

    private static void checkElemsValid(Object[] elems) {
        for (Object elem : elems) {
            Starlark.checkValid(elem);
        }
    }

    public static <T> StarlarkList<T> immutableCopyOf(Iterable<? extends T> elems) {
        return StarlarkList.copyOf(null, elems);
    }

    public static <T> StarlarkList<T> of(@Nullable Mutability mutability, T ... elems) {
        if (elems.length == 0) {
            return StarlarkList.newList(mutability);
        }
        StarlarkList.checkElemsValid(elems);
        return StarlarkList.wrap(mutability, Arrays.copyOf(elems, elems.length, Object[].class));
    }

    public static <T> StarlarkList<T> immutableOf(T ... elems) {
        StarlarkList.checkElemsValid(elems);
        return StarlarkList.wrap(null, Arrays.copyOf(elems, elems.length, Object[].class));
    }

    abstract Object[] elems();

    public static <T> StarlarkList<T> concat(StarlarkList<? extends T> x, StarlarkList<? extends T> y, Mutability mutability) {
        int xsize = x.size();
        int ysize = y.size();
        Object[] res = new Object[xsize + ysize];
        System.arraycopy(x.elems(), 0, res, 0, xsize);
        System.arraycopy(y.elems(), 0, res, xsize, ysize);
        return StarlarkList.wrap(mutability, res);
    }

    @Override
    public int compareTo(StarlarkList<?> that) {
        return Sequence.compare(this, that);
    }

    @Override
    public boolean equals(Object that) {
        return this == that || that instanceof StarlarkList && Sequence.sameElems(this, (StarlarkList)that);
    }

    @Override
    public int hashCode() {
        int result = 1;
        int size = this.size();
        Object[] elems = this.elems();
        for (int i = 0; i < size; ++i) {
            result = 31 * result + elems[i].hashCode();
        }
        return 6047 + 4673 * result;
    }

    @Override
    public void repr(Printer printer) {
        printer.printList(this, "[", ", ", "]");
    }

    @Override
    public String toString() {
        return Starlark.repr(this);
    }

    public StarlarkList<E> repeat(StarlarkInt n, Mutability mutability) throws EvalException {
        int size;
        if (n.signum() <= 0) {
            return StarlarkList.wrap(mutability, EMPTY_ARRAY);
        }
        int ni = n.toInt("repeat");
        long sz = (long)ni * (long)(size = this.size());
        if (sz > 0x40000000L) {
            throw Starlark.errorf("excessive repeat (%d * %d elements)", size, ni);
        }
        Object[] res = new Object[(int)sz];
        for (int i = 0; i < ni; ++i) {
            System.arraycopy(this.elems(), 0, res, i * size, size);
        }
        return StarlarkList.wrap(mutability, res);
    }

    @Override
    public StarlarkList<E> getSlice(Mutability mu, int start, int stop, int step) throws EvalException {
        RangeList indices = new RangeList(start, stop, step);
        int n = indices.size();
        Object[] res = new Object[n];
        if (step == 1) {
            System.arraycopy(this.elems(), indices.at(0), res, 0, n);
        } else {
            Object[] elems = this.elems();
            for (int i = 0; i < n; ++i) {
                res[i] = elems[indices.at(i)];
            }
        }
        return StarlarkList.wrap(mu, res);
    }

    public abstract void addElement(E var1) throws EvalException;

    public abstract void addElementAt(int var1, E var2) throws EvalException;

    public abstract void addElements(Iterable<? extends E> var1) throws EvalException;

    public abstract void removeElementAt(int var1) throws EvalException;

    public abstract void setElementAt(int var1, E var2) throws EvalException;

    @StarlarkMethod(name="remove", doc="Removes the first item from the list whose value is x. It is an error if there is no such item.", parameters={@Param(name="x", doc="The object to remove.")})
    public void removeElement(Object x) throws EvalException {
        int size = this.size();
        Object[] elems = this.elems();
        for (int i = 0; i < size; ++i) {
            if (!elems[i].equals(x)) continue;
            this.removeElementAt(i);
            return;
        }
        throw Starlark.errorf("item %s not found in list", Starlark.repr(x));
    }

    @StarlarkMethod(name="append", doc="Adds an item to the end of the list.", parameters={@Param(name="item", doc="Item to add at the end.")})
    public void append(Object item) throws EvalException {
        this.addElement(item);
    }

    @StarlarkMethod(name="clear", doc="Removes all the elements of the list.")
    public abstract void clearElements() throws EvalException;

    @StarlarkMethod(name="insert", doc="Inserts an item at a given position.", parameters={@Param(name="index", doc="The index of the given position."), @Param(name="item", doc="The item.")})
    public void insert(StarlarkInt index, Object item) throws EvalException {
        this.addElementAt(EvalUtils.toIndex(index.toInt("index"), this.size()), item);
    }

    @StarlarkMethod(name="extend", doc="Adds all items to the end of the list.", parameters={@Param(name="items", doc="Items to add at the end.")})
    public void extend(Object items) throws EvalException {
        Iterable<?> src = Starlark.toIterable(items);
        this.addElements(src);
    }

    @StarlarkMethod(name="index", doc="Returns the index in the list of the first item whose value is x. It is an error if there is no such item.", parameters={@Param(name="x", doc="The object to search."), @Param(name="start", allowedTypes={@ParamType(type=StarlarkInt.class), @ParamType(type=NoneType.class)}, defaultValue="None", named=true, doc="The start index of the list portion to inspect."), @Param(name="end", allowedTypes={@ParamType(type=StarlarkInt.class), @ParamType(type=NoneType.class)}, defaultValue="None", named=true, doc="The end index of the list portion to inspect.")})
    public int index(Object x, Object start, Object end) throws EvalException {
        int j;
        int size = this.size();
        Object[] elems = this.elems();
        int n = j = end == Starlark.NONE ? size : EvalUtils.toIndex(Starlark.toInt(end, "end"), size);
        for (int i = start == Starlark.NONE ? 0 : EvalUtils.toIndex(Starlark.toInt(start, "start"), size); i < j; ++i) {
            if (!elems[i].equals(x)) continue;
            return i;
        }
        throw Starlark.errorf("item %s not found in list", Starlark.repr(x));
    }

    @StarlarkMethod(name="pop", doc="Removes the item at the given position in the list, and returns it. If no <code>index</code> is specified, it removes and returns the last item in the list.", parameters={@Param(name="i", allowedTypes={@ParamType(type=StarlarkInt.class), @ParamType(type=NoneType.class)}, defaultValue="-1", doc="The index of the item.")})
    public Object pop(Object i) throws EvalException {
        int size = this.size();
        Object[] elems = this.elems();
        int arg = i == Starlark.NONE ? -1 : Starlark.toInt(i, "i");
        int index = EvalUtils.getSequenceIndex(arg, size);
        Object result = elems[index];
        this.removeElementAt(index);
        return result;
    }

    public StarlarkList<E> unsafeOptimizeMemoryLayout() {
        return this;
    }
}

