/*
 * Decompiled with CFR 0.152.
 */
package net.starlark.java.eval;

import com.google.common.collect.Maps;
import java.util.LinkedHashMap;
import net.starlark.java.eval.Dict;
import net.starlark.java.eval.EvalException;
import net.starlark.java.eval.Starlark;
import net.starlark.java.eval.StarlarkThread;
import net.starlark.java.eval.StarlarkValue;
import net.starlark.java.eval.Tuple;
import net.starlark.java.syntax.Location;

public interface StarlarkCallable
extends StarlarkValue {
    default public Object call(StarlarkThread thread, Tuple args, Dict<String, Object> kwargs) throws EvalException, InterruptedException {
        throw Starlark.errorf("function %s not implemented", this.getName());
    }

    default public Object fastcall(StarlarkThread thread, Object[] positional, Object[] named) throws EvalException, InterruptedException {
        LinkedHashMap<String, Object> kwargs = Maps.newLinkedHashMapWithExpectedSize(named.length >> 1);
        for (int i = 0; i < named.length; i += 2) {
            if (kwargs.put((String)named[i], named[i + 1]) == null) continue;
            throw Starlark.errorf("%s got multiple values for parameter '%s'", this, named[i]);
        }
        return this.call(thread, Tuple.of(positional), Dict.wrap(thread.mutability(), kwargs));
    }

    public String getName();

    default public Location getLocation() {
        return Location.BUILTIN;
    }
}

