/*
 * Decompiled with CFR 0.152.
 */
package net.starlark.java.eval;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.RandomAccess;
import net.starlark.java.eval.EvalException;
import net.starlark.java.eval.EvalUtils;
import net.starlark.java.eval.Mutability;
import net.starlark.java.eval.Starlark;
import net.starlark.java.eval.StarlarkIndexable;
import net.starlark.java.eval.StarlarkIterable;
import net.starlark.java.eval.StarlarkList;
import net.starlark.java.eval.StarlarkSemantics;
import net.starlark.java.eval.StarlarkValue;

public interface Sequence<E>
extends StarlarkValue,
List<E>,
RandomAccess,
StarlarkIndexable,
StarlarkIterable<E> {
    @Override
    default public boolean truth() {
        return !this.isEmpty();
    }

    default public ImmutableList<E> getImmutableList() {
        return ImmutableList.copyOf(this);
    }

    default public E getIndex(StarlarkSemantics semantics, Object key) throws EvalException {
        int index = Starlark.toInt(key, "sequence index");
        return this.get(EvalUtils.getSequenceIndex(index, this.size()));
    }

    @Override
    default public boolean containsKey(StarlarkSemantics semantics, Object key) throws EvalException {
        return this.contains(key);
    }

    public static int compare(List<?> x, List<?> y) {
        for (int i = 0; i < Math.min(x.size(), y.size()); ++i) {
            Object yelem;
            Object xelem = x.get(i);
            if (xelem == (yelem = y.get(i)) || xelem.equals(yelem)) continue;
            int cmp = Starlark.compareUnchecked(xelem, yelem);
            if (cmp == 0) {
                throw new IllegalStateException(String.format("x.equals(y) yet x.compareTo(y)==%d (x: %s, y: %s)", cmp, Starlark.type(xelem), Starlark.type(yelem)));
            }
            return cmp;
        }
        return Integer.compare(x.size(), y.size());
    }

    public static boolean sameElems(List<?> x, List<?> y) {
        if (x == y) {
            return true;
        }
        if (x.size() != y.size()) {
            return false;
        }
        for (int i = 0; i < x.size(); ++i) {
            Object yelem;
            Object xelem = x.get(i);
            if (xelem == (yelem = y.get(i)) || xelem.equals(yelem)) continue;
            return false;
        }
        return true;
    }

    public Sequence<E> getSlice(Mutability var1, int var2, int var3, int var4) throws EvalException;

    public static <T> Sequence<T> cast(Object x, Class<T> elemType, String what) throws EvalException {
        Preconditions.checkNotNull(x);
        if (!(x instanceof Sequence)) {
            throw Starlark.errorf("for %s, got %s, want sequence", what, Starlark.type(x));
        }
        int i = 0;
        for (Object elem : (Sequence)x) {
            if (!elemType.isAssignableFrom(elem.getClass())) {
                throw Starlark.errorf("at index %d of %s, got element of type %s, want %s", i, what, Starlark.type(elem), Starlark.classType(elemType));
            }
            ++i;
        }
        Sequence result = (Sequence)x;
        return result;
    }

    public static <T> Sequence<T> noneableCast(Object x, Class<T> type, String what) throws EvalException {
        return x == Starlark.NONE ? StarlarkList.empty() : Sequence.cast(x, type, what);
    }
}

