/*
 * Decompiled with CFR 0.152.
 */
package net.starlark.java.eval;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import net.starlark.java.eval.EvalException;
import net.starlark.java.eval.Mutability;
import net.starlark.java.eval.Printer;
import net.starlark.java.eval.RangeList;
import net.starlark.java.eval.Starlark;
import net.starlark.java.eval.StarlarkInt;
import net.starlark.java.eval.Tuple;

final class RegularTuple
extends Tuple {
    final Object[] elems;

    RegularTuple(Object[] elems) {
        Preconditions.checkArgument(elems.length != 1);
        this.elems = elems;
    }

    @Override
    public boolean isImmutable() {
        for (Object x : this.elems) {
            if (Starlark.isImmutable(x)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void checkHashable() throws EvalException {
        for (Object x : this.elems) {
            Starlark.checkHashable(x);
        }
    }

    @Override
    public int hashCode() {
        return 9857 + 8167 * Arrays.hashCode(this.elems);
    }

    @Override
    public Object get(int i) {
        return this.elems[i];
    }

    @Override
    public int size() {
        return this.elems.length;
    }

    @Override
    public boolean contains(Object o) {
        if (o == null) {
            return false;
        }
        for (Object elem : this.elems) {
            if (!o.equals(elem)) continue;
            return true;
        }
        return false;
    }

    public Tuple subList(int from, int to) {
        Preconditions.checkPositionIndexes(from, to, this.elems.length);
        return RegularTuple.wrap(Arrays.copyOfRange(this.elems, from, to));
    }

    @Override
    public Object[] toArray() {
        return this.elems.length != 0 ? Arrays.copyOf(this.elems, this.elems.length, Object[].class) : this.elems;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        if (a.length < this.elems.length) {
            return Arrays.copyOf(this.elems, this.elems.length, a.getClass());
        }
        System.arraycopy(this.elems, 0, a, 0, this.elems.length);
        Arrays.fill(a, this.elems.length, a.length, null);
        return a;
    }

    @Override
    public void repr(Printer printer) {
        printer.append('(');
        String sep = "";
        for (Object elem : this.elems) {
            printer.append(sep);
            sep = ", ";
            printer.repr(elem);
        }
        printer.append(')');
    }

    @Override
    public ImmutableList<Object> getImmutableList() {
        return RegularTuple.wrapImmutable(this.elems);
    }

    public Tuple getSlice(Mutability mu, int start, int stop, int step) throws EvalException {
        RangeList indices = new RangeList(start, stop, step);
        int n = indices.size();
        if (step == 1) {
            return this.subList(indices.at(0), indices.at(n));
        }
        Object[] res = new Object[n];
        for (int i = 0; i < n; ++i) {
            res[i] = this.elems[indices.at(i)];
        }
        return RegularTuple.wrap(res);
    }

    @Override
    Tuple repeat(StarlarkInt n) throws EvalException {
        if (n.signum() <= 0 || this.isEmpty()) {
            return RegularTuple.empty();
        }
        int ni = n.toInt("repeat");
        long sz = (long)ni * (long)this.elems.length;
        if (sz > 0x40000000L) {
            throw Starlark.errorf("excessive repeat (%d * %d elements)", this.elems.length, ni);
        }
        Object[] res = new Object[(int)sz];
        for (int i = 0; i < ni; ++i) {
            System.arraycopy(this.elems, 0, res, i * this.elems.length, this.elems.length);
        }
        return RegularTuple.wrap(res);
    }
}

