/*
 * Decompiled with CFR 0.152.
 */
package net.starlark.java.eval;

import com.google.common.base.Preconditions;
import com.google.common.collect.UnmodifiableIterator;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;
import net.starlark.java.annot.StarlarkBuiltin;
import net.starlark.java.eval.EvalException;
import net.starlark.java.eval.Mutability;
import net.starlark.java.eval.Printer;
import net.starlark.java.eval.Sequence;
import net.starlark.java.eval.Starlark;
import net.starlark.java.eval.StarlarkInt;

@StarlarkBuiltin(name="range", category="core", doc="A language built-in type to support ranges. Example of range literal:<br><pre class=language-python>x = range(1, 10, 3)</pre>Accessing elements is possible using indexing (starts from <code>0</code>):<br><pre class=language-python>e = x[1]   # e == 2</pre>Ranges do not support the <code>+</code> operator for concatenation.Similar to strings, ranges support slice operations:<pre class=language-python>range(10)[1:3]   # range(1, 3)\nrange(10)[::2]  # range(0, 10, 2)\nrange(10)[3:0:-1]  # range(3, 0, -1)</pre>Ranges are immutable, as in Python 3.")
@Immutable
final class RangeList
extends AbstractList<StarlarkInt>
implements Sequence<StarlarkInt> {
    private final int start;
    private final int stop;
    private final int step;
    private final int size;

    RangeList(int start, int stop, int step) throws EvalException {
        long absStep;
        int high;
        int low;
        Preconditions.checkArgument(step != 0);
        this.start = start;
        this.stop = stop;
        this.step = step;
        if (step > 0) {
            low = start;
            high = stop;
            absStep = step;
        } else {
            low = stop;
            high = start;
            absStep = -((long)step);
        }
        if (low >= high) {
            this.size = 0;
        } else {
            long diff = (long)high - (long)low - 1L;
            long size = diff / absStep + 1L;
            if ((long)((int)size) != size) {
                throw Starlark.errorf("len(%s) exceeds signed 32-bit range", Starlark.repr(this));
            }
            this.size = (int)size;
        }
    }

    @Override
    public boolean contains(Object x) {
        if (!(x instanceof StarlarkInt)) {
            return false;
        }
        try {
            int i = ((StarlarkInt)x).toIntUnchecked();
            if (this.step > 0) {
                return this.start <= i && i < this.stop && (i - this.start) % this.step == 0;
            }
            return this.stop < i && i <= this.start && (i - this.start) % this.step == 0;
        }
        catch (IllegalArgumentException ex) {
            return false;
        }
    }

    @Override
    public StarlarkInt get(int index) {
        if (index < 0 || index >= this.size()) {
            throw new ArrayIndexOutOfBoundsException(index + ":" + this);
        }
        return StarlarkInt.of(this.at(index));
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public int hashCode() {
        if (this.size == 0) {
            return 234982346;
        }
        if (this.size == 1) {
            return Integer.hashCode(this.start);
        }
        return Objects.hash(this.start, this.size, this.step);
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof RangeList)) {
            return false;
        }
        RangeList that = (RangeList)other;
        if (this.size != that.size) {
            return false;
        }
        if (this.size == 0) {
            return true;
        }
        if (this.start != that.start) {
            return false;
        }
        return this.size == 1 || this.step == that.step;
    }

    @Override
    public Iterator<StarlarkInt> iterator() {
        return new UnmodifiableIterator<StarlarkInt>(){
            long cursor;
            {
                this.cursor = RangeList.this.start;
            }

            @Override
            public boolean hasNext() {
                return RangeList.this.step > 0 ? this.cursor < (long)RangeList.this.stop : this.cursor > (long)RangeList.this.stop;
            }

            @Override
            public StarlarkInt next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                int current = (int)this.cursor;
                this.cursor += (long)RangeList.this.step;
                return StarlarkInt.of(current);
            }
        };
    }

    @Override
    public Sequence<StarlarkInt> getSlice(Mutability mu, int start, int stop, int step) throws EvalException {
        long sliceStep = (long)step * (long)this.step;
        if (sliceStep != (long)((int)sliceStep)) {
            long l = sliceStep = sliceStep > 0L ? Integer.MAX_VALUE : Integer.MIN_VALUE;
            if (stop > start) {
                stop = start + 1;
            } else if (stop < start) {
                stop = start - 1;
            }
        }
        return new RangeList(this.at(start), this.at(stop), (int)sliceStep);
    }

    int at(int i) {
        return this.start + this.step * i;
    }

    @Override
    public void repr(Printer printer) {
        if (this.step == 1) {
            printer.append(String.format("range(%d, %d)", this.start, this.stop));
        } else {
            printer.append(String.format("range(%d, %d, %d)", this.start, this.stop, this.step));
        }
    }
}

