/*
 * Decompiled with CFR 0.152.
 */
package net.starlark.java.eval;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Collection;
import javax.annotation.Nullable;
import net.starlark.java.eval.EvalException;
import net.starlark.java.eval.Mutability;
import net.starlark.java.eval.Starlark;
import net.starlark.java.eval.StarlarkList;
import net.starlark.java.eval.Tuple;

final class MutableStarlarkList<E>
extends StarlarkList<E> {
    private int size;
    private int iteratorCount;
    Object[] elems = StarlarkList.EMPTY_ARRAY;
    private Mutability mutability;

    MutableStarlarkList(@Nullable Mutability mutability, Object[] elems, int size) {
        Preconditions.checkArgument(elems.getClass() == Object[].class);
        this.elems = elems;
        this.size = size;
        this.mutability = mutability == null ? Mutability.IMMUTABLE : mutability;
    }

    @Override
    public boolean isImmutable() {
        return this.mutability().isFrozen();
    }

    @Override
    public boolean updateIteratorCount(int delta) {
        if (this.mutability().isFrozen()) {
            return false;
        }
        if (delta > 0) {
            ++this.iteratorCount;
        } else if (delta < 0) {
            --this.iteratorCount;
        }
        return this.iteratorCount > 0;
    }

    @Override
    public Mutability mutability() {
        return this.mutability;
    }

    @Override
    public void unsafeShallowFreeze() {
        Mutability.Freezable.checkUnsafeShallowFreezePrecondition(this);
        this.mutability = Mutability.IMMUTABLE;
    }

    @Override
    public ImmutableList<E> getImmutableList() {
        if (this.elems.length == this.size && this.mutability().isFrozen()) {
            return Tuple.wrapImmutable(this.elems);
        }
        return ImmutableList.copyOf(this);
    }

    @Override
    public E get(int i) {
        Preconditions.checkElementIndex(i, this.size);
        return (E)this.elems[i];
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean contains(Object o) {
        if (o == null) {
            return false;
        }
        for (int i = 0; i < this.size; ++i) {
            Object elem = this.elems[i];
            if (!o.equals(elem)) continue;
            return true;
        }
        return false;
    }

    private void grow(int mincap) {
        int oldcap = this.elems.length;
        if (oldcap < mincap) {
            int newcap = oldcap + (oldcap >> 1);
            if (newcap < mincap) {
                newcap = mincap;
            }
            this.elems = Arrays.copyOf(this.elems, newcap);
        }
    }

    private void growAdditional(int additional) throws EvalException {
        int mincap = this.size + additional;
        if (mincap < 0 || mincap > 0x40000000) {
            throw Starlark.errorf("excessive capacity requested (%d + %d elements)", this.size, additional);
        }
        this.grow(mincap);
    }

    @Override
    public void addElement(E element) throws EvalException {
        Starlark.checkMutable(this);
        this.growAdditional(1);
        this.elems[this.size++] = element;
    }

    @Override
    public void addElementAt(int index, E element) throws EvalException {
        Starlark.checkMutable(this);
        this.growAdditional(1);
        System.arraycopy(this.elems, index, this.elems, index + 1, this.size - index);
        this.elems[index] = element;
        ++this.size;
    }

    @Override
    public void addElements(Iterable<? extends E> elements) throws EvalException {
        Starlark.checkMutable(this);
        if (elements instanceof MutableStarlarkList) {
            MutableStarlarkList that = (MutableStarlarkList)elements;
            this.growAdditional(that.size);
            System.arraycopy(that.elems, 0, this.elems, this.size, that.size);
            this.size += that.size;
        } else if (elements instanceof Collection) {
            Collection that = (Collection)elements;
            this.growAdditional(that.size());
            for (Object x : that) {
                this.elems[this.size++] = x;
            }
        } else {
            for (E x : elements) {
                this.growAdditional(1);
                this.elems[this.size++] = x;
            }
        }
    }

    @Override
    public void removeElementAt(int index) throws EvalException {
        Starlark.checkMutable(this);
        int n = this.size - index - 1;
        if (n > 0) {
            System.arraycopy(this.elems, index + 1, this.elems, index, n);
        }
        this.elems[--this.size] = null;
    }

    @Override
    public void setElementAt(int index, E value) throws EvalException {
        Starlark.checkMutable(this);
        Preconditions.checkArgument(index < this.size);
        this.elems[index] = value;
    }

    @Override
    public void clearElements() throws EvalException {
        Starlark.checkMutable(this);
        for (int i = 0; i < this.size; ++i) {
            this.elems[i] = null;
        }
        this.size = 0;
    }

    @Override
    public Object[] toArray() {
        return this.size != 0 ? Arrays.copyOf(this.elems, this.size, Object[].class) : EMPTY_ARRAY;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        if (a.length < this.size) {
            return Arrays.copyOf(this.elems, this.size, a.getClass());
        }
        System.arraycopy(this.elems, 0, a, 0, this.size);
        Arrays.fill(a, this.size, a.length, null);
        return a;
    }

    @Override
    Object[] elems() {
        return this.elems;
    }

    @Override
    public StarlarkList<E> unsafeOptimizeMemoryLayout() {
        Preconditions.checkState(this.mutability.isFrozen());
        this.mutability = Mutability.IMMUTABLE;
        if (this.elems.length > this.size) {
            this.elems = Arrays.copyOf(this.elems, this.size);
        }
        return MutableStarlarkList.wrap(this.mutability, this.elems);
    }
}

