/*
 * Decompiled with CFR 0.152.
 */
package net.starlark.java.eval;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import net.starlark.java.eval.EvalException;
import net.starlark.java.eval.Mutability;
import net.starlark.java.eval.Starlark;
import net.starlark.java.eval.StarlarkList;

final class ImmutableSingletonStarlarkList<E>
extends StarlarkList<E> {
    final Object elem;

    ImmutableSingletonStarlarkList(Object elem) {
        this.elem = elem;
    }

    @Override
    public boolean isImmutable() {
        return true;
    }

    @Override
    public boolean updateIteratorCount(int delta) {
        return false;
    }

    @Override
    public Mutability mutability() {
        return Mutability.IMMUTABLE;
    }

    @Override
    public void unsafeShallowFreeze() {
        Mutability.Freezable.checkUnsafeShallowFreezePrecondition(this);
    }

    @Override
    public ImmutableList<E> getImmutableList() {
        return ImmutableList.of(this.elem);
    }

    @Override
    public E get(int i) {
        Preconditions.checkElementIndex(i, 1);
        return (E)this.elem;
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public boolean contains(Object o) {
        if (o == null) {
            return false;
        }
        return o.equals(this.elem);
    }

    @Override
    public void addElement(E element) throws EvalException {
        Starlark.checkMutable(this);
    }

    @Override
    public void addElementAt(int index, E element) throws EvalException {
        Starlark.checkMutable(this);
    }

    @Override
    public void addElements(Iterable<? extends E> elements) throws EvalException {
        Starlark.checkMutable(this);
    }

    @Override
    public void removeElementAt(int index) throws EvalException {
        Starlark.checkMutable(this);
    }

    @Override
    public void setElementAt(int index, E value) throws EvalException {
        Starlark.checkMutable(this);
    }

    @Override
    public void clearElements() throws EvalException {
        Starlark.checkMutable(this);
    }

    @Override
    public Object[] toArray() {
        return new Object[]{this.elem};
    }

    @Override
    public <T> T[] toArray(T[] a) {
        if (a.length < 1) {
            return new Object[]{this.elem};
        }
        a[0] = this.elem;
        Arrays.fill(a, 1, a.length, null);
        return a;
    }

    @Override
    Object[] elems() {
        return new Object[]{this.elem};
    }
}

