/*
 * Decompiled with CFR 0.152.
 */
package net.starlark.java.eval;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.io.Files;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.starlark.java.eval.StarlarkThread;
import net.starlark.java.syntax.Location;

public class EvalException
extends Exception {
    @Nullable
    private ImmutableList<StarlarkThread.CallStackEntry> callstack;
    private static Supplier<SourceReader> sourceReaderSupplier = () -> loc -> {
        try {
            String content = Files.asCharSource(new File(loc.file()), StandardCharsets.UTF_8).read();
            return Iterables.get(Splitter.on("\n").split(content), loc.line() - 1, null);
        }
        catch (Throwable throwable) {
            return null;
        }
    };

    public EvalException(String message) {
        this(message, null);
    }

    public EvalException(String message, @Nullable Throwable cause) {
        super(Preconditions.checkNotNull(message), cause);
    }

    public EvalException(Throwable cause) {
        super(EvalException.getCauseMessage(cause), cause);
    }

    private static String getCauseMessage(Throwable cause) {
        String msg = cause.getMessage();
        return msg != null ? msg : cause.toString();
    }

    @Override
    public final String getMessage() {
        return super.getMessage();
    }

    public final ImmutableList<StarlarkThread.CallStackEntry> getCallStack() {
        return this.callstack != null ? this.callstack : ImmutableList.of();
    }

    @Override
    public String toString() {
        return this.getMessageWithStack();
    }

    public final String getMessageWithStack() {
        return this.getMessageWithStack(EvalException.newSourceReader());
    }

    public final String getMessageWithStack(SourceReader src) {
        if (this.callstack != null) {
            return EvalException.formatCallStack(this.callstack, this.getMessage(), src);
        }
        return this.getMessage();
    }

    public static synchronized void setSourceReaderSupplier(Supplier<SourceReader> f) {
        sourceReaderSupplier = f;
    }

    public static synchronized SourceReader newSourceReader() {
        return sourceReaderSupplier.get();
    }

    public static String formatCallStack(List<StarlarkThread.CallStackEntry> callstack, String message, SourceReader src) {
        StringBuilder buf = new StringBuilder();
        int n = callstack.size();
        Object prefix = "Error: ";
        StarlarkThread.CallStackEntry leaf = callstack.get(n - 1);
        if (leaf.location.equals(Location.BUILTIN)) {
            prefix = "Error in " + leaf.name + ": ";
            --n;
        }
        if (n > 0) {
            buf.append("Traceback (most recent call last):\n");
            for (int i = 0; i < n; ++i) {
                StarlarkThread.CallStackEntry fr = callstack.get(i);
                buf.append(String.format("\tFile \"%s\", ", fr.location.file()));
                if (fr.location.line() != 0) {
                    buf.append("line ").append(fr.location.line()).append(", ");
                    if (fr.location.column() != 0) {
                        buf.append("column ").append(fr.location.column()).append(", ");
                    }
                }
                buf.append("in ").append(fr.name).append('\n');
                String line = src.readline(fr.location);
                if (line == null) continue;
                buf.append("\t\t").append(line.trim()).append('\n');
            }
        }
        buf.append((String)prefix).append(message);
        return buf.toString();
    }

    @CanIgnoreReturnValue
    final EvalException ensureStack(StarlarkThread thread) {
        if (this.callstack == null) {
            this.callstack = thread.getCallStack();
            if (this.callstack.isEmpty()) {
                throw new IllegalStateException("empty callstack");
            }
        }
        return this;
    }

    public static interface SourceReader {
        public String readline(Location var1);
    }
}

