/*
 * Decompiled with CFR 0.152.
 */
package net.starlark.java.eval;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.starlark.java.eval.StarlarkCallable;
import net.starlark.java.eval.StarlarkThread;
import net.starlark.java.eval.StarlarkValue;
import net.starlark.java.syntax.Location;

public final class Debug {
    static final AtomicReference<Debugger> debugger = new AtomicReference();
    static ThreadHook threadHook = null;

    private Debug() {
    }

    public static void setDebugger(Debugger dbg) {
        Debugger prev = debugger.getAndSet(dbg);
        if (prev != null) {
            prev.close();
        }
    }

    public static ImmutableList<Frame> getCallStack(StarlarkThread thread) {
        return thread.getDebugCallStack();
    }

    @Nullable
    public static ReadyToPause stepControl(StarlarkThread th, Stepping stepping) {
        int depth = th.getCallStackSize();
        switch (stepping) {
            case NONE: {
                return null;
            }
            case INTO: {
                return thread -> true;
            }
            case OVER: {
                return thread -> thread.getCallStackSize() <= depth;
            }
            case OUT: {
                return depth == 0 ? null : thread -> thread.getCallStackSize() < depth;
            }
        }
        throw new IllegalArgumentException("Unsupported stepping type: " + stepping);
    }

    public static void setThreadHook(ThreadHook hook) {
        threadHook = hook;
    }

    public static interface ThreadHook {
        public void onPushFirst(StarlarkThread var1);

        public void onPopLast(StarlarkThread var1);
    }

    public static interface Frame {
        public StarlarkCallable getFunction();

        public Location getLocation();

        public ImmutableMap<String, Object> getLocals();
    }

    public static enum Stepping {
        NONE,
        INTO,
        OVER,
        OUT;

    }

    public static interface ReadyToPause
    extends Predicate<StarlarkThread> {
    }

    public static final class DebugAttribute {
        public final String name;
        public final Object value;

        public DebugAttribute(String name, Object value) {
            this.name = name;
            this.value = value;
        }
    }

    public static interface ValueWithDebugAttributes
    extends StarlarkValue {
        public ImmutableList<DebugAttribute> getDebugAttributes();
    }

    public static interface Debugger {
        public void before(StarlarkThread var1, Location var2);

        public void close();
    }
}

