/*
 * Decompiled with CFR 0.152.
 */
package net.starlark.java.eval;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import javax.annotation.Nullable;
import net.starlark.java.annot.StarlarkBuiltin;
import net.starlark.java.annot.StarlarkMethod;
import net.starlark.java.eval.CallUtils;
import net.starlark.java.eval.Dict;
import net.starlark.java.eval.EvalException;
import net.starlark.java.eval.MethodDescriptor;
import net.starlark.java.eval.ParamDescriptor;
import net.starlark.java.eval.Printer;
import net.starlark.java.eval.Starlark;
import net.starlark.java.eval.StarlarkCallable;
import net.starlark.java.eval.StarlarkSemantics;
import net.starlark.java.eval.StarlarkThread;
import net.starlark.java.eval.StarlarkValue;
import net.starlark.java.eval.StringModule;
import net.starlark.java.eval.Tuple;
import net.starlark.java.spelling.SpellChecker;

@StarlarkBuiltin(name="builtin_function_or_method", category="core", doc="The type of a built-in function, defined by Java code.")
public final class BuiltinFunction
implements StarlarkCallable {
    private final Object obj;
    private final String methodName;
    @Nullable
    private final MethodDescriptor desc;

    BuiltinFunction(Object obj, String methodName) {
        this.obj = obj;
        this.methodName = methodName;
        this.desc = null;
    }

    BuiltinFunction(Object obj, String methodName, MethodDescriptor desc) {
        Preconditions.checkArgument(!desc.isStructField());
        this.obj = obj;
        this.methodName = methodName;
        this.desc = desc;
    }

    @Override
    public Object fastcall(StarlarkThread thread, Object[] positional, Object[] named) throws EvalException, InterruptedException {
        MethodDescriptor desc = this.getMethodDescriptor(thread.getSemantics());
        Object[] vector = this.getArgumentVector(thread, desc, positional, named);
        return desc.call(this.obj instanceof String ? StringModule.INSTANCE : this.obj, vector, thread.mutability());
    }

    private MethodDescriptor getMethodDescriptor(StarlarkSemantics semantics) {
        MethodDescriptor desc = this.desc;
        if (desc == null) {
            desc = CallUtils.getAnnotatedMethods(semantics, this.obj.getClass()).get(this.methodName);
            Preconditions.checkArgument(!desc.isStructField(), "BuiltinFunction constructed for MethodDescriptor(structField=True)");
        }
        return desc;
    }

    public StarlarkMethod getAnnotation() {
        return this.getMethodDescriptor(StarlarkSemantics.DEFAULT).getAnnotation();
    }

    @Override
    public String getName() {
        return this.methodName;
    }

    @Override
    public void repr(Printer printer) {
        if (this.obj instanceof StarlarkValue || this.obj instanceof String) {
            printer.append("<built-in method ").append(this.methodName).append(" of ").append(Starlark.type(this.obj)).append(" value>");
        } else {
            printer.append("<built-in function ").append(this.methodName).append(">");
        }
    }

    public String toString() {
        return this.methodName;
    }

    private Object[] getArgumentVector(StarlarkThread thread, MethodDescriptor desc, Object[] positional, Object[] named) throws EvalException {
        int i;
        ParamDescriptor param;
        ParamDescriptor[] parameters = desc.getParameters();
        int n = parameters.length;
        if (desc.acceptsExtraArgs()) {
            ++n;
        }
        if (desc.acceptsExtraKwargs()) {
            ++n;
        }
        if (desc.isUseStarlarkThread()) {
            ++n;
        }
        Object[] vector = new Object[n];
        int paramIndex = 0;
        int argIndex = 0;
        if (this.obj instanceof String) {
            vector[paramIndex++] = this.obj;
        }
        while (argIndex < positional.length && paramIndex < parameters.length && (param = parameters[paramIndex]).isPositional()) {
            if (param.disabledByFlag() == null) {
                Object value = positional[argIndex++];
                this.checkParamValue(param, value);
                vector[paramIndex] = value;
            }
            ++paramIndex;
        }
        Tuple varargs = null;
        if (desc.acceptsExtraArgs()) {
            varargs = Tuple.wrap(Arrays.copyOfRange(positional, argIndex, positional.length));
        } else if (argIndex < positional.length) {
            if (argIndex == 0) {
                throw Starlark.errorf("%s() got unexpected positional argument", this.methodName);
            }
            throw Starlark.errorf("%s() accepts no more than %d positional argument%s but got %d", this.methodName, argIndex, BuiltinFunction.plural(argIndex), positional.length);
        }
        LinkedHashMap<String, Object> kwargs = desc.acceptsExtraKwargs() ? new LinkedHashMap<String, Object>() : null;
        for (int i2 = 0; i2 < named.length; i2 += 2) {
            String name = (String)named[i2];
            Object value = named[i2 + 1];
            int index = desc.getParameterIndex(name);
            if (index < 0) {
                if (kwargs == null) {
                    List allNames = Arrays.stream(parameters).map(ParamDescriptor::getName).collect(ImmutableList.toImmutableList());
                    throw Starlark.errorf("%s() got unexpected keyword argument '%s'%s", this.methodName, name, SpellChecker.didYouMean(name, allNames));
                }
                if (kwargs.put(name, value) == null) continue;
                throw Starlark.errorf("%s() got multiple values for keyword argument '%s'", this.methodName, name);
            }
            ParamDescriptor param2 = parameters[index];
            if (!param2.isNamed()) {
                if (kwargs == null) {
                    throw Starlark.errorf("%s() got named argument for positional-only parameter '%s'", this.methodName, name);
                }
                if (kwargs.put(name, value) == null) continue;
                throw Starlark.errorf("%s() got multiple values for keyword argument '%s'", this.methodName, name);
            }
            String flag = param2.disabledByFlag();
            if (flag != null) {
                if (kwargs == null) {
                    throw Starlark.errorf("in call to %s(), parameter '%s' is %s", this.methodName, param2.getName(), BuiltinFunction.disabled(flag, thread.getSemantics()));
                }
                if (kwargs.put(name, value) == null) continue;
                throw Starlark.errorf("%s() got multiple values for keyword argument '%s'", this.methodName, name);
            }
            this.checkParamValue(param2, value);
            if (vector[index] != null) {
                throw Starlark.errorf("%s() got multiple values for argument '%s'", this.methodName, name);
            }
            vector[index] = value;
        }
        ArrayList<String> missingPositional = null;
        ArrayList<String> missingNamed = null;
        for (i = 0; i < parameters.length; ++i) {
            if (vector[i] != null) continue;
            ParamDescriptor param3 = parameters[i];
            vector[i] = param3.getDefaultValue();
            if (vector[i] != null) continue;
            if (param3.isPositional()) {
                if (missingPositional == null) {
                    missingPositional = new ArrayList<String>();
                }
                missingPositional.add(param3.getName());
                continue;
            }
            if (missingNamed == null) {
                missingNamed = new ArrayList<String>();
            }
            missingNamed.add(param3.getName());
        }
        if (missingPositional != null) {
            throw Starlark.errorf("%s() missing %d required positional argument%s: %s", this.methodName, missingPositional.size(), BuiltinFunction.plural(missingPositional.size()), Joiner.on(", ").join(missingPositional));
        }
        if (missingNamed != null) {
            throw Starlark.errorf("%s() missing %d required named argument%s: %s", this.methodName, missingNamed.size(), BuiltinFunction.plural(missingNamed.size()), Joiner.on(", ").join(missingNamed));
        }
        i = parameters.length;
        if (desc.acceptsExtraArgs()) {
            vector[i++] = varargs;
        }
        if (desc.acceptsExtraKwargs()) {
            vector[i++] = Dict.wrap(thread.mutability(), kwargs);
        }
        if (desc.isUseStarlarkThread()) {
            vector[i++] = thread;
        }
        return vector;
    }

    private static String plural(int n) {
        return n == 1 ? "" : "s";
    }

    private void checkParamValue(ParamDescriptor param, Object value) throws EvalException {
        List<Class<?>> allowedClasses = param.getAllowedClasses();
        if (allowedClasses == null) {
            return;
        }
        boolean ok = false;
        for (Class<?> cls : allowedClasses) {
            if (!cls.isInstance(value)) continue;
            ok = true;
            break;
        }
        if (!ok) {
            throw Starlark.errorf("in call to %s(), parameter '%s' got value of type '%s', want '%s'", this.methodName, param.getName(), Starlark.type(value), param.getTypeErrorMessage());
        }
    }

    private static String disabled(String flag, StarlarkSemantics semantics) {
        if (semantics.getBool(flag)) {
            return String.format("deprecated and will be removed soon. It may be temporarily re-enabled by setting --%s=false", flag.substring(1));
        }
        return String.format("experimental and thus unavailable with the current flags. It may be enabled by setting --%s", flag.substring(1));
    }
}

