/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.common.options;

import com.google.devtools.common.options.ArgsPreProcessor;
import com.google.devtools.common.options.OptionsParsingException;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.Path;
import java.util.List;

public abstract class ParamsFilePreProcessor
implements ArgsPreProcessor {
    static final String ERROR_MESSAGE_FORMAT = "Error reading params file: %s %s";
    static final String TOO_MANY_ARGS_ERROR_MESSAGE_FORMAT = "A params file must be the only argument: %s";
    static final String UNFINISHED_QUOTE_MESSAGE_FORMAT = "Unfinished quote %s at %s";
    private final FileSystem fs;

    ParamsFilePreProcessor(FileSystem fs) {
        this.fs = fs;
    }

    @Override
    public List<String> preProcess(List<String> args) throws OptionsParsingException {
        if (!args.isEmpty() && args.get(0).startsWith("@")) {
            if (args.size() > 1) {
                throw new OptionsParsingException(String.format(TOO_MANY_ARGS_ERROR_MESSAGE_FORMAT, args), args.get(0));
            }
            Path path = this.fs.getPath(args.get(0).substring(1), new String[0]);
            try {
                return this.parse(path);
            }
            catch (IOException | RuntimeException e) {
                throw new OptionsParsingException(String.format(ERROR_MESSAGE_FORMAT, path, e.getMessage()), args.get(0), e);
            }
        }
        return args;
    }

    protected abstract List<String> parse(Path var1) throws IOException, OptionsParsingException;
}

