/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.common.options;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterators;
import com.google.devtools.common.options.ArgsPreProcessor;
import com.google.devtools.common.options.Option;
import com.google.devtools.common.options.OptionDefinition;
import com.google.devtools.common.options.OptionDocumentationCategory;
import com.google.devtools.common.options.OptionEffectTag;
import com.google.devtools.common.options.OptionInstanceOrigin;
import com.google.devtools.common.options.OptionMetadataTag;
import com.google.devtools.common.options.OptionPriority;
import com.google.devtools.common.options.OptionValueDescription;
import com.google.devtools.common.options.OptionsBase;
import com.google.devtools.common.options.OptionsData;
import com.google.devtools.common.options.OptionsParser;
import com.google.devtools.common.options.OptionsParsingException;
import com.google.devtools.common.options.ParsedOptionDescription;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Keep;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

class OptionsParserImpl {
    private final OptionsData optionsData;
    private final Map<OptionDefinition, OptionValueDescription> optionValues = new HashMap<OptionDefinition, OptionValueDescription>();
    private final Map<OptionPriority.PriorityCategory, OptionPriority> nextPriorityPerPriorityCategory = Arrays.stream(OptionPriority.PriorityCategory.values()).collect(Collectors.toMap(p -> p, OptionPriority::lowestOptionPriorityAtCategory));
    private final List<ParsedOptionDescription> parsedOptions = new ArrayList<ParsedOptionDescription>();
    private final List<ParsedOptionDescription> skippedOptions = new ArrayList<ParsedOptionDescription>();
    private final Map<String, String> flagAliasMappings;
    private final Set<String> warnings = new LinkedHashSet<String>();
    private final ArgsPreProcessor argsPreProcessor;
    private final List<String> skippedPrefixes;
    private final boolean ignoreInternalOptions;
    @Nullable
    private final String aliasFlag;
    @Nullable
    private final Object conversionContext;
    @Keep
    @Option(name="skipped args", allowMultiple=true, defaultValue="null", documentationCategory=OptionDocumentationCategory.UNDOCUMENTED, effectTags={OptionEffectTag.NO_OP}, help="Only used internally by OptionsParserImpl")
    private final List<String> skippedArgs = new ArrayList<String>();
    private static final OptionDefinition skippedArgsDefinition;

    public static Builder builder() {
        return new Builder();
    }

    OptionsParserImpl(OptionsData optionsData, ArgsPreProcessor argsPreProcessor, List<String> skippedPrefixes, boolean ignoreInternalOptions, @Nullable String aliasFlag, @Nullable Object conversionContext, Map<String, String> aliases) {
        this.optionsData = optionsData;
        this.argsPreProcessor = argsPreProcessor;
        this.skippedPrefixes = skippedPrefixes;
        this.ignoreInternalOptions = ignoreInternalOptions;
        this.aliasFlag = aliasFlag;
        this.conversionContext = conversionContext;
        this.flagAliasMappings = aliases;
    }

    OptionsData getOptionsData() {
        return this.optionsData;
    }

    @Nullable
    public Object getConversionContext() {
        return this.conversionContext;
    }

    Builder toBuilder() {
        Builder builder = OptionsParserImpl.builder().optionsData(this.optionsData).argsPreProcessor(this.argsPreProcessor).withAliasFlag(this.aliasFlag).withAliases(this.flagAliasMappings).withConversionContext(this.conversionContext).ignoreInternalOptions(this.ignoreInternalOptions);
        for (String skippedPrefix : this.skippedPrefixes) {
            builder.skippedPrefix(skippedPrefix);
        }
        return builder;
    }

    List<ParsedOptionDescription> asCompleteListOfParsedOptions() {
        return this.parsedOptions.stream().sorted(Comparator.comparing(ParsedOptionDescription::getPriority)).collect(Collectors.toCollection(ArrayList::new));
    }

    List<ParsedOptionDescription> asListOfExplicitOptions() {
        return this.parsedOptions.stream().filter(ParsedOptionDescription::isExplicit).sorted(Comparator.comparing(ParsedOptionDescription::getPriority)).collect(Collectors.toCollection(ArrayList::new));
    }

    List<ParsedOptionDescription> getSkippedOptions() {
        return this.skippedOptions;
    }

    List<String> asCanonicalizedList() {
        return this.asCanonicalizedListOfParsedOptions().stream().map(ParsedOptionDescription::getDeprecatedCanonicalForm).collect(ImmutableList.toImmutableList());
    }

    List<ParsedOptionDescription> asCanonicalizedListOfParsedOptions() {
        return this.optionValues.keySet().stream().filter(k -> !Objects.equals(k, skippedArgsDefinition)).map(optionDefinition -> this.optionValues.get(optionDefinition).getCanonicalInstances()).flatMap(Collection::stream).sorted(Comparator.comparing(ParsedOptionDescription::getPriority)).collect(ImmutableList.toImmutableList());
    }

    List<OptionValueDescription> asListOfEffectiveOptions() {
        ArrayList<OptionValueDescription> result = new ArrayList<OptionValueDescription>();
        for (Map.Entry<String, OptionDefinition> mapEntry : this.optionsData.getAllOptionDefinitions()) {
            OptionDefinition optionDefinition = mapEntry.getValue();
            OptionValueDescription optionValue = this.optionValues.get(optionDefinition);
            if (optionValue == null) {
                result.add(OptionValueDescription.getDefaultOptionValue(optionDefinition, this.conversionContext));
                continue;
            }
            result.add(optionValue);
        }
        return result;
    }

    private void maybeAddDeprecationWarning(OptionDefinition optionDefinition, OptionPriority.PriorityCategory priority) {
        if (priority.equals((Object)OptionPriority.PriorityCategory.INVOCATION_POLICY)) {
            return;
        }
        String warning = optionDefinition.getDeprecationWarning();
        if (!warning.isEmpty() || optionDefinition.getField().isAnnotationPresent(Deprecated.class)) {
            this.addDeprecationWarning(optionDefinition.getOptionName(), warning);
        }
    }

    private void maybeAddOldNameWarning(ParsedOptionDescription parsedOption) {
        if (parsedOption.getPriority().getPriorityCategory().equals((Object)OptionPriority.PriorityCategory.INVOCATION_POLICY)) {
            return;
        }
        OptionDefinition optionDefinition = parsedOption.getOptionDefinition();
        if (!optionDefinition.getOldNameWarning()) {
            return;
        }
        String commandLineForm = parsedOption.getCommandLineForm();
        String oldOptionName = optionDefinition.getOldOptionName();
        String optionName = optionDefinition.getOptionName();
        if (commandLineForm.startsWith(String.format("--%s=", oldOptionName))) {
            this.addDeprecationWarning(oldOptionName, String.format("Use --%s instead", optionName));
        }
    }

    private void addDeprecationWarning(String optionName, String warning) {
        this.warnings.add(String.format("Option '%s' is deprecated%s", optionName, warning.isEmpty() ? "" : ": " + warning));
    }

    OptionValueDescription clearValue(OptionDefinition optionDefinition) throws OptionsParsingException {
        return this.optionValues.remove(optionDefinition);
    }

    OptionValueDescription getOptionValueDescription(String name) {
        OptionDefinition optionDefinition = this.optionsData.getOptionDefinitionFromName(name);
        if (optionDefinition == null) {
            throw new IllegalArgumentException("No such option '" + name + "'");
        }
        return this.optionValues.get(optionDefinition);
    }

    @Nullable
    OptionsParser.OptionDescription getOptionDescription(String name) throws OptionsParsingException {
        OptionDefinition optionDefinition = this.optionsData.getOptionDefinitionFromName(name);
        if (optionDefinition == null) {
            return null;
        }
        return new OptionsParser.OptionDescription(optionDefinition, this.optionsData);
    }

    ImmutableList<ParsedOptionDescription> getExpansionValueDescriptions(OptionDefinition expansionFlagDef, OptionInstanceOrigin originOfExpansionFlag) throws OptionsParsingException {
        String source;
        ImmutableList<String> options;
        ImmutableList.Builder builder = ImmutableList.builder();
        OptionPriority nextOptionPriority = OptionPriority.getChildPriority(originOfExpansionFlag.getPriority());
        ParsedOptionDescription implicitDependent = null;
        ParsedOptionDescription expandedFrom = null;
        ParsedOptionDescription expansionFlagParsedDummy = ParsedOptionDescription.newDummyInstance(expansionFlagDef, originOfExpansionFlag, this.conversionContext);
        if (expansionFlagDef.hasImplicitRequirements()) {
            options = ImmutableList.copyOf(expansionFlagDef.getImplicitRequirements());
            source = String.format("implicitly required by %s (source: %s)", expansionFlagDef, originOfExpansionFlag.getSource());
            implicitDependent = expansionFlagParsedDummy;
        } else if (expansionFlagDef.isExpansionOption()) {
            options = this.optionsData.getEvaluatedExpansion(expansionFlagDef);
            source = String.format("expanded by %s (source: %s)", expansionFlagDef, originOfExpansionFlag.getSource());
            expandedFrom = expansionFlagParsedDummy;
        } else {
            return ImmutableList.of();
        }
        Iterator optionsIterator = options.iterator();
        while (optionsIterator.hasNext()) {
            String unparsedFlagExpression = (String)optionsIterator.next();
            ParsedOptionDescription parsedOption = this.identifyOptionAndPossibleArgument(unparsedFlagExpression, optionsIterator, nextOptionPriority, o -> source, implicitDependent, expandedFrom);
            builder.add(parsedOption);
            nextOptionPriority = OptionPriority.nextOptionPriority(nextOptionPriority);
        }
        return builder.build();
    }

    boolean containsExplicitOption(String name) {
        OptionDefinition optionDefinition = this.optionsData.getOptionDefinitionFromName(name);
        if (optionDefinition == null) {
            throw new IllegalArgumentException("No such option '" + name + "'");
        }
        return this.optionValues.get(optionDefinition) != null;
    }

    List<String> getSkippedArgs() {
        OptionValueDescription value = this.optionValues.get(skippedArgsDefinition);
        if (value == null) {
            return ImmutableList.of();
        }
        return (List)value.getValue();
    }

    OptionsParserImplResult parse(OptionPriority.PriorityCategory priorityCat, Function<OptionDefinition, String> sourceFunction, List<String> args) throws OptionsParsingException {
        OptionsParserImplResult optionsParserImplResult = this.parse(this.nextPriorityPerPriorityCategory.get((Object)priorityCat), sourceFunction, null, null, args);
        this.nextPriorityPerPriorityCategory.put(priorityCat, optionsParserImplResult.nextPriority);
        return optionsParserImplResult;
    }

    private OptionsParserImplResult parse(OptionPriority priority, Function<OptionDefinition, String> sourceFunction, ParsedOptionDescription implicitDependent, ParsedOptionDescription expandedFrom, List<String> args) throws OptionsParsingException {
        ArrayList<String> unparsedArgs = new ArrayList<String>();
        ArrayList<String> unparsedPostDoubleDashArgs = new ArrayList<String>();
        Iterator<String> argsIterator = this.argsPreProcessor.preProcess(args).iterator();
        while (argsIterator.hasNext()) {
            String arg = argsIterator.next();
            if (!arg.startsWith("-")) {
                unparsedArgs.add(arg);
                continue;
            }
            if (arg.startsWith("-//") || arg.startsWith("-@")) {
                throw new OptionsParsingException(String.format("Invalid options syntax: %s\nNote: Negative target patterns can only appear after the end of options marker ('--'). Flags corresponding to Starlark-defined build settings always start with '--', not '-'.", arg));
            }
            if ((arg = this.swapShorthandAlias(arg)).equals("--")) {
                Iterators.addAll(unparsedPostDoubleDashArgs, argsIterator);
                break;
            }
            ParsedOptionDescription parsedOption = this.containsSkippedPrefix(arg) ? ParsedOptionDescription.newParsedOptionDescription(skippedArgsDefinition, arg, arg, new OptionInstanceOrigin(priority, sourceFunction.apply(skippedArgsDefinition), implicitDependent, expandedFrom), this.conversionContext) : this.identifyOptionAndPossibleArgument(arg, argsIterator, priority, sourceFunction, implicitDependent, expandedFrom);
            this.handleNewParsedOption(parsedOption);
            priority = OptionPriority.nextOptionPriority(priority);
        }
        for (OptionValueDescription valueDescription : this.asListOfEffectiveOptions()) {
            valueDescription.getValue();
        }
        return new OptionsParserImplResult(unparsedArgs, unparsedPostDoubleDashArgs, priority, this.flagAliasMappings);
    }

    OptionsParserImplResult parseArgsAsExpansionOfOption(ParsedOptionDescription optionToExpand, Function<OptionDefinition, String> sourceFunction, List<String> args) throws OptionsParsingException {
        return this.parse(OptionPriority.getChildPriority(optionToExpand.getPriority()), sourceFunction, null, optionToExpand, args);
    }

    void setOptionValueAtSpecificPriorityWithoutExpansion(OptionInstanceOrigin origin, OptionDefinition option, String unconvertedValue) throws OptionsParsingException {
        Preconditions.checkNotNull(option);
        Preconditions.checkNotNull(unconvertedValue, "Cannot set %s to a null value. Pass \"\" if an empty value is required.", (Object)option);
        Preconditions.checkNotNull(origin, "Cannot assign value '%s' to %s without a clear origin for this value.", (Object)unconvertedValue, (Object)option);
        OptionPriority.PriorityCategory priorityCategory = origin.getPriority().getPriorityCategory();
        boolean isNotDefault = priorityCategory != OptionPriority.PriorityCategory.DEFAULT;
        Preconditions.checkArgument(isNotDefault, "Attempt to assign value '%s' to %s at priority %s failed. Cannot set options at default priority - by definition, that means the option is unset.", (Object)unconvertedValue, (Object)option, (Object)priorityCategory);
        this.setOptionValue(ParsedOptionDescription.newParsedOptionDescription(option, String.format("--%s=%s", option.getOptionName(), unconvertedValue), unconvertedValue, origin, this.conversionContext));
    }

    private void handleNewParsedOption(ParsedOptionDescription parsedOption) throws OptionsParsingException {
        OptionsParserImplResult optionsParserImplResult;
        OptionDefinition optionDefinition = parsedOption.getOptionDefinition();
        OptionValueDescription.ExpansionBundle expansionBundle = this.setOptionValue(parsedOption);
        String unconvertedValue = parsedOption.getUnconvertedValue();
        if (expansionBundle != null && !(optionsParserImplResult = this.parse(OptionPriority.getChildPriority(parsedOption.getPriority()), o -> expansionBundle.sourceOfExpansionArgs, optionDefinition.hasImplicitRequirements() ? parsedOption : null, optionDefinition.isExpansionOption() ? parsedOption : null, expansionBundle.expansionArgs)).getResidue().isEmpty()) {
            throw new AssertionError((Object)("Unparsed options remain after processing " + unconvertedValue + ": " + Joiner.on(' ').join(optionsParserImplResult.getResidue())));
        }
    }

    private OptionValueDescription.ExpansionBundle setOptionValue(ParsedOptionDescription parsedOption) throws OptionsParsingException {
        OptionDefinition optionDefinition = parsedOption.getOptionDefinition();
        this.maybeAddDeprecationWarning(optionDefinition, parsedOption.getPriority().getPriorityCategory());
        this.maybeAddOldNameWarning(parsedOption);
        OptionValueDescription entry = this.optionValues.computeIfAbsent(optionDefinition, def -> OptionValueDescription.createOptionValueDescription(def, this.optionsData, this.conversionContext));
        OptionValueDescription.ExpansionBundle expansionBundle = entry.addOptionInstance(parsedOption, this.warnings);
        if (parsedOption.getImplicitDependent() == null) {
            if (Objects.equals(parsedOption.getOptionDefinition(), skippedArgsDefinition)) {
                this.skippedOptions.add(parsedOption);
            } else {
                this.parsedOptions.add(parsedOption);
            }
            if (this.aliasFlag != null && parsedOption.getCommandLineForm().startsWith(this.aliasFlag)) {
                List<String> alias = Splitter.on('=').limit(2).splitToList(parsedOption.getUnconvertedValue());
                this.flagAliasMappings.put(alias.get(0), alias.get(1));
            }
        }
        return expansionBundle;
    }

    private ParsedOptionDescription identifyOptionAndPossibleArgument(String arg, Iterator<String> nextArgs, OptionPriority priority, Function<OptionDefinition, String> sourceFunction, ParsedOptionDescription implicitDependent, ParsedOptionDescription expandedFrom) throws OptionsParsingException {
        OptionDefinition optionDefinition;
        StringBuilder commandLineForm = new StringBuilder();
        commandLineForm.append(arg);
        String unconvertedValue = null;
        boolean booleanValue = true;
        if (arg.length() == 2) {
            optionDefinition = this.optionsData.getFieldForAbbrev(arg.charAt(1));
            booleanValue = true;
        } else if (arg.length() == 3 && arg.charAt(2) == '-') {
            optionDefinition = this.optionsData.getFieldForAbbrev(arg.charAt(1));
            booleanValue = false;
        } else if (arg.startsWith("--")) {
            String name;
            int equalsAt = arg.indexOf(61);
            int nameStartsAt = 2;
            String string = name = equalsAt == -1 ? arg.substring(nameStartsAt) : arg.substring(nameStartsAt, equalsAt);
            if (name.trim().isEmpty()) {
                throw new OptionsParsingException("Invalid options syntax: " + arg, arg);
            }
            unconvertedValue = equalsAt == -1 ? null : arg.substring(equalsAt + 1);
            optionDefinition = this.optionsData.getOptionDefinitionFromName(name);
            if (optionDefinition == null && name.startsWith("no")) {
                name = name.substring(2);
                optionDefinition = this.optionsData.getOptionDefinitionFromName(name);
                booleanValue = false;
                if (optionDefinition != null) {
                    if (!optionDefinition.usesBooleanValueSyntax()) {
                        throw new OptionsParsingException("Illegal use of 'no' prefix on non-boolean option: " + arg, arg);
                    }
                    if (unconvertedValue != null) {
                        throw new OptionsParsingException("Unexpected value after boolean option: " + arg, arg);
                    }
                    unconvertedValue = "0";
                }
            }
        } else {
            throw new OptionsParsingException("Invalid options syntax: " + arg, arg);
        }
        if (optionDefinition == null || this.shouldIgnoreOption(optionDefinition)) {
            throw new OptionsParsingException("Unrecognized option: " + arg, arg);
        }
        if (unconvertedValue == null) {
            if (optionDefinition.usesBooleanValueSyntax()) {
                unconvertedValue = booleanValue ? "1" : "0";
            } else if (!optionDefinition.getType().equals(Void.class)) {
                if (nextArgs.hasNext()) {
                    unconvertedValue = nextArgs.next();
                    commandLineForm.append(" ").append(unconvertedValue);
                } else {
                    throw new OptionsParsingException("Expected value after " + arg);
                }
            }
        }
        return ParsedOptionDescription.newParsedOptionDescription(optionDefinition, commandLineForm.toString(), unconvertedValue, new OptionInstanceOrigin(priority, sourceFunction.apply(optionDefinition), implicitDependent, expandedFrom), this.conversionContext);
    }

    private boolean shouldIgnoreOption(OptionDefinition optionDefinition) {
        return this.ignoreInternalOptions && ImmutableList.copyOf(optionDefinition.getOptionMetadataTags()).contains((Object)OptionMetadataTag.INTERNAL);
    }

    <O extends OptionsBase> O getParsedOptions(Class<O> optionsClass) {
        OptionsBase optionsInstance;
        try {
            Constructor<O> constructor = this.optionsData.getConstructor(optionsClass);
            if (constructor == null) {
                return null;
            }
            optionsInstance = (OptionsBase)constructor.newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalStateException("Error while instantiating options class", e);
        }
        for (OptionDefinition optionDefinition : OptionsData.getAllOptionDefinitionsForClass(optionsClass)) {
            OptionValueDescription optionValue = this.optionValues.get(optionDefinition);
            Object value = optionValue == null || optionValue.containsErrors() ? optionDefinition.getDefaultValue(this.conversionContext) : optionValue.getValue();
            try {
                optionDefinition.getField().set(optionsInstance, value);
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException("Could not set the field due to access issues. This is impossible, as the OptionProcessor checks that all options are non-final public fields.", e);
            }
        }
        return (O)optionsInstance;
    }

    ImmutableList<String> getWarnings() {
        return ImmutableList.copyOf(this.warnings);
    }

    private String swapShorthandAlias(String arg) {
        Object actualArg;
        if (this.aliasFlag == null || !arg.startsWith("--")) {
            return arg;
        }
        int equalSign = arg.indexOf("=");
        Object object = actualArg = equalSign != -1 ? arg.substring(2, equalSign) : arg.substring(2);
        if (!this.flagAliasMappings.containsKey(actualArg)) {
            return arg;
        }
        String alias = this.flagAliasMappings.get(actualArg);
        actualArg = alias;
        actualArg = equalSign != -1 ? "--" + (String)actualArg + arg.substring(equalSign) : "--" + (String)actualArg;
        return actualArg;
    }

    private boolean containsSkippedPrefix(String arg) {
        return this.skippedPrefixes.stream().anyMatch(arg::startsWith);
    }

    static {
        try {
            skippedArgsDefinition = OptionDefinition.extractOptionDefinition(OptionsParserImpl.class.getDeclaredField("skippedArgs"));
        }
        catch (NoSuchFieldException e) {
            throw new IllegalStateException(e);
        }
    }

    static final class OptionsParserImplResult {
        final List<String> postDoubleDashResidue;
        final List<String> preDoubleDashResidue;
        final OptionPriority nextPriority;
        final ImmutableMap<String, String> aliases;

        OptionsParserImplResult(List<String> preDashResidue, List<String> postDashResidue, OptionPriority nextPriority, Map<String, String> aliases) {
            this.preDoubleDashResidue = preDashResidue;
            this.postDoubleDashResidue = postDashResidue;
            this.nextPriority = nextPriority;
            this.aliases = ImmutableMap.copyOf(aliases);
        }

        public List<String> getResidue() {
            ArrayList<String> toReturn = new ArrayList<String>(this.preDoubleDashResidue.size() + this.postDoubleDashResidue.size());
            toReturn.addAll(this.preDoubleDashResidue);
            toReturn.addAll(this.postDoubleDashResidue);
            return toReturn;
        }
    }

    static final class Builder {
        private OptionsData optionsData;
        private ArgsPreProcessor argsPreProcessor = args -> args;
        private final ArrayList<String> skippedPrefixes = new ArrayList();
        private boolean ignoreInternalOptions = true;
        @Nullable
        private String aliasFlag = null;
        @Nullable
        private Object conversionContext = null;
        private final Map<String, String> aliases = new HashMap<String, String>();

        Builder() {
        }

        @CanIgnoreReturnValue
        public Builder optionsData(OptionsData optionsData) {
            this.optionsData = optionsData;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder argsPreProcessor(ArgsPreProcessor preProcessor) {
            this.argsPreProcessor = preProcessor;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder skippedPrefix(String skippedPrefix) {
            this.skippedPrefixes.add(skippedPrefix);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder ignoreInternalOptions(boolean ignoreInternalOptions) {
            this.ignoreInternalOptions = ignoreInternalOptions;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder withAliasFlag(@Nullable String aliasFlag) {
            if (aliasFlag != null) {
                this.aliasFlag = "--" + aliasFlag;
            }
            return this;
        }

        public Builder withConversionContext(@Nullable Object conversionContext) {
            this.conversionContext = conversionContext;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder withAliases(Map<String, String> aliases) {
            this.aliases.putAll(aliases);
            return this;
        }

        public OptionsParserImpl build() {
            return new OptionsParserImpl(this.optionsData, this.argsPreProcessor, this.skippedPrefixes, this.ignoreInternalOptions, this.aliasFlag, this.conversionContext, this.aliases);
        }
    }
}

