/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.common.options;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Throwables;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.MoreCollectors;
import com.google.common.escape.Escaper;
import com.google.devtools.common.options.ArgsPreProcessor;
import com.google.devtools.common.options.OpaqueOptionsData;
import com.google.devtools.common.options.OptionDefinition;
import com.google.devtools.common.options.OptionDocumentationCategory;
import com.google.devtools.common.options.OptionFilterDescriptions;
import com.google.devtools.common.options.OptionInstanceOrigin;
import com.google.devtools.common.options.OptionPriority;
import com.google.devtools.common.options.OptionValueDescription;
import com.google.devtools.common.options.OptionsBase;
import com.google.devtools.common.options.OptionsData;
import com.google.devtools.common.options.OptionsParserImpl;
import com.google.devtools.common.options.OptionsParsingException;
import com.google.devtools.common.options.OptionsParsingResult;
import com.google.devtools.common.options.OptionsUsage;
import com.google.devtools.common.options.ParsedOptionDescription;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;

public class OptionsParser
implements OptionsParsingResult {
    private static final Map<ImmutableList<Class<? extends OptionsBase>>, OptionsData> optionsData = new HashMap<ImmutableList<Class<? extends OptionsBase>>, OptionsData>();
    public static final ImmutableList<String> STARLARK_SKIPPED_PREFIXES = ImmutableList.of("--//", "--no//", "--@", "--no@");
    private final OptionsParserImpl impl;
    private final List<String> residue = new ArrayList<String>();
    private final List<String> postDoubleDashResidue = new ArrayList<String>();
    private final boolean allowResidue;
    private ImmutableSortedMap<String, Object> starlarkOptions = ImmutableSortedMap.of();
    private final Map<String, String> aliases = new HashMap<String, String>();

    public static OpaqueOptionsData getOptionsData(List<Class<? extends OptionsBase>> optionsClasses) {
        return OptionsParser.getOptionsDataInternal(optionsClasses);
    }

    static synchronized OptionsData getOptionsDataInternal(List<Class<? extends OptionsBase>> optionsClasses) {
        ImmutableList<Class<? extends OptionsBase>> immutableOptionsClasses = ImmutableList.copyOf(optionsClasses);
        OptionsData result = optionsData.get(immutableOptionsClasses);
        if (result == null) {
            try {
                result = OptionsData.from(immutableOptionsClasses);
            }
            catch (Exception e) {
                Throwables.throwIfInstanceOf(e, ConstructionException.class);
                throw new ConstructionException(e.getMessage(), e);
            }
            optionsData.put(immutableOptionsClasses, result);
        }
        return result;
    }

    static OptionsData getOptionsDataInternal(Class<? extends OptionsBase> optionsClass) {
        return OptionsParser.getOptionsDataInternal(ImmutableList.of(optionsClass));
    }

    public static Builder builder() {
        return new Builder(OptionsParserImpl.builder());
    }

    public Builder toBuilder() {
        return new Builder(this.impl.toBuilder()).allowResidue(this.allowResidue);
    }

    private OptionsParser(OptionsParserImpl impl, boolean allowResidue) {
        this.impl = impl;
        this.allowResidue = allowResidue;
    }

    public Object getConversionContext() {
        return this.impl.getConversionContext();
    }

    public ImmutableSortedMap<String, Object> getStarlarkOptions() {
        return this.starlarkOptions;
    }

    public ImmutableSortedMap<String, Object> getExplicitStarlarkOptions(Predicate<? super ParsedOptionDescription> filter) {
        ImmutableSet explicitOptions = this.impl.getSkippedOptions().stream().filter(ParsedOptionDescription::isExplicit).filter(filter).map(d -> Iterables.get(Splitter.on('=').split(d.getCommandLineForm().substring(2)), 0)).collect(ImmutableSet.toImmutableSet());
        ImmutableSortedMap.Builder result = ImmutableSortedMap.naturalOrder();
        for (Map.Entry entry : ((ImmutableSortedMap)this.getStarlarkOptions()).entrySet()) {
            if (!explicitOptions.contains(entry.getKey())) continue;
            result.put(entry);
        }
        return result.buildOrThrow();
    }

    public void setStarlarkOptions(Map<String, Object> starlarkOptions) {
        this.starlarkOptions = ImmutableSortedMap.copyOf(starlarkOptions);
    }

    public void parseAndExitUponError(String[] args) {
        this.parseAndExitUponError(OptionPriority.PriorityCategory.COMMAND_LINE, "unknown", args);
    }

    public void parseAndExitUponError(OptionPriority.PriorityCategory priority, String source, String[] args) {
        for (String arg : args) {
            if (!arg.equals("--help")) continue;
            System.out.println(this.describeOptionsWithDeprecatedCategories(ImmutableMap.of(), HelpVerbosity.LONG));
            System.exit(0);
        }
        try {
            this.parse(priority, source, Arrays.asList(args));
        }
        catch (OptionsParsingException e) {
            System.err.println("Error parsing command line: " + e.getMessage());
            System.err.println("Try --help.");
            System.exit(2);
        }
    }

    public String describeOptions(String productName, HelpVerbosity helpVerbosity) {
        StringBuilder desc = new StringBuilder();
        LinkedHashMap<OptionDocumentationCategory, List<OptionDefinition>> optionsByCategory = this.getOptionsSortedByCategory();
        ImmutableMap<OptionDocumentationCategory, String> optionCategoryDescriptions = OptionFilterDescriptions.getOptionCategoriesEnumDescription(productName);
        for (Map.Entry<OptionDocumentationCategory, List<OptionDefinition>> e : optionsByCategory.entrySet()) {
            String categoryDescription = optionCategoryDescriptions.get((Object)e.getKey());
            List<OptionDefinition> categorizedOptionList = e.getValue();
            if (!categorizedOptionList.isEmpty()) {
                desc.append("\n").append(categoryDescription).append(":\n");
            }
            for (OptionDefinition optionDef : categorizedOptionList) {
                OptionsUsage.getUsage(optionDef, desc, helpVerbosity, this.impl.getOptionsData(), true);
            }
        }
        return desc.toString().trim();
    }

    private LinkedHashMap<OptionDocumentationCategory, List<OptionDefinition>> getOptionsSortedByCategory() {
        OptionsData data = this.impl.getOptionsData();
        if (data.getOptionsClasses().isEmpty()) {
            return new LinkedHashMap<OptionDocumentationCategory, List<OptionDefinition>>();
        }
        ArrayListMultimap<OptionDocumentationCategory, OptionDefinition> optionsByCategories = ArrayListMultimap.create();
        for (Class<? extends OptionsBase> optionsClass : data.getOptionsClasses()) {
            for (OptionDefinition optionDefinition : OptionsData.getAllOptionDefinitionsForClass(optionsClass)) {
                if (optionDefinition.getDocumentationCategory() == OptionDocumentationCategory.UNDOCUMENTED) continue;
                optionsByCategories.put(optionDefinition.getDocumentationCategory(), optionDefinition);
            }
        }
        LinkedHashMap<OptionDocumentationCategory, List<OptionDefinition>> sortedCategoriesToOptions = new LinkedHashMap<OptionDocumentationCategory, List<OptionDefinition>>(OptionFilterDescriptions.documentationOrder.length, 1.0f);
        for (OptionDocumentationCategory category : OptionFilterDescriptions.documentationOrder) {
            Collection optionList = optionsByCategories.get((Object)category);
            if (optionList == null) continue;
            optionList.sort(OptionDefinition.BY_OPTION_NAME);
            sortedCategoriesToOptions.put(category, (List<OptionDefinition>)optionList);
        }
        return sortedCategoriesToOptions;
    }

    @Deprecated
    public String describeOptionsWithDeprecatedCategories(Map<String, String> categoryDescriptions, HelpVerbosity helpVerbosity) {
        OptionsData data = this.impl.getOptionsData();
        StringBuilder desc = new StringBuilder();
        if (!data.getOptionsClasses().isEmpty()) {
            ArrayList<OptionDefinition> allFields = new ArrayList<OptionDefinition>();
            for (Class<? extends OptionsBase> optionsClass : data.getOptionsClasses()) {
                allFields.addAll(OptionsData.getAllOptionDefinitionsForClass(optionsClass));
            }
            Collections.sort(allFields, OptionDefinition.BY_CATEGORY);
            String prevCategory = null;
            for (OptionDefinition optionDefinition : allFields) {
                String category = optionDefinition.getOptionCategory();
                if (!category.equals(prevCategory) && optionDefinition.getDocumentationCategory() != OptionDocumentationCategory.UNDOCUMENTED) {
                    Object description = categoryDescriptions.get(category);
                    if (description == null) {
                        description = "Options category '" + category + "'";
                    }
                    desc.append("\n").append((String)description).append(":\n");
                    prevCategory = category;
                }
                if (optionDefinition.getDocumentationCategory() == OptionDocumentationCategory.UNDOCUMENTED) continue;
                OptionsUsage.getUsage(optionDefinition, desc, helpVerbosity, this.impl.getOptionsData(), false);
            }
        }
        return desc.toString().trim();
    }

    @Deprecated
    public String describeOptionsHtmlWithDeprecatedCategories(Map<String, String> categoryDescriptions, Escaper escaper) {
        OptionsData data = this.impl.getOptionsData();
        StringBuilder desc = new StringBuilder();
        if (!data.getOptionsClasses().isEmpty()) {
            ArrayList<OptionDefinition> allFields = new ArrayList<OptionDefinition>();
            for (Class<? extends OptionsBase> optionsClass : data.getOptionsClasses()) {
                allFields.addAll(OptionsData.getAllOptionDefinitionsForClass(optionsClass));
            }
            Collections.sort(allFields, OptionDefinition.BY_CATEGORY);
            String prevCategory = null;
            for (OptionDefinition optionDefinition : allFields) {
                String category = optionDefinition.getOptionCategory();
                if (!category.equals(prevCategory) && optionDefinition.getDocumentationCategory() != OptionDocumentationCategory.UNDOCUMENTED) {
                    Object description = categoryDescriptions.get(category);
                    if (description == null) {
                        description = "Options category '" + category + "'";
                    }
                    if (prevCategory != null) {
                        desc.append("</dl>\n\n");
                    }
                    desc.append(escaper.escape((String)description)).append(":\n");
                    desc.append("<dl>");
                    prevCategory = category;
                }
                if (optionDefinition.getDocumentationCategory() == OptionDocumentationCategory.UNDOCUMENTED) continue;
                OptionsUsage.getUsageHtml(optionDefinition, desc, escaper, this.impl.getOptionsData(), false);
            }
            desc.append("</dl>\n");
        }
        return desc.toString();
    }

    public String describeOptionsHtml(Escaper escaper, String productName) {
        StringBuilder desc = new StringBuilder();
        LinkedHashMap<OptionDocumentationCategory, List<OptionDefinition>> optionsByCategory = this.getOptionsSortedByCategory();
        ImmutableMap<OptionDocumentationCategory, String> optionCategoryDescriptions = OptionFilterDescriptions.getOptionCategoriesEnumDescription(productName);
        for (Map.Entry<OptionDocumentationCategory, List<OptionDefinition>> e : optionsByCategory.entrySet()) {
            desc.append("<dl>");
            String categoryDescription = optionCategoryDescriptions.get((Object)e.getKey());
            List<OptionDefinition> categorizedOptionsList = e.getValue();
            if (!categorizedOptionsList.isEmpty()) {
                desc.append(escaper.escape(categoryDescription)).append(":\n");
            }
            for (OptionDefinition optionDef : categorizedOptionsList) {
                OptionsUsage.getUsageHtml(optionDef, desc, escaper, this.impl.getOptionsData(), true);
            }
            desc.append("</dl>\n");
        }
        return desc.toString();
    }

    public String getOptionsCompletion() {
        StringBuilder desc = new StringBuilder();
        this.visitOptions(optionDefinition -> optionDefinition.getDocumentationCategory() != OptionDocumentationCategory.UNDOCUMENTED, optionDefinition -> OptionsUsage.getCompletion(optionDefinition, desc));
        return desc.toString();
    }

    public void visitOptions(Predicate<OptionDefinition> predicate, Consumer<OptionDefinition> visitor) {
        Preconditions.checkNotNull(predicate, "Missing predicate.");
        Preconditions.checkNotNull(visitor, "Missing visitor.");
        OptionsData data = this.impl.getOptionsData();
        data.getOptionsClasses().stream().flatMap(optionsClass -> OptionsData.getAllOptionDefinitionsForClass(optionsClass).stream()).sorted(OptionDefinition.BY_OPTION_NAME).filter(predicate).forEach(visitor);
    }

    OptionDescription getOptionDescription(String name) throws OptionsParsingException {
        return this.impl.getOptionDescription(name);
    }

    ImmutableList<ParsedOptionDescription> getExpansionValueDescriptions(OptionDefinition expansionOption, OptionInstanceOrigin originOfExpansionOption) throws OptionsParsingException {
        return this.impl.getExpansionValueDescriptions(expansionOption, originOfExpansionOption);
    }

    @Override
    public OptionValueDescription getOptionValueDescription(String name) {
        return this.impl.getOptionValueDescription(name);
    }

    public void parse(String ... args) throws OptionsParsingException {
        this.parse(OptionPriority.PriorityCategory.COMMAND_LINE, null, Arrays.asList(args));
    }

    public void parse(List<String> args) throws OptionsParsingException {
        this.parse(OptionPriority.PriorityCategory.COMMAND_LINE, null, args);
    }

    public void parse(OptionPriority.PriorityCategory priority, String source, List<String> args) throws OptionsParsingException {
        this.parseWithSourceFunction(priority, o -> source, args);
    }

    public void parseWithSourceFunction(OptionPriority.PriorityCategory priority, Function<OptionDefinition, String> sourceFunction, List<String> args) throws OptionsParsingException {
        Preconditions.checkNotNull(priority);
        Preconditions.checkArgument(priority != OptionPriority.PriorityCategory.DEFAULT);
        OptionsParserImpl.OptionsParserImplResult optionsParserImplResult = this.impl.parse(priority, sourceFunction, args);
        this.addResidueFromResult(optionsParserImplResult);
        this.aliases.putAll(optionsParserImplResult.aliases);
    }

    public void parseArgsAsExpansionOfOption(ParsedOptionDescription optionToExpand, String source, List<String> args) throws OptionsParsingException {
        Preconditions.checkNotNull(optionToExpand, "Option for expansion not specified for arglist %s", args);
        Preconditions.checkArgument(optionToExpand.getPriority().getPriorityCategory() != OptionPriority.PriorityCategory.DEFAULT, "Priority cannot be default, which was specified for arglist %s", args);
        OptionsParserImpl.OptionsParserImplResult optionsParserImplResult = this.impl.parseArgsAsExpansionOfOption(optionToExpand, (OptionDefinition o) -> source, args);
        this.addResidueFromResult(optionsParserImplResult);
    }

    private void addResidueFromResult(OptionsParserImpl.OptionsParserImplResult result) throws OptionsParsingException {
        this.residue.addAll(result.getResidue());
        this.postDoubleDashResidue.addAll(result.postDoubleDashResidue);
        if (!(this.allowResidue || ((AbstractCollection)((Object)this.getSkippedArgs())).isEmpty() && this.residue.isEmpty())) {
            String errorMsg = "Unrecognized arguments: " + Joiner.on(' ').join(Iterables.concat(this.getSkippedArgs(), this.residue));
            throw new OptionsParsingException(errorMsg);
        }
    }

    void setOptionValueAtSpecificPriorityWithoutExpansion(OptionInstanceOrigin origin, OptionDefinition option, String value) throws OptionsParsingException {
        this.impl.setOptionValueAtSpecificPriorityWithoutExpansion(origin, option, value);
    }

    public OptionValueDescription clearValue(OptionDefinition option) throws OptionsParsingException {
        return this.impl.clearValue(option);
    }

    @Override
    public Map<String, String> getAliases() {
        return ImmutableMap.copyOf(this.aliases);
    }

    public ImmutableList<String> getSkippedArgs() {
        return ImmutableList.copyOf(this.impl.getSkippedArgs());
    }

    public ImmutableList<String> getResidue() {
        return ImmutableList.copyOf(this.residue);
    }

    @Override
    public List<String> getPreDoubleDashResidue() {
        return this.postDoubleDashResidue.isEmpty() ? ImmutableList.copyOf(this.residue) : (List)this.residue.stream().filter(residue -> !this.postDoubleDashResidue.contains(residue)).collect(ImmutableList.toImmutableList());
    }

    public List<String> getPostDoubleDashResidue() {
        return ImmutableList.copyOf(this.postDoubleDashResidue);
    }

    public void setResidue(List<String> residue, List<String> postDoubleDashResidue) {
        Preconditions.checkArgument(residue.containsAll(postDoubleDashResidue));
        this.residue.clear();
        this.residue.addAll(residue);
        this.postDoubleDashResidue.clear();
        this.postDoubleDashResidue.addAll(postDoubleDashResidue);
    }

    public ImmutableList<String> getWarnings() {
        return this.impl.getWarnings();
    }

    @Override
    public <O extends OptionsBase> O getOptions(Class<O> optionsClass) {
        return this.impl.getParsedOptions(optionsClass);
    }

    @Override
    public boolean containsExplicitOption(String name) {
        return this.impl.containsExplicitOption(name);
    }

    @Override
    public List<ParsedOptionDescription> asCompleteListOfParsedOptions() {
        return this.impl.asCompleteListOfParsedOptions();
    }

    @Override
    public List<ParsedOptionDescription> asListOfExplicitOptions() {
        return this.impl.asListOfExplicitOptions();
    }

    @Override
    public List<ParsedOptionDescription> asListOfCanonicalOptions() {
        return this.impl.asCanonicalizedListOfParsedOptions();
    }

    @Override
    public List<OptionValueDescription> asListOfOptionValues() {
        return this.impl.asListOfEffectiveOptions();
    }

    @Override
    public List<String> canonicalize() {
        return this.impl.asCanonicalizedList();
    }

    public static ImmutableList<OptionDefinition> getOptionDefinitions(Class<? extends OptionsBase> optionsClass) {
        return OptionsData.getAllOptionDefinitionsForClass(optionsClass);
    }

    public static OptionDefinition getOptionDefinitionByName(Class<? extends OptionsBase> optionsClass, String optionName) {
        return (OptionDefinition)OptionsParser.getOptionDefinitions(optionsClass).stream().filter(definition -> definition.getOptionName().equals(optionName)).collect(MoreCollectors.onlyElement());
    }

    public static boolean getUsesOnlyCoreTypes(Class<? extends OptionsBase> optionsClass) {
        OptionsData data = OptionsParser.getOptionsDataInternal(optionsClass);
        return data.getUsesOnlyCoreTypes(optionsClass);
    }

    public static enum HelpVerbosity {
        LONG,
        MEDIUM,
        SHORT;

    }

    public static final class OptionDescription {
        private final OptionDefinition optionDefinition;
        private final ImmutableList<String> evaluatedExpansion;

        OptionDescription(OptionDefinition definition, OptionsData optionsData) {
            this.optionDefinition = definition;
            this.evaluatedExpansion = optionsData.getEvaluatedExpansion(this.optionDefinition);
        }

        public OptionDefinition getOptionDefinition() {
            return this.optionDefinition;
        }

        public boolean isExpansion() {
            return this.optionDefinition.isExpansionOption();
        }

        public ImmutableList<String> getExpansion() throws OptionsParsingException {
            return this.evaluatedExpansion;
        }

        public boolean equals(Object obj) {
            if (obj instanceof OptionDescription) {
                OptionDescription other = (OptionDescription)obj;
                return other.optionDefinition.equals(this.optionDefinition) && other.evaluatedExpansion.equals(this.evaluatedExpansion);
            }
            return false;
        }

        public int hashCode() {
            return this.optionDefinition.hashCode() + this.evaluatedExpansion.hashCode();
        }
    }

    public static final class Builder {
        private final OptionsParserImpl.Builder implBuilder;
        private boolean allowResidue = true;

        private Builder(OptionsParserImpl.Builder implBuilder) {
            this.implBuilder = implBuilder;
        }

        @CanIgnoreReturnValue
        public Builder optionsData(OptionsData optionsData) {
            this.implBuilder.optionsData(optionsData);
            return this;
        }

        public Builder optionsData(OpaqueOptionsData optionsData) {
            return this.optionsData((OptionsData)optionsData);
        }

        @SafeVarargs
        public final Builder optionsClasses(Class<? extends OptionsBase> ... optionsClasses) {
            return this.optionsData((OpaqueOptionsData)OptionsParser.getOptionsDataInternal(ImmutableList.copyOf(optionsClasses)));
        }

        public Builder optionsClasses(Iterable<? extends Class<? extends OptionsBase>> optionsClasses) {
            return this.optionsData((OpaqueOptionsData)OptionsParser.getOptionsDataInternal(ImmutableList.copyOf(optionsClasses)));
        }

        @CanIgnoreReturnValue
        public Builder argsPreProcessor(ArgsPreProcessor preProcessor) {
            this.implBuilder.argsPreProcessor(preProcessor);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder skipStarlarkOptionPrefixes() {
            for (String prefix : STARLARK_SKIPPED_PREFIXES) {
                this.implBuilder.skippedPrefix(prefix);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public Builder allowResidue(boolean allowResidue) {
            this.allowResidue = allowResidue;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder ignoreInternalOptions(boolean ignoreInternalOptions) {
            this.implBuilder.ignoreInternalOptions(ignoreInternalOptions);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder withAliasFlag(@Nullable String aliasFlag) {
            this.implBuilder.withAliasFlag(aliasFlag);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder withAliases(Map<String, String> aliases) {
            this.implBuilder.withAliases(aliases);
            return this;
        }

        public Builder withConversionContext(Object conversionContext) {
            this.implBuilder.withConversionContext(conversionContext);
            return this;
        }

        public OptionsParser build() {
            return new OptionsParser(this.implBuilder.build(), this.allowResidue);
        }
    }

    public static class ConstructionException
    extends RuntimeException {
        public ConstructionException(String message) {
            super(message);
        }

        public ConstructionException(Throwable cause) {
            super(cause);
        }

        public ConstructionException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

