/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.common.options;

import com.google.devtools.common.options.OptionPriority;
import com.google.devtools.common.options.OptionsBase;
import com.google.devtools.common.options.OptionsParser;
import com.google.devtools.common.options.OptionsParsingException;
import com.google.devtools.common.options.OptionsUsage;
import java.util.Arrays;
import java.util.List;

public class Options<O extends OptionsBase> {
    private final O options;
    private final String[] remainingArgs;

    public static <O extends OptionsBase> Options<O> parse(Class<O> optionsClass, String ... args) throws OptionsParsingException {
        OptionsParser parser = OptionsParser.builder().optionsClasses(optionsClass).build();
        parser.parse(OptionPriority.PriorityCategory.COMMAND_LINE, null, Arrays.asList(args));
        List remainingArgs = parser.getResidue();
        return new Options<O>(parser.getOptions(optionsClass), remainingArgs.toArray(new String[0]));
    }

    public static <O extends OptionsBase> Options<O> parseAndExitUponError(Class<O> optionsClass, boolean allowResidue, String ... args) {
        OptionsParser parser = null;
        try {
            parser = OptionsParser.builder().optionsClasses(optionsClass).allowResidue(allowResidue).build();
        }
        catch (OptionsParser.ConstructionException e) {
            System.err.println("Error constructing the options parser: " + e.getMessage());
            System.exit(2);
        }
        parser.parseAndExitUponError(args);
        List remainingArgs = parser.getResidue();
        return new Options<O>(parser.getOptions(optionsClass), remainingArgs.toArray(new String[0]));
    }

    public static <O extends OptionsBase> O getDefaults(Class<O> optionsClass) {
        try {
            return Options.parse(optionsClass, new String[0]).getOptions();
        }
        catch (OptionsParsingException e) {
            String message = "Error while parsing defaults: " + e.getMessage();
            throw new AssertionError((Object)message);
        }
    }

    public static String getUsage(Class<? extends OptionsBase> optionsClass) {
        StringBuilder usage = new StringBuilder();
        OptionsUsage.getUsage(optionsClass, usage);
        return usage.toString();
    }

    private Options(O options, String[] remainingArgs) {
        this.options = options;
        this.remainingArgs = remainingArgs;
    }

    public O getOptions() {
        return this.options;
    }

    public String[] getRemainingArgs() {
        return this.remainingArgs;
    }
}

