/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.common.options;

import com.google.common.collect.ImmutableList;
import com.google.devtools.common.options.OptionsParsingException;
import java.util.Objects;

public class OptionPriority
implements Comparable<OptionPriority> {
    private final PriorityCategory priorityCategory;
    private final ImmutableList<Integer> priorityIndices;
    private boolean alreadyExpanded = false;

    private OptionPriority(PriorityCategory priorityCategory, ImmutableList<Integer> priorityIndices) {
        this.priorityCategory = priorityCategory;
        this.priorityIndices = priorityIndices;
    }

    static OptionPriority lowestOptionPriorityAtCategory(PriorityCategory category) {
        return new OptionPriority(category, ImmutableList.of(Integer.valueOf(0)));
    }

    static OptionPriority nextOptionPriority(OptionPriority priority) {
        int lastElementPosition = priority.priorityIndices.size() - 1;
        return new OptionPriority(priority.priorityCategory, (ImmutableList<Integer>)((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll((Iterable)priority.priorityIndices.subList(0, lastElementPosition))).add((Object)((Integer)priority.priorityIndices.get(lastElementPosition) + 1))).build());
    }

    public static OptionPriority getChildPriority(OptionPriority parentPriority) throws OptionsParsingException {
        if (parentPriority.alreadyExpanded) {
            throw new OptionsParsingException("Tried to expand option too many times");
        }
        parentPriority.alreadyExpanded = true;
        return new OptionPriority(parentPriority.priorityCategory, (ImmutableList<Integer>)((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(parentPriority.priorityIndices)).add((Object)0)).build());
    }

    public PriorityCategory getPriorityCategory() {
        return this.priorityCategory;
    }

    @Override
    public int compareTo(OptionPriority o) {
        if (this.priorityCategory.equals((Object)o.priorityCategory)) {
            for (int i = 0; i < this.priorityIndices.size() && i < o.priorityIndices.size(); ++i) {
                if (((Integer)this.priorityIndices.get(i)).equals(o.priorityIndices.get(i))) continue;
                return ((Integer)this.priorityIndices.get(i)).compareTo((Integer)o.priorityIndices.get(i));
            }
            return Integer.compare(this.priorityIndices.size(), o.priorityIndices.size());
        }
        return Integer.compare(this.priorityCategory.ordinal(), o.priorityCategory.ordinal());
    }

    public boolean equals(Object o) {
        if (o instanceof OptionPriority) {
            OptionPriority other = (OptionPriority)o;
            return this.priorityCategory.equals((Object)other.priorityCategory) && this.priorityIndices.equals(other.priorityIndices);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.priorityCategory, this.priorityIndices});
    }

    public String toString() {
        return String.format("OptionPriority(%s,%s)", new Object[]{this.priorityCategory, this.priorityIndices});
    }

    public static enum PriorityCategory {
        DEFAULT,
        COMPUTED_DEFAULT,
        RC_FILE,
        COMMAND_LINE,
        INVOCATION_POLICY,
        SOFTWARE_REQUIREMENT;

    }
}

