/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.common.options;

import com.google.common.collect.ImmutableList;
import com.google.devtools.common.options.BoolOrEnumConverter;
import com.google.devtools.common.options.Converter;
import com.google.devtools.common.options.Converters;
import com.google.devtools.common.options.Option;
import com.google.devtools.common.options.OptionDocumentationCategory;
import com.google.devtools.common.options.OptionEffectTag;
import com.google.devtools.common.options.OptionMetadataTag;
import com.google.devtools.common.options.OptionsParser;
import com.google.devtools.common.options.OptionsParsingException;
import com.google.devtools.common.options.TriState;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nullable;

public class OptionDefinition
implements Comparable<OptionDefinition> {
    public static final String SPECIAL_NULL_DEFAULT_VALUE = "null";
    private final Field field;
    private final Option optionAnnotation;
    private volatile Converter<?> converter = null;
    private volatile Object defaultValue = null;
    static final Comparator<OptionDefinition> BY_OPTION_NAME = Comparator.comparing(OptionDefinition::getOptionName);
    static final Comparator<OptionDefinition> BY_CATEGORY = Comparator.comparing(OptionDefinition::getOptionCategory).thenComparing(BY_OPTION_NAME);

    static OptionDefinition extractOptionDefinition(Field field) {
        Option annotation;
        Option option = annotation = field == null ? null : field.getAnnotation(Option.class);
        if (annotation == null) {
            throw new NotAnOptionException(field);
        }
        return new OptionDefinition(field, annotation);
    }

    private OptionDefinition(Field field, Option optionAnnotation) {
        this.field = field;
        this.optionAnnotation = optionAnnotation;
    }

    public Field getField() {
        return this.field;
    }

    public String getOptionName() {
        return this.optionAnnotation.name();
    }

    public char getAbbreviation() {
        return this.optionAnnotation.abbrev();
    }

    public String getHelpText() {
        return this.optionAnnotation.help();
    }

    public String getValueTypeHelpText() {
        return this.optionAnnotation.valueHelp();
    }

    public String getUnparsedDefaultValue() {
        return this.optionAnnotation.defaultValue();
    }

    public String getOptionCategory() {
        return this.optionAnnotation.category();
    }

    public OptionDocumentationCategory getDocumentationCategory() {
        return this.optionAnnotation.documentationCategory();
    }

    public OptionEffectTag[] getOptionEffectTags() {
        return this.optionAnnotation.effectTags();
    }

    public OptionMetadataTag[] getOptionMetadataTags() {
        return this.optionAnnotation.metadataTags();
    }

    public boolean hasOptionMetadataTag(OptionMetadataTag tag) {
        return Arrays.stream(this.getOptionMetadataTags()).anyMatch(tag::equals);
    }

    public Class<? extends Converter> getProvidedConverter() {
        return this.optionAnnotation.converter();
    }

    public boolean allowsMultiple() {
        return this.optionAnnotation.allowMultiple();
    }

    public String[] getOptionExpansion() {
        return this.optionAnnotation.expansion();
    }

    public String[] getImplicitRequirements() {
        return this.optionAnnotation.implicitRequirements();
    }

    public String getDeprecationWarning() {
        return this.optionAnnotation.deprecationWarning();
    }

    public String getOldOptionName() {
        return this.optionAnnotation.oldName();
    }

    public boolean getOldNameWarning() {
        return this.optionAnnotation.oldNameWarning();
    }

    public boolean hasNegativeOption() {
        return this.getType().equals(Boolean.TYPE) || this.getType().equals(TriState.class);
    }

    public Class<?> getType() {
        return this.field.getType();
    }

    boolean isVoidField() {
        return this.getType().equals(Void.class);
    }

    public boolean isSpecialNullDefault() {
        return SPECIAL_NULL_DEFAULT_VALUE.equals(this.getUnparsedDefaultValue()) && !this.getType().isPrimitive();
    }

    public boolean isExpansionOption() {
        return this.getOptionExpansion().length > 0;
    }

    public boolean hasImplicitRequirements() {
        return this.getImplicitRequirements().length > 0;
    }

    Type getFieldSingularType() {
        Type fieldType = this.getField().getGenericType();
        if (this.allowsMultiple()) {
            ParameterizedType pfieldType = (ParameterizedType)fieldType;
            fieldType = pfieldType.getActualTypeArguments()[0];
        }
        return fieldType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Converter<?> getConverter() {
        if (this.converter != null) {
            return this.converter;
        }
        OptionDefinition optionDefinition = this;
        synchronized (optionDefinition) {
            if (this.converter != null) {
                return this.converter;
            }
            Class<? extends Converter> converterClass = this.getProvidedConverter();
            if (converterClass == Converter.class) {
                Type type = this.getFieldSingularType();
                this.converter = Converters.DEFAULT_CONVERTERS.get(type);
            } else {
                try {
                    Constructor<? extends Converter> constructor = converterClass.getDeclaredConstructor(new Class[0]);
                    constructor.setAccessible(true);
                    this.converter = constructor.newInstance(new Object[0]);
                }
                catch (IllegalArgumentException | ReflectiveOperationException | SecurityException e) {
                    throw new OptionsParser.ConstructionException(String.format("Error in the provided converter for option %s", this.getField().getName()), e);
                }
            }
            return this.converter;
        }
    }

    public boolean usesBooleanValueSyntax() {
        return this.getType().equals(Boolean.TYPE) || this.getType().equals(TriState.class) || this.getConverter() instanceof BoolOrEnumConverter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Object getDefaultValue(@Nullable Object conversionContext) {
        if (this.defaultValue != null) {
            return this.defaultValue;
        }
        OptionDefinition optionDefinition = this;
        synchronized (optionDefinition) {
            if (this.defaultValue != null) {
                return this.defaultValue;
            }
            if (this.isSpecialNullDefault()) {
                return this.allowsMultiple() ? ImmutableList.of() : null;
            }
            Converter<?> converter = this.getConverter();
            String defaultValueAsString = this.getUnparsedDefaultValue();
            try {
                Object convertedDefaultValue = converter.convert(defaultValueAsString, conversionContext);
                this.defaultValue = this.allowsMultiple() ? OptionDefinition.maybeWrapMultipleDefaultValue(convertedDefaultValue) : convertedDefaultValue;
            }
            catch (OptionsParsingException e) {
                throw new OptionsParser.ConstructionException(String.format("OptionsParsingException while retrieving the default value for %s: %s", this.getField().getName(), e.getMessage()), e);
            }
            return this.defaultValue;
        }
    }

    private static List<Object> maybeWrapMultipleDefaultValue(Object convertedDefaultValue) {
        if (convertedDefaultValue instanceof List) {
            return (List)convertedDefaultValue;
        }
        return Arrays.asList(convertedDefaultValue);
    }

    public boolean equals(Object object) {
        if (!(object instanceof OptionDefinition)) {
            return false;
        }
        OptionDefinition otherOption = (OptionDefinition)object;
        return this.field.equals(otherOption.field);
    }

    public int hashCode() {
        return this.field.hashCode();
    }

    @Override
    public int compareTo(OptionDefinition o) {
        return this.getOptionName().compareTo(o.getOptionName());
    }

    public String toString() {
        return String.format("option '--%s'", this.getOptionName());
    }

    static class NotAnOptionException
    extends OptionsParser.ConstructionException {
        NotAnOptionException(Field field) {
            super("The field " + field.getName() + " does not have the right annotation to be considered an option.");
        }
    }
}

