/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.common.options;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.devtools.common.options.DuplicateOptionDeclarationException;
import com.google.devtools.common.options.OpaqueOptionsData;
import com.google.devtools.common.options.OptionDefinition;
import com.google.devtools.common.options.OptionsBase;
import com.google.devtools.common.options.OptionsParser;
import com.google.devtools.common.options.UsesOnlyCoreTypes;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.concurrent.Immutable;

@Immutable
public class IsolatedOptionsData
extends OpaqueOptionsData {
    private static final ConcurrentMap<Class<? extends OptionsBase>, ImmutableList<OptionDefinition>> allOptionsFields = new ConcurrentHashMap<Class<? extends OptionsBase>, ImmutableList<OptionDefinition>>();
    private final ImmutableMap<Class<? extends OptionsBase>, Constructor<?>> optionsClasses;
    private final ImmutableMap<String, OptionDefinition> nameToField;
    private final ImmutableMap<String, OptionDefinition> oldNameToField;
    private final ImmutableMap<Character, OptionDefinition> abbrevToField;
    private final ImmutableMap<Class<? extends OptionsBase>, Boolean> usesOnlyCoreTypes;

    public static ImmutableList<OptionDefinition> getAllOptionDefinitionsForClass(Class<? extends OptionsBase> optionsClass) {
        return allOptionsFields.computeIfAbsent(optionsClass, optionsBaseClass -> Arrays.stream(optionsBaseClass.getFields()).map(field -> {
            try {
                return OptionDefinition.extractOptionDefinition(field);
            }
            catch (OptionDefinition.NotAnOptionException e) {
                return null;
            }
        }).filter(Objects::nonNull).sorted(OptionDefinition.BY_OPTION_NAME).collect(ImmutableList.toImmutableList()));
    }

    private IsolatedOptionsData(Map<Class<? extends OptionsBase>, Constructor<?>> optionsClasses, Map<String, OptionDefinition> nameToField, Map<String, OptionDefinition> oldNameToField, Map<Character, OptionDefinition> abbrevToField, Map<Class<? extends OptionsBase>, Boolean> usesOnlyCoreTypes) {
        this.optionsClasses = ImmutableMap.copyOf(optionsClasses);
        this.nameToField = ImmutableMap.copyOf(nameToField);
        this.oldNameToField = ImmutableMap.copyOf(oldNameToField);
        this.abbrevToField = ImmutableMap.copyOf(abbrevToField);
        this.usesOnlyCoreTypes = ImmutableMap.copyOf(usesOnlyCoreTypes);
    }

    protected IsolatedOptionsData(IsolatedOptionsData other) {
        this(other.optionsClasses, other.nameToField, other.oldNameToField, other.abbrevToField, other.usesOnlyCoreTypes);
    }

    public Collection<Class<? extends OptionsBase>> getOptionsClasses() {
        return this.optionsClasses.keySet();
    }

    public <T extends OptionsBase> Constructor<T> getConstructor(Class<T> clazz) {
        return this.optionsClasses.get(clazz);
    }

    public OptionDefinition getOptionDefinitionFromName(String name) {
        return this.nameToField.getOrDefault(name, this.oldNameToField.get(name));
    }

    public Iterable<Map.Entry<String, OptionDefinition>> getAllOptionDefinitions() {
        return this.nameToField.entrySet();
    }

    public OptionDefinition getFieldForAbbrev(char abbrev) {
        return this.abbrevToField.get(Character.valueOf(abbrev));
    }

    public boolean getUsesOnlyCoreTypes(Class<? extends OptionsBase> optionsClass) {
        return this.usesOnlyCoreTypes.get(optionsClass);
    }

    private static <A> void checkForCollisions(Map<A, OptionDefinition> aFieldMap, A optionName, String description) throws DuplicateOptionDeclarationException {
        if (aFieldMap.containsKey(optionName)) {
            throw new DuplicateOptionDeclarationException("Duplicate option name, due to " + description + ": --" + optionName);
        }
    }

    private static void checkForBooleanAliasCollisions(Map<String, String> booleanAliasMap, String optionName, String description) throws DuplicateOptionDeclarationException {
        if (booleanAliasMap.containsKey(optionName)) {
            throw new DuplicateOptionDeclarationException("Duplicate option name, due to " + description + " --" + optionName + ", it conflicts with a negating alias for boolean flag --" + booleanAliasMap.get(optionName));
        }
    }

    private static void checkAndUpdateBooleanAliases(Map<String, OptionDefinition> nameToFieldMap, Map<String, OptionDefinition> oldNameToFieldMap, Map<String, String> booleanAliasMap, String optionName) throws DuplicateOptionDeclarationException {
        IsolatedOptionsData.checkForCollisions(nameToFieldMap, "no" + optionName, "boolean option alias");
        IsolatedOptionsData.checkForCollisions(oldNameToFieldMap, "no" + optionName, "boolean option alias");
        booleanAliasMap.put("no" + optionName, optionName);
    }

    static IsolatedOptionsData from(Collection<Class<? extends OptionsBase>> classes) {
        LinkedHashMap constructorBuilder = new LinkedHashMap();
        LinkedHashMap<String, OptionDefinition> nameToFieldBuilder = new LinkedHashMap<String, OptionDefinition>();
        LinkedHashMap<String, OptionDefinition> oldNameToFieldBuilder = new LinkedHashMap<String, OptionDefinition>();
        HashMap<Character, OptionDefinition> abbrevToFieldBuilder = new HashMap<Character, OptionDefinition>();
        HashMap<String, String> booleanAliasMap = new HashMap<String, String>();
        HashMap<Class<? extends OptionsBase>, Boolean> usesOnlyCoreTypesBuilder = new HashMap<Class<? extends OptionsBase>, Boolean>();
        for (Class<? extends OptionsBase> parsedOptionsClass : classes) {
            try {
                Constructor<? extends OptionsBase> constructor = parsedOptionsClass.getConstructor(new Class[0]);
                constructorBuilder.put(parsedOptionsClass, constructor);
            }
            catch (NoSuchMethodException e) {
                throw new IllegalArgumentException(parsedOptionsClass + " lacks an accessible default constructor", e);
            }
            ImmutableList<OptionDefinition> optionDefinitions = IsolatedOptionsData.getAllOptionDefinitionsForClass(parsedOptionsClass);
            for (OptionDefinition optionDefinition : optionDefinitions) {
                try {
                    String optionName = optionDefinition.getOptionName();
                    IsolatedOptionsData.checkForCollisions(nameToFieldBuilder, optionName, "option name collision");
                    IsolatedOptionsData.checkForCollisions(oldNameToFieldBuilder, optionName, "option name collision with another option's old name");
                    IsolatedOptionsData.checkForBooleanAliasCollisions(booleanAliasMap, optionName, "option");
                    if (optionDefinition.usesBooleanValueSyntax()) {
                        IsolatedOptionsData.checkAndUpdateBooleanAliases(nameToFieldBuilder, oldNameToFieldBuilder, booleanAliasMap, optionName);
                    }
                    nameToFieldBuilder.put(optionName, optionDefinition);
                    if (!optionDefinition.getOldOptionName().isEmpty()) {
                        String oldName = optionDefinition.getOldOptionName();
                        IsolatedOptionsData.checkForCollisions(nameToFieldBuilder, oldName, "old option name collision with another option's canonical name");
                        IsolatedOptionsData.checkForCollisions(oldNameToFieldBuilder, oldName, "old option name collision with another old option name");
                        IsolatedOptionsData.checkForBooleanAliasCollisions(booleanAliasMap, oldName, "old option name");
                        if (optionDefinition.usesBooleanValueSyntax()) {
                            IsolatedOptionsData.checkAndUpdateBooleanAliases(nameToFieldBuilder, oldNameToFieldBuilder, booleanAliasMap, oldName);
                        }
                        oldNameToFieldBuilder.put(oldName, optionDefinition);
                    }
                    if (optionDefinition.getAbbreviation() == '\u0000') continue;
                    IsolatedOptionsData.checkForCollisions(abbrevToFieldBuilder, Character.valueOf(optionDefinition.getAbbreviation()), "option abbreviation");
                    abbrevToFieldBuilder.put(Character.valueOf(optionDefinition.getAbbreviation()), optionDefinition);
                }
                catch (DuplicateOptionDeclarationException e) {
                    throw new OptionsParser.ConstructionException(e);
                }
            }
            boolean usesOnlyCoreTypes = parsedOptionsClass.isAnnotationPresent(UsesOnlyCoreTypes.class);
            if (usesOnlyCoreTypes) {
                for (OptionDefinition optionDefinition : optionDefinitions) {
                    if (UsesOnlyCoreTypes.CORE_TYPES.contains(optionDefinition.getType())) continue;
                    throw new OptionsParser.ConstructionException("Options class '" + parsedOptionsClass.getName() + "' is marked as @UsesOnlyCoreTypes, but field '" + optionDefinition.getField().getName() + "' has type '" + optionDefinition.getType().getName() + "'");
                }
            }
            usesOnlyCoreTypesBuilder.put(parsedOptionsClass, usesOnlyCoreTypes);
        }
        return new IsolatedOptionsData(constructorBuilder, nameToFieldBuilder, oldNameToFieldBuilder, abbrevToFieldBuilder, usesOnlyCoreTypesBuilder);
    }
}

