/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.common.options;

import com.github.benmanes.caffeine.cache.CaffeineSpec;
import com.google.common.base.Ascii;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.devtools.common.options.Converter;
import com.google.devtools.common.options.EnumConverter;
import com.google.devtools.common.options.OptionsParser;
import com.google.devtools.common.options.OptionsParsingException;
import com.google.devtools.common.options.RegexPatternOption;
import com.google.devtools.common.options.TriState;
import java.io.Serializable;
import java.time.Duration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.annotation.Nullable;

public final class Converters {
    public static final String BLAZE_ALIASING_FLAG = "flag_alias";
    private static final ImmutableSet<String> ENABLED_REPS = ImmutableSet.of("true", "1", "yes", "t", "y");
    private static final ImmutableSet<String> DISABLED_REPS = ImmutableSet.of("false", "0", "no", "f", "n");
    public static final ImmutableMap<Class<?>, Converter<?>> DEFAULT_CONVERTERS = new ImmutableMap.Builder<Class<String>, StringConverter>().put(String.class, new StringConverter()).put(Integer.TYPE, (StringConverter)((Object)new IntegerConverter())).put(Long.TYPE, (StringConverter)((Object)new LongConverter())).put(Double.TYPE, (StringConverter)((Object)new DoubleConverter())).put(Boolean.TYPE, (StringConverter)((Object)new BooleanConverter())).put(TriState.class, (StringConverter)((Object)new TriStateConverter())).put(Duration.class, (StringConverter)((Object)new DurationConverter())).put(Void.class, (StringConverter)((Object)new VoidConverter())).build();

    static String joinEnglishList(Iterable<?> choices) {
        StringBuilder buf = new StringBuilder();
        Iterator<?> ii = choices.iterator();
        while (ii.hasNext()) {
            Object choice = ii.next();
            if (buf.length() > 0) {
                buf.append(ii.hasNext() ? ", " : " or ");
            }
            buf.append(choice);
        }
        return buf.length() == 0 ? "nothing" : buf.toString();
    }

    public static final class CaffeineSpecConverter
    extends Converter.Contextless<CaffeineSpec> {
        @Override
        public CaffeineSpec convert(String spec) throws OptionsParsingException {
            try {
                return CaffeineSpec.parse(spec);
            }
            catch (IllegalArgumentException e) {
                throw new OptionsParsingException("Failed to parse CaffeineSpec: " + e.getMessage(), e);
            }
        }

        @Override
        public String getTypeDescription() {
            return "Converts to a CaffeineSpec, or null if the input is empty";
        }
    }

    public static class PercentageConverter
    extends RangeConverter {
        public PercentageConverter() {
            super(0, 100);
        }
    }

    public static class HelpVerbosityConverter
    extends EnumConverter<OptionsParser.HelpVerbosity> {
        public HelpVerbosityConverter() {
            super(OptionsParser.HelpVerbosity.class, "--help_verbosity setting");
        }
    }

    public static class NamedIntegersConverter
    extends Converter.Contextless<Map.Entry<String, Integer>> {
        @Override
        public Map.Entry<String, Integer> convert(String input) throws OptionsParsingException {
            int pos = input.indexOf(61);
            if (pos == 0 || input.length() == 0) {
                throw new OptionsParsingException("Specify either 'value' or 'name=value', where 'value' is an integer");
            }
            if (pos < 0) {
                try {
                    return Maps.immutableEntry("", Integer.parseInt(input));
                }
                catch (NumberFormatException e) {
                    throw new OptionsParsingException("'" + input + "' is not an int", e);
                }
            }
            String name = input.substring(0, pos);
            String value = input.substring(pos + 1);
            try {
                return Maps.immutableEntry(name, Integer.parseInt(value));
            }
            catch (NumberFormatException e) {
                throw new OptionsParsingException("'" + value + "' is not an int", e);
            }
        }

        @Override
        public String getTypeDescription() {
            return "an integer or a named integer, 'name=value'";
        }
    }

    public static class OptionalAssignmentConverter
    extends Converter.Contextless<Map.Entry<String, String>> {
        @Override
        public Map.Entry<String, String> convert(String input) throws OptionsParsingException {
            int pos = input.indexOf(61);
            if (pos == 0 || input.length() == 0) {
                throw new OptionsParsingException("Variable definitions must be in the form of a 'name=value' or 'name' assignment");
            }
            if (pos < 0) {
                return Maps.immutableEntry(input, null);
            }
            String name = input.substring(0, pos);
            String value = input.substring(pos + 1);
            return Maps.immutableEntry(name, value);
        }

        @Override
        public String getTypeDescription() {
            return "a 'name=value' assignment with an optional value part";
        }
    }

    public static class StringToStringListConverter
    extends AssignmentToListOfValuesConverter<String, String> {
        public StringToStringListConverter() {
            super(new StringConverter(), new StringConverter(), AssignmentToListOfValuesConverter.AllowEmptyKeys.YES);
        }

        public Map.Entry<String, List<String>> convert(String input) throws OptionsParsingException {
            return this.convert(input, null);
        }

        @Override
        public String getTypeDescription() {
            return "a '[name=]value1[,..,valueN]' assignment";
        }
    }

    public static abstract class AssignmentToListOfValuesConverter<K, V>
    implements Converter<Map.Entry<K, List<V>>> {
        private static final Splitter SPLITTER = Splitter.on(',');
        private final Converter<K> keyConverter;
        private final Converter<V> valueConverter;
        private final AllowEmptyKeys allowEmptyKeys;

        public AssignmentToListOfValuesConverter(Converter<K> keyConverter, Converter<V> valueConverter, AllowEmptyKeys allowEmptyKeys) {
            this.keyConverter = keyConverter;
            this.valueConverter = valueConverter;
            this.allowEmptyKeys = allowEmptyKeys;
        }

        @Override
        public Map.Entry<K, List<V>> convert(String input, @Nullable Object conversionContext) throws OptionsParsingException {
            int pos = input.indexOf("=");
            if (this.allowEmptyKeys == AllowEmptyKeys.NO && pos <= 0) {
                throw new OptionsParsingException("Must be in the form of a 'key=value[,value]' assignment");
            }
            String key = pos <= 0 ? "" : input.substring(0, pos);
            List<String> values = SPLITTER.splitToList(input.substring(pos + 1));
            if (values.contains("")) {
                if (values.size() == 1) {
                    values = ImmutableList.of();
                } else {
                    throw new OptionsParsingException("Variable definitions must not contain empty strings or leading / trailing commas");
                }
            }
            ImmutableList.Builder convertedValues = ImmutableList.builder();
            for (String value : values) {
                convertedValues.add(this.valueConverter.convert(value, conversionContext));
            }
            return Maps.immutableEntry(this.keyConverter.convert(key, conversionContext), convertedValues.build());
        }

        public static enum AllowEmptyKeys {
            YES,
            NO;

        }
    }

    public static class FlagAliasConverter
    extends AssignmentConverter {
        @Override
        public Map.Entry<String, String> convert(String input) throws OptionsParsingException {
            Object entry = super.convert(input);
            String shortForm = (String)entry.getKey();
            Object longForm = (String)entry.getValue();
            String cmdLineAlias = "--flag_alias=" + input;
            if (!Pattern.matches("([\\w])*", shortForm)) {
                throw new OptionsParsingException(shortForm + " should only consist of word characters to be a valid alias name.", cmdLineAlias);
            }
            if (((String)longForm).contains("=")) {
                throw new OptionsParsingException("--flag_alias does not support flag value assignment.", cmdLineAlias);
            }
            longForm = "--" + (String)longForm;
            if (OptionsParser.STARLARK_SKIPPED_PREFIXES.stream().noneMatch(((String)longForm)::startsWith)) {
                throw new OptionsParsingException("--flag_alias only supports Starlark build settings.", cmdLineAlias);
            }
            return entry;
        }

        @Override
        public String getTypeDescription() {
            return "a 'name=value' flag alias";
        }
    }

    public static class StringToFloatAssignmentConverter
    extends Converter.Contextless<Map.Entry<String, Float>> {
        private static final AssignmentConverter baseConverter = new AssignmentConverter();

        @Override
        public Map.Entry<String, Float> convert(String input) throws OptionsParsingException, NumberFormatException {
            Object stringEntry = baseConverter.convert(input);
            return Maps.immutableEntry((String)stringEntry.getKey(), Float.valueOf(Float.parseFloat((String)stringEntry.getValue())));
        }

        @Override
        public String getTypeDescription() {
            return "a named float, 'name=value'";
        }
    }

    public static class AssignmentConverter
    extends Converter.Contextless<Map.Entry<String, String>> {
        @Override
        public Map.Entry<String, String> convert(String input) throws OptionsParsingException {
            int pos = input.indexOf("=");
            if (pos <= 0) {
                throw new OptionsParsingException("Variable definitions must be in the form of a 'name=value' assignment");
            }
            String name = input.substring(0, pos);
            String value = input.substring(pos + 1);
            return Maps.immutableEntry(name, value);
        }

        @Override
        public String getTypeDescription() {
            return "a 'name=value' assignment";
        }
    }

    public static class RangeConverter
    extends Converter.Contextless<Integer> {
        final int minValue;
        final int maxValue;

        public RangeConverter(int minValue, int maxValue) {
            this.minValue = minValue;
            this.maxValue = maxValue;
        }

        @Override
        public Integer convert(String input) throws OptionsParsingException {
            try {
                int value = Integer.parseInt(input);
                if (value < this.minValue) {
                    throw new OptionsParsingException("'" + input + "' should be >= " + this.minValue);
                }
                if (value < this.minValue || value > this.maxValue) {
                    throw new OptionsParsingException("'" + input + "' should be <= " + this.maxValue);
                }
                return value;
            }
            catch (NumberFormatException e) {
                throw new OptionsParsingException("'" + input + "' is not an int", e);
            }
        }

        @Override
        public String getTypeDescription() {
            if (this.minValue == Integer.MIN_VALUE) {
                if (this.maxValue == Integer.MAX_VALUE) {
                    return "an integer";
                }
                return "an integer, <= " + this.maxValue;
            }
            if (this.maxValue == Integer.MAX_VALUE) {
                return "an integer, >= " + this.minValue;
            }
            return "an integer in " + (Serializable)(this.minValue < 0 ? "(" + this.minValue + ")" : Integer.valueOf(this.minValue)) + "-" + this.maxValue + " range";
        }
    }

    public static class LengthLimitingConverter
    extends Converter.Contextless<String> {
        private final int maxSize;

        public LengthLimitingConverter(int maxSize) {
            this.maxSize = maxSize;
        }

        @Override
        public String convert(String input) throws OptionsParsingException {
            if (input.length() > this.maxSize) {
                throw new OptionsParsingException("Input must be " + this.getTypeDescription());
            }
            return input;
        }

        @Override
        public String getTypeDescription() {
            return "a string <= " + this.maxSize + " characters";
        }
    }

    public static class RegexPatternConverter
    extends Converter.Contextless<RegexPatternOption> {
        @Override
        public RegexPatternOption convert(String input) throws OptionsParsingException {
            try {
                return RegexPatternOption.create(Pattern.compile(input));
            }
            catch (PatternSyntaxException e) {
                throw new OptionsParsingException("Not a valid regular expression: " + e.getMessage());
            }
        }

        @Override
        public String getTypeDescription() {
            return "a valid Java regular expression";
        }
    }

    public static class StringSetConverter
    extends Converter.Contextless<String> {
        private final ImmutableList<String> values;

        public StringSetConverter(String ... values) {
            this.values = ImmutableList.copyOf(values);
        }

        @Override
        public String convert(String input) throws OptionsParsingException {
            if (this.values.contains(input)) {
                return input;
            }
            throw new OptionsParsingException("Not one of " + this.values);
        }

        @Override
        public String getTypeDescription() {
            return Converters.joinEnglishList(this.values);
        }
    }

    public static class LogLevelConverter
    extends Converter.Contextless<Level> {
        static final ImmutableList<Level> LEVELS = ImmutableList.of(Level.OFF, Level.SEVERE, Level.WARNING, Level.INFO, Level.FINE, Level.FINER, Level.FINEST);

        @Override
        public Level convert(String input) throws OptionsParsingException {
            try {
                int level = Integer.parseInt(input);
                return (Level)LEVELS.get(level);
            }
            catch (ArrayIndexOutOfBoundsException | NumberFormatException e) {
                throw new OptionsParsingException("Not a log level: " + input, e);
            }
        }

        @Override
        public String getTypeDescription() {
            return "0 <= an integer <= " + (LEVELS.size() - 1);
        }
    }

    public static class CommaSeparatedOptionSetConverter
    extends SeparatedOptionSetConverter {
        public CommaSeparatedOptionSetConverter() {
            super(',', "comma", true);
        }
    }

    public static class ColonSeparatedOptionListConverter
    extends SeparatedOptionListConverter {
        public ColonSeparatedOptionListConverter() {
            super(':', "colon", true);
        }
    }

    public static class CommaSeparatedNonEmptyOptionListConverter
    extends SeparatedOptionListConverter {
        public CommaSeparatedNonEmptyOptionListConverter() {
            super(',', "comma", false);
        }
    }

    public static class CommaSeparatedOptionListConverter
    extends SeparatedOptionListConverter {
        public CommaSeparatedOptionListConverter() {
            super(',', "comma", true);
        }
    }

    public static class SeparatedOptionSetConverter
    extends SeparatedOptionListConverter {
        private final String separatorDescription;

        protected SeparatedOptionSetConverter(char separator, String separatorDescription, boolean allowEmptyValues) {
            super(separator, separatorDescription, allowEmptyValues);
            this.separatorDescription = separatorDescription;
        }

        @Override
        public ImmutableList<String> convert(String input) throws OptionsParsingException {
            Object result = super.convert(input);
            return result.stream().distinct().sorted().collect(ImmutableList.toImmutableList());
        }

        @Override
        public String getTypeDescription() {
            return this.separatorDescription + "-separated set of options";
        }
    }

    public static class SeparatedOptionListConverter
    extends Converter.Contextless<ImmutableList<String>> {
        private final String separatorDescription;
        private final Splitter splitter;
        private final boolean allowEmptyValues;

        protected SeparatedOptionListConverter(char separator, String separatorDescription, boolean allowEmptyValues) {
            this.separatorDescription = separatorDescription;
            this.splitter = Splitter.on(separator);
            this.allowEmptyValues = allowEmptyValues;
        }

        @Override
        public ImmutableList<String> convert(String input) throws OptionsParsingException {
            ImmutableList<String> result;
            ImmutableList<String> immutableList = result = input.isEmpty() ? ImmutableList.of() : ImmutableList.copyOf(this.splitter.split(input));
            if (!this.allowEmptyValues && result.contains("")) {
                if (result.size() == 1) {
                    return ImmutableList.of();
                }
                throw new OptionsParsingException("Empty values are not allowed as part of this " + this.getTypeDescription());
            }
            return result;
        }

        @Override
        public String getTypeDescription() {
            return this.separatorDescription + "-separated list of options";
        }
    }

    public static class DurationConverter
    extends Converter.Contextless<Duration> {
        private static final Pattern DURATION_REGEX = Pattern.compile("^([0-9]+)(d|h|m|s|ms)$");

        @Override
        public Duration convert(String input) throws OptionsParsingException {
            String unit;
            if ("0".equals(input)) {
                return Duration.ZERO;
            }
            Matcher m4 = DURATION_REGEX.matcher(input);
            if (!m4.matches()) {
                throw new OptionsParsingException("Illegal duration '" + input + "'.");
            }
            long duration = Long.parseLong(m4.group(1));
            switch (unit = m4.group(2)) {
                case "d": {
                    return Duration.ofDays(duration);
                }
                case "h": {
                    return Duration.ofHours(duration);
                }
                case "m": {
                    return Duration.ofMinutes(duration);
                }
                case "s": {
                    return Duration.ofSeconds(duration);
                }
                case "ms": {
                    return Duration.ofMillis(duration);
                }
            }
            throw new IllegalStateException("This must not happen. Did you update the regex without the switch case?");
        }

        @Override
        public String getTypeDescription() {
            return "An immutable length of time.";
        }
    }

    public static class VoidConverter
    extends Converter.Contextless<Void> {
        @Override
        public Void convert(String input) throws OptionsParsingException {
            if (input == null || input.equals("null")) {
                return null;
            }
            throw new OptionsParsingException("'" + input + "' unexpected");
        }

        @Override
        public String getTypeDescription() {
            return "";
        }
    }

    public static class TriStateConverter
    extends Converter.Contextless<TriState> {
        @Override
        public TriState convert(String input) throws OptionsParsingException {
            if (input == null) {
                return TriState.AUTO;
            }
            if ((input = Ascii.toLowerCase(input)).equals("auto")) {
                return TriState.AUTO;
            }
            if (ENABLED_REPS.contains(input)) {
                return TriState.YES;
            }
            if (DISABLED_REPS.contains(input)) {
                return TriState.NO;
            }
            throw new OptionsParsingException("'" + input + "' is not a boolean");
        }

        @Override
        public String getTypeDescription() {
            return "a tri-state (auto, yes, no)";
        }
    }

    public static class DoubleConverter
    extends Converter.Contextless<Double> {
        @Override
        public Double convert(String input) throws OptionsParsingException {
            try {
                return Double.parseDouble(input);
            }
            catch (NumberFormatException e) {
                throw new OptionsParsingException("'" + input + "' is not a double", e);
            }
        }

        @Override
        public String getTypeDescription() {
            return "a double";
        }
    }

    public static class LongConverter
    extends Converter.Contextless<Long> {
        @Override
        public Long convert(String input) throws OptionsParsingException {
            try {
                return Long.decode(input);
            }
            catch (NumberFormatException e) {
                throw new OptionsParsingException("'" + input + "' is not a long", e);
            }
        }

        @Override
        public String getTypeDescription() {
            return "a long integer";
        }
    }

    public static class IntegerConverter
    extends Converter.Contextless<Integer> {
        @Override
        public Integer convert(String input) throws OptionsParsingException {
            try {
                return Integer.decode(input);
            }
            catch (NumberFormatException e) {
                throw new OptionsParsingException("'" + input + "' is not an int", e);
            }
        }

        @Override
        public String getTypeDescription() {
            return "an integer";
        }
    }

    public static class StringConverter
    extends Converter.Contextless<String> {
        @Override
        public String convert(String input) {
            return input;
        }

        @Override
        public String getTypeDescription() {
            return "a string";
        }
    }

    public static class BooleanConverter
    extends Converter.Contextless<Boolean> {
        @Override
        public Boolean convert(String input) throws OptionsParsingException {
            if (input == null) {
                return false;
            }
            if (ENABLED_REPS.contains(input = Ascii.toLowerCase(input))) {
                return true;
            }
            if (DISABLED_REPS.contains(input)) {
                return false;
            }
            throw new OptionsParsingException("'" + input + "' is not a boolean");
        }

        @Override
        public String getTypeDescription() {
            return "a boolean";
        }
    }
}

