/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.skyframe;

import com.google.devtools.build.lib.bugreport.BugReport;
import com.google.devtools.build.lib.concurrent.PooledInterner;
import com.google.devtools.build.lib.util.TestType;
import com.google.devtools.build.skyframe.SkyFunctionName;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.Serializable;
import javax.annotation.Nullable;

public interface SkyKey
extends Serializable {
    public SkyFunctionName functionName();

    default public Object argument() {
        return this;
    }

    default public boolean valueIsShareable() {
        return true;
    }

    default public boolean supportsPartialReevaluation() {
        return false;
    }

    @Nullable
    default public SkyKeyInterner<?> getSkyKeyInterner() {
        return null;
    }

    public static <T extends SkyKey> SkyKeyInterner<T> newInterner() {
        return new SkyKeyInterner();
    }

    default public boolean hasLowFanout() {
        return false;
    }

    public static final class SkyKeyInterner<T extends SkyKey>
    extends PooledInterner<T> {
        @Nullable
        static PooledInterner.Pool<? extends SkyKey> globalPool = null;

        static void setGlobalPool(@Nullable PooledInterner.Pool<SkyKey> pool) {
            if (!(pool == null || globalPool == null || TestType.isInTest() && TestType.getTestType() != TestType.SHELL_INTEGRATION)) {
                BugReport.sendNonFatalBugReport(new IllegalStateException("Global SkyKey pool not cleared before setting another"));
            }
            globalPool = pool;
        }

        @Override
        protected PooledInterner.Pool<T> getPool() {
            return globalPool;
        }

        @CanIgnoreReturnValue
        T weakInternUnchecked(SkyKey sample) {
            return (T)this.weakIntern(sample);
        }
    }
}

