/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.skyframe;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Interner;
import com.google.devtools.build.lib.concurrent.BlazeInterners;
import com.google.devtools.build.skyframe.FunctionHermeticity;
import com.google.devtools.build.skyframe.SkyKey;
import java.util.Set;

public final class SkyFunctionName {
    private static final Interner<SkyFunctionName> interner = BlazeInterners.newStrongInterner();
    public static final SkyFunctionName FOR_TESTING = SkyFunctionName.createHermetic("FOR_TESTING");
    private final String name;
    private final FunctionHermeticity hermeticity;

    public static SkyFunctionName createNonHermetic(String name) {
        return SkyFunctionName.create(name, FunctionHermeticity.NONHERMETIC);
    }

    public static SkyFunctionName createSemiHermetic(String name) {
        return SkyFunctionName.create(name, FunctionHermeticity.SEMI_HERMETIC);
    }

    public static SkyFunctionName createHermetic(String name) {
        return SkyFunctionName.create(name, FunctionHermeticity.HERMETIC);
    }

    private static SkyFunctionName create(String name, FunctionHermeticity hermeticity) {
        SkyFunctionName cached = interner.intern(new SkyFunctionName(name, hermeticity));
        Preconditions.checkState(cached.hermeticity.equals((Object)hermeticity), "Tried to create SkyFunctionName objects with same name (%s) but different hermeticity (old=%s, new=%s)", (Object)name, (Object)cached.hermeticity, (Object)hermeticity);
        return cached;
    }

    private SkyFunctionName(String name, FunctionHermeticity hermeticity) {
        this.name = Preconditions.checkNotNull(name);
        this.hermeticity = Preconditions.checkNotNull(hermeticity);
    }

    public String getName() {
        return this.name;
    }

    public FunctionHermeticity getHermeticity() {
        return this.hermeticity;
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SkyFunctionName)) {
            return false;
        }
        SkyFunctionName other = (SkyFunctionName)obj;
        return this.name.equals(other.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public static Predicate<SkyKey> functionIs(SkyFunctionName functionName) {
        return skyKey -> functionName.equals(skyKey.functionName());
    }

    public static Predicate<SkyKey> functionIsIn(Set<SkyFunctionName> functionNames) {
        return skyKey -> functionNames.contains(skyKey.functionName());
    }
}

