/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.skyframe;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.devtools.build.lib.collect.compacthashset.CompactHashSet;
import com.google.devtools.build.lib.skyframe.serialization.autocodec.AutoCodec;
import com.google.devtools.build.lib.skyframe.serialization.autocodec.SerializationConstant;
import com.google.devtools.build.skyframe.SkyKey;
import java.lang.annotation.ElementType;
import java.lang.annotation.Target;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.checkerframework.framework.qual.DefaultQualifierInHierarchy;
import org.checkerframework.framework.qual.LiteralKind;
import org.checkerframework.framework.qual.QualifierForLiterals;
import org.checkerframework.framework.qual.SubtypeOf;

public class GroupedDeps
implements Iterable<List<SkyKey>> {
    private int size;
    private final ArrayList<Object> elements;
    private final ArrayList<Integer> groupIndices;
    private final CollectionView collectionView = new CollectionView();
    @SerializationConstant
    @AutoCodec.VisibleForSerialization
    static final @Compressed Object EMPTY_COMPRESSED = new Object();

    public GroupedDeps() {
        this(0, GroupedDeps.newSmallArrayList());
    }

    private GroupedDeps(int size, ArrayList<Object> elements) {
        this(size, elements, GroupedDeps.newSmallArrayList());
    }

    private GroupedDeps(int size, ArrayList<Object> elements, ArrayList<Integer> groupIndices) {
        this.size = size;
        this.elements = elements;
        this.groupIndices = groupIndices;
    }

    private static <T> ArrayList<T> newSmallArrayList() {
        return new ArrayList(1);
    }

    public void appendSingleton(SkyKey key) {
        this.markNextGroup();
        this.elements.add(key);
        ++this.size;
    }

    public void appendGroup(List<SkyKey> group) {
        this.appendNextGroup(group.iterator(), group.size());
    }

    public void appendGroups(Set<SkyKey> deps, List<Integer> groupSizes) {
        this.elements.ensureCapacity(this.elements.size() + deps.size());
        if (this.isEmpty()) {
            this.groupIndices.ensureCapacity(groupSizes.size() - 1);
        } else {
            this.groupIndices.ensureCapacity(this.groupIndices.size() + groupSizes.size());
        }
        Iterator<SkyKey> it = deps.iterator();
        for (Integer size : groupSizes) {
            this.appendNextGroup(it, size);
        }
        Preconditions.checkArgument(!it.hasNext(), "size(deps) != sum(groupSizes) (deps=%s, groupSizes=%s)", deps, groupSizes);
    }

    private void appendNextGroup(Iterator<SkyKey> it, Integer groupSize) {
        if (groupSize == 0) {
            return;
        }
        if (groupSize == 1) {
            this.appendSingleton(it.next());
            return;
        }
        this.markNextGroup();
        this.elements.ensureCapacity(this.elements.size() + groupSize + 1);
        this.elements.add(groupSize);
        for (int i = 0; i < groupSize; ++i) {
            this.elements.add(it.next());
        }
        this.size += groupSize.intValue();
    }

    private void markNextGroup() {
        if (!this.isEmpty()) {
            this.groupIndices.add(this.elements.size());
        }
    }

    public void remove(Set<SkyKey> toRemove) {
        if (toRemove.isEmpty()) {
            return;
        }
        GroupedDeps newDeps = new GroupedDeps();
        for (List<SkyKey> group : this) {
            ArrayList<SkyKey> newGroup = new ArrayList<SkyKey>(group.size());
            for (SkyKey key : group) {
                if (toRemove.contains(key)) continue;
                newGroup.add(key);
            }
            newDeps.appendGroup(newGroup);
        }
        Preconditions.checkArgument(newDeps.size == this.size - toRemove.size(), "Requested removal of absent element(s) (toRemove=%s, elements=%s)", toRemove, this.elements);
        this.size = newDeps.size;
        this.elements.clear();
        this.elements.addAll(newDeps.elements);
        this.groupIndices.clear();
        this.groupIndices.addAll(newDeps.groupIndices);
    }

    public List<SkyKey> getDepGroup(int i) {
        int index = i == 0 ? 0 : this.groupIndices.get(i - 1);
        Object obj = this.elements.get(index);
        if (obj instanceof SkyKey) {
            return ImmutableList.of((SkyKey)obj);
        }
        int groupSize = (Integer)obj;
        List<Object> slice = this.elements.subList(index + 1, index + 1 + groupSize);
        return Collections.unmodifiableList(slice);
    }

    public int numGroups() {
        return this.isEmpty() ? 0 : this.groupIndices.size() + 1;
    }

    public int numElements() {
        return this.size;
    }

    public static int numElements(@Compressed Object compressed) {
        switch (GroupedDeps.compressionCase(compressed)) {
            case EMPTY: {
                return 0;
            }
            case SINGLETON: {
                return 1;
            }
            case MULTIPLE: {
                Object[] arr = (Object[])compressed;
                int size = 0;
                int i = 0;
                while (i < arr.length) {
                    Object obj;
                    if ((obj = arr[i++]) instanceof SkyKey) {
                        ++size;
                        continue;
                    }
                    int groupSize = (Integer)obj;
                    size += groupSize;
                    i += groupSize;
                }
                return size;
            }
        }
        throw new AssertionError(compressed);
    }

    private static CompressionCase compressionCase(@Compressed Object compressed) {
        if (compressed == EMPTY_COMPRESSED) {
            return CompressionCase.EMPTY;
        }
        if (compressed instanceof SkyKey) {
            return CompressionCase.SINGLETON;
        }
        Preconditions.checkArgument(compressed.getClass().isArray(), compressed);
        return CompressionCase.MULTIPLE;
    }

    public static Iterable<SkyKey> compressedToIterable(@Compressed Object compressed) {
        switch (GroupedDeps.compressionCase(compressed)) {
            case EMPTY: {
                return ImmutableList.of();
            }
            case SINGLETON: {
                return ImmutableList.of((SkyKey)compressed);
            }
            case MULTIPLE: {
                List<Object> elements = Arrays.asList((Object[])compressed);
                return () -> new UngroupedIterator(elements);
            }
        }
        throw new AssertionError(compressed);
    }

    public static @Compressed Object castAsCompressed(Object obj) {
        Preconditions.checkArgument(obj == EMPTY_COMPRESSED || obj instanceof SkyKey || obj.getClass().isArray());
        return obj;
    }

    public boolean isEmpty() {
        return this.elements.isEmpty();
    }

    public static boolean isEmpty(@Compressed Object compressed) {
        return compressed == EMPTY_COMPRESSED;
    }

    public boolean contains(SkyKey key) {
        return this.elements.contains(key);
    }

    public @Compressed Object compress() {
        switch (this.numElements()) {
            case 0: {
                return EMPTY_COMPRESSED;
            }
            case 1: {
                return this.elements.get(0);
            }
        }
        return this.elements.toArray();
    }

    public ImmutableSet<SkyKey> toSet() {
        ImmutableSet.Builder builder = ImmutableSet.builderWithExpectedSize(this.size);
        for (Object obj : this.elements) {
            if (!(obj instanceof SkyKey)) continue;
            builder.add((SkyKey)obj);
        }
        return builder.build();
    }

    public static GroupedDeps decompress(@Compressed Object compressed) {
        switch (GroupedDeps.compressionCase(compressed)) {
            case EMPTY: {
                return new GroupedDeps();
            }
            case SINGLETON: {
                return new GroupedDeps(1, Lists.newArrayList(compressed));
            }
            case MULTIPLE: {
                Object[] arr = (Object[])compressed;
                int size = 0;
                ArrayList<Integer> groupIndices = GroupedDeps.newSmallArrayList();
                int i = 0;
                while (i < arr.length) {
                    Object obj;
                    if (i > 0) {
                        groupIndices.add(i);
                    }
                    if ((obj = arr[i++]) instanceof SkyKey) {
                        ++size;
                        continue;
                    }
                    int groupSize = (Integer)obj;
                    size += groupSize;
                    i += groupSize;
                }
                return new GroupedDeps(size, Lists.newArrayList(arr), groupIndices);
            }
        }
        throw new AssertionError(compressed);
    }

    public int hashCode() {
        throw new UnsupportedOperationException("Should not need to get hash for " + this);
    }

    private static boolean checkUnorderedEqualityOfGroups(List<SkyKey> group1, List<SkyKey> group2) {
        if (group1.size() != group2.size()) {
            return false;
        }
        return group1.equals(group2) || CompactHashSet.create(group1).containsAll(group2);
    }

    public Collection<SkyKey> getAllElementsAsIterable() {
        return this.collectionView;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof GroupedDeps)) {
            return false;
        }
        GroupedDeps that = (GroupedDeps)other;
        if (this.size != that.size || this.elements.size() != that.elements.size() || this.numGroups() != that.numGroups()) {
            return false;
        }
        Iterator<List<SkyKey>> thisIt = this.iterator();
        Iterator<List<SkyKey>> thatIt = that.iterator();
        while (thisIt.hasNext()) {
            if (GroupedDeps.checkUnorderedEqualityOfGroups(thisIt.next(), thatIt.next())) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("size", this.size).add("elements", this.elements).toString();
    }

    @Override
    public Iterator<List<SkyKey>> iterator() {
        return new GroupedIterator();
    }

    public static final class WithHashSet
    extends GroupedDeps {
        private final HashSet<SkyKey> set = new HashSet();

        @Override
        public void appendSingleton(SkyKey key) {
            super.appendSingleton(key);
            this.set.add(key);
        }

        @Override
        public void appendGroup(List<SkyKey> group) {
            super.appendGroup(group);
            this.set.addAll(group);
        }

        @Override
        public void appendGroups(Set<SkyKey> deps, List<Integer> groupSizes) {
            super.appendGroups(deps, groupSizes);
            this.set.addAll(deps);
        }

        @Override
        public void remove(Set<SkyKey> toRemove) {
            super.remove(toRemove);
            this.set.removeAll(toRemove);
        }

        @Override
        public boolean contains(SkyKey needle) {
            return this.set.contains(needle);
        }

        @Override
        public ImmutableSet<SkyKey> toSet() {
            return ImmutableSet.copyOf(this.set);
        }
    }

    private class GroupedIterator
    implements Iterator<List<SkyKey>> {
        private int i = 0;

        private GroupedIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.i < GroupedDeps.this.numGroups();
        }

        @Override
        public List<SkyKey> next() {
            return GroupedDeps.this.getDepGroup(this.i++);
        }
    }

    private static final class UngroupedIterator
    implements Iterator<SkyKey> {
        private final List<Object> elements;
        private int i = 0;

        private UngroupedIterator(List<Object> elements) {
            this.elements = elements;
            this.advanceIfSizeMarker();
        }

        @Override
        public boolean hasNext() {
            return this.i < this.elements.size();
        }

        @Override
        public SkyKey next() {
            SkyKey next = (SkyKey)this.elements.get(this.i++);
            this.advanceIfSizeMarker();
            return next;
        }

        private void advanceIfSizeMarker() {
            if (this.i < this.elements.size() && this.elements.get(this.i) instanceof Integer) {
                ++this.i;
            }
        }
    }

    private final class CollectionView
    extends AbstractCollection<SkyKey> {
        private CollectionView() {
        }

        @Override
        public Iterator<SkyKey> iterator() {
            return new UngroupedIterator(GroupedDeps.this.elements);
        }

        @Override
        public int size() {
            return GroupedDeps.this.size;
        }
    }

    private static enum CompressionCase {
        EMPTY,
        SINGLETON,
        MULTIPLE;

    }

    @DefaultQualifierInHierarchy
    @SubtypeOf(value={})
    @Target(value={ElementType.TYPE_USE, ElementType.TYPE_PARAMETER})
    private static @interface DefaultObject {
    }

    @SubtypeOf(value={DefaultObject.class})
    @Target(value={ElementType.TYPE_USE, ElementType.TYPE_PARAMETER})
    @QualifierForLiterals(value={LiteralKind.NULL})
    public static @interface Compressed {
    }
}

