/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.skyframe;

import com.google.common.base.Preconditions;
import com.google.devtools.build.skyframe.SkyKey;

public abstract class AbstractSkyKey<T>
implements SkyKey {
    protected final T arg;

    protected AbstractSkyKey(T arg) {
        this.arg = Preconditions.checkNotNull(arg);
    }

    public final T argument() {
        return this.arg;
    }

    public int hashCode() {
        return 31 * this.functionName().hashCode() + this.arg.hashCode();
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (this instanceof WithCachedHashCode && this.hashCode() != obj.hashCode()) {
            return false;
        }
        AbstractSkyKey that = (AbstractSkyKey)obj;
        return this.functionName().equals(that.functionName()) && this.arg.equals(that.arg);
    }

    public String toString() {
        return this.functionName() + ":" + this.arg;
    }

    public static abstract class WithCachedHashCode<T>
    extends AbstractSkyKey<T> {
        private final transient int hashCode = super.hashCode();

        protected WithCachedHashCode(T arg) {
            super(arg);
        }

        @Override
        public final int hashCode() {
            return this.hashCode;
        }
    }
}

