/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.skydoc.rendering;

import com.google.devtools.build.skydoc.rendering.DocstringParseException;
import com.google.devtools.build.skydoc.rendering.FunctionUtil;
import com.google.devtools.build.skydoc.rendering.proto.StardocOutputProtos;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import net.starlark.java.eval.StarlarkFunction;

public class ProtoRenderer {
    private final StardocOutputProtos.ModuleInfo.Builder moduleInfo = StardocOutputProtos.ModuleInfo.newBuilder();

    @CanIgnoreReturnValue
    public ProtoRenderer appendRuleInfos(Collection<StardocOutputProtos.RuleInfo> ruleInfos) {
        for (StardocOutputProtos.RuleInfo ruleInfo : ruleInfos) {
            this.moduleInfo.addRuleInfo(ruleInfo);
        }
        return this;
    }

    @CanIgnoreReturnValue
    public ProtoRenderer appendProviderInfos(Collection<StardocOutputProtos.ProviderInfo> providerInfos) {
        for (StardocOutputProtos.ProviderInfo providerInfo : providerInfos) {
            this.moduleInfo.addProviderInfo(providerInfo);
        }
        return this;
    }

    @CanIgnoreReturnValue
    public ProtoRenderer appendStarlarkFunctionInfos(Map<String, StarlarkFunction> funcInfosMap) throws DocstringParseException {
        for (Map.Entry<String, StarlarkFunction> entry : funcInfosMap.entrySet()) {
            StardocOutputProtos.StarlarkFunctionInfo funcInfo = FunctionUtil.fromNameAndFunction(entry.getKey(), entry.getValue());
            this.moduleInfo.addFuncInfo(funcInfo);
        }
        return this;
    }

    @CanIgnoreReturnValue
    public ProtoRenderer setModuleDocstring(String moduleDoc) {
        this.moduleInfo.setModuleDocstring(moduleDoc);
        return this;
    }

    public void writeModuleInfo(BufferedOutputStream outputStream) throws IOException {
        StardocOutputProtos.ModuleInfo build = this.moduleInfo.build();
        build.writeTo(outputStream);
    }

    @CanIgnoreReturnValue
    public ProtoRenderer appendAspectInfos(Collection<StardocOutputProtos.AspectInfo> aspectInfos) {
        for (StardocOutputProtos.AspectInfo aspectInfo : aspectInfos) {
            this.moduleInfo.addAspectInfo(aspectInfo);
        }
        return this;
    }

    public StardocOutputProtos.ModuleInfo.Builder getModuleInfo() {
        return this.moduleInfo;
    }
}

