/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.skydoc.rendering;

import com.google.devtools.build.skydoc.rendering.MarkdownUtil;
import com.google.devtools.build.skydoc.rendering.proto.StardocOutputProtos;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.MethodInvocationException;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader;
import org.apache.velocity.runtime.resource.loader.JarResourceLoader;

public class MarkdownRenderer {
    private final String headerTemplateFilename;
    private final String ruleTemplateFilename;
    private final String providerTemplateFilename;
    private final String functionTemplateFilename;
    private final String aspectTemplateFilename;
    private final VelocityEngine velocityEngine;

    public MarkdownRenderer(String headerTemplate, String ruleTemplate, String providerTemplate, String functionTemplate, String aspectTemplate) {
        this.headerTemplateFilename = headerTemplate;
        this.ruleTemplateFilename = ruleTemplate;
        this.providerTemplateFilename = providerTemplate;
        this.functionTemplateFilename = functionTemplate;
        this.aspectTemplateFilename = aspectTemplate;
        this.velocityEngine = new VelocityEngine();
        this.velocityEngine.setProperty("resource.loader", "classpath, jar");
        this.velocityEngine.setProperty("classpath.resource.loader.class", ClasspathResourceLoader.class.getName());
        this.velocityEngine.setProperty("jar.resource.loader.class", JarResourceLoader.class.getName());
        this.velocityEngine.setProperty("input.encoding", "UTF-8");
        this.velocityEngine.setProperty("output.encoding", "UTF-8");
        this.velocityEngine.setProperty("runtime.references.strict", true);
        this.velocityEngine.setProperty("parser.space_gobbling", "bc");
    }

    public String renderMarkdownHeader(StardocOutputProtos.ModuleInfo moduleInfo) throws IOException {
        VelocityContext context = new VelocityContext();
        context.put("util", new MarkdownUtil());
        context.put("moduleDocstring", moduleInfo.getModuleDocstring());
        StringWriter stringWriter = new StringWriter();
        Reader reader = MarkdownRenderer.readerFromPath(this.headerTemplateFilename);
        try {
            this.velocityEngine.evaluate((Context)context, (Writer)stringWriter, this.headerTemplateFilename, reader);
        }
        catch (MethodInvocationException | ParseErrorException | ResourceNotFoundException e) {
            throw new IOException(e);
        }
        return stringWriter.toString();
    }

    public String render(String ruleName, StardocOutputProtos.RuleInfo ruleInfo) throws IOException {
        VelocityContext context = new VelocityContext();
        context.put("util", new MarkdownUtil());
        context.put("ruleName", ruleName);
        context.put("ruleInfo", ruleInfo);
        StringWriter stringWriter = new StringWriter();
        Reader reader = MarkdownRenderer.readerFromPath(this.ruleTemplateFilename);
        try {
            this.velocityEngine.evaluate((Context)context, (Writer)stringWriter, this.ruleTemplateFilename, reader);
        }
        catch (MethodInvocationException | ParseErrorException | ResourceNotFoundException e) {
            throw new IOException(e);
        }
        return stringWriter.toString();
    }

    public String render(String providerName, StardocOutputProtos.ProviderInfo providerInfo) throws IOException {
        VelocityContext context = new VelocityContext();
        context.put("util", new MarkdownUtil());
        context.put("providerName", providerName);
        context.put("providerInfo", providerInfo);
        StringWriter stringWriter = new StringWriter();
        Reader reader = MarkdownRenderer.readerFromPath(this.providerTemplateFilename);
        try {
            this.velocityEngine.evaluate((Context)context, (Writer)stringWriter, this.providerTemplateFilename, reader);
        }
        catch (MethodInvocationException | ParseErrorException | ResourceNotFoundException e) {
            throw new IOException(e);
        }
        return stringWriter.toString();
    }

    public String render(StardocOutputProtos.StarlarkFunctionInfo functionInfo) throws IOException {
        VelocityContext context = new VelocityContext();
        context.put("util", new MarkdownUtil());
        context.put("funcInfo", functionInfo);
        StringWriter stringWriter = new StringWriter();
        Reader reader = MarkdownRenderer.readerFromPath(this.functionTemplateFilename);
        try {
            this.velocityEngine.evaluate((Context)context, (Writer)stringWriter, this.functionTemplateFilename, reader);
        }
        catch (MethodInvocationException | ParseErrorException | ResourceNotFoundException e) {
            throw new IOException(e);
        }
        return stringWriter.toString();
    }

    public String render(String aspectName, StardocOutputProtos.AspectInfo aspectInfo) throws IOException {
        VelocityContext context = new VelocityContext();
        context.put("util", new MarkdownUtil());
        context.put("aspectName", aspectName);
        context.put("aspectInfo", aspectInfo);
        StringWriter stringWriter = new StringWriter();
        Reader reader = MarkdownRenderer.readerFromPath(this.aspectTemplateFilename);
        try {
            this.velocityEngine.evaluate((Context)context, (Writer)stringWriter, this.aspectTemplateFilename, reader);
        }
        catch (MethodInvocationException | ParseErrorException | ResourceNotFoundException e) {
            throw new IOException(e);
        }
        return stringWriter.toString();
    }

    private static Reader readerFromPath(String filePath) throws IOException {
        if (Files.exists(Paths.get(filePath, new String[0]), new LinkOption[0])) {
            Path path = Paths.get(filePath, new String[0]);
            return Files.newBufferedReader(path);
        }
        InputStream inputStream = MarkdownRenderer.class.getClassLoader().getResourceAsStream(filePath);
        if (inputStream == null) {
            throw new FileNotFoundException(filePath + " was not found as a resource.");
        }
        return new InputStreamReader(inputStream, StandardCharsets.UTF_8);
    }
}

