/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.skydoc.fakebuildapi.repository;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.devtools.build.lib.starlarkbuildapi.repository.RepositoryModuleApi;
import com.google.devtools.build.skydoc.fakebuildapi.FakeDescriptor;
import com.google.devtools.build.skydoc.fakebuildapi.FakeStarlarkRuleFunctionsApi;
import com.google.devtools.build.skydoc.rendering.RuleInfoWrapper;
import com.google.devtools.build.skydoc.rendering.proto.StardocOutputProtos;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.starlark.java.eval.Dict;
import net.starlark.java.eval.EvalException;
import net.starlark.java.eval.Sequence;
import net.starlark.java.eval.Starlark;
import net.starlark.java.eval.StarlarkCallable;
import net.starlark.java.eval.StarlarkThread;
import net.starlark.java.syntax.Location;

public class FakeRepositoryModule
implements RepositoryModuleApi {
    private static final FakeDescriptor IMPLICIT_NAME_ATTRIBUTE_DESCRIPTOR = new FakeDescriptor(StardocOutputProtos.AttributeType.NAME, Optional.of("A unique name for this repository."), true, ImmutableList.of(), "");
    private static final FakeDescriptor IMPLICIT_REPO_MAPPING_ATTRIBUTE_DESCRIPTOR = new FakeDescriptor(StardocOutputProtos.AttributeType.STRING_DICT, Optional.of("A dictionary from local repository name to global repository name. This allows controls over workspace dependency resolution for dependencies of this repository.<p>For example, an entry `\"@foo\": \"@bar\"` declares that, for any time this repository depends on `@foo` (such as a dependency on `@foo//some:target`, it should actually resolve that dependency within globally-declared `@bar` (`@bar//some:target`)."), true, ImmutableList.of(), "");
    private final List<RuleInfoWrapper> ruleInfoList;

    public FakeRepositoryModule(List<RuleInfoWrapper> ruleInfoList) {
        this.ruleInfoList = ruleInfoList;
    }

    @Override
    public StarlarkCallable repositoryRule(StarlarkCallable implementation, Object attrs, Boolean local, Sequence<?> environ, Boolean configure, Boolean remotable, String doc, StarlarkThread thread) throws EvalException {
        ImmutableMap.Builder<String, FakeDescriptor> attrsMapBuilder = ImmutableMap.builder();
        if (attrs != null && attrs != Starlark.NONE) {
            attrsMapBuilder.putAll((Map<String, FakeDescriptor>)Dict.cast(attrs, String.class, FakeDescriptor.class, "attrs"));
        }
        attrsMapBuilder.put("name", IMPLICIT_NAME_ATTRIBUTE_DESCRIPTOR);
        attrsMapBuilder.put("repo_mapping", IMPLICIT_REPO_MAPPING_ATTRIBUTE_DESCRIPTOR);
        List attrInfos = attrsMapBuilder.build().entrySet().stream().filter(entry -> !((String)entry.getKey()).startsWith("_")).map(entry -> ((FakeDescriptor)entry.getValue()).asAttributeInfo((String)entry.getKey())).collect(Collectors.toList());
        attrInfos.sort(new FakeStarlarkRuleFunctionsApi.AttributeNameComparator());
        RepositoryRuleDefinitionIdentifier functionIdentifier = new RepositoryRuleDefinitionIdentifier();
        StardocOutputProtos.RuleInfo.Builder ruleInfo = StardocOutputProtos.RuleInfo.newBuilder().setDocString(doc).addAllAttribute(attrInfos);
        Location loc = thread.getCallerLocation();
        this.ruleInfoList.add(new RuleInfoWrapper(functionIdentifier, loc, ruleInfo));
        return functionIdentifier;
    }

    @Override
    public Object moduleExtension(StarlarkCallable implementation, Dict<?, ?> tagClasses, String doc, StarlarkThread thread) throws EvalException {
        return new Object();
    }

    @Override
    public RepositoryModuleApi.TagClassApi tagClass(Dict<?, ?> attrs, String doc, StarlarkThread thread) throws EvalException {
        return new RepositoryModuleApi.TagClassApi(){};
    }

    @Override
    public void failWithIncompatibleUseCcConfigureFromRulesCc(StarlarkThread thread) throws EvalException {
    }

    private static class RepositoryRuleDefinitionIdentifier
    implements StarlarkCallable {
        private static int idCounter = 0;
        private final String name = "RepositoryRuleDefinitionIdentifier" + idCounter++;

        private RepositoryRuleDefinitionIdentifier() {
        }

        @Override
        public String getName() {
            return this.name;
        }
    }
}

