/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.skydoc.fakebuildapi;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Ordering;
import com.google.devtools.build.lib.starlarkbuildapi.core.StructApi;
import java.util.Map;
import javax.annotation.Nullable;
import net.starlark.java.eval.Dict;
import net.starlark.java.eval.EvalException;
import net.starlark.java.eval.Printer;
import net.starlark.java.eval.StarlarkThread;
import net.starlark.java.eval.Structure;

public class FakeStructApi
implements StructApi,
Structure {
    private final Map<String, Object> objects;

    public FakeStructApi(Map<String, Object> objects) {
        this.objects = objects;
    }

    public FakeStructApi() {
        this(ImmutableMap.of());
    }

    @Override
    public String toProto() throws EvalException {
        return "";
    }

    @Override
    public String toJson() throws EvalException {
        return "";
    }

    @VisibleForTesting
    public Object getValueOrNull(String name) {
        try {
            return this.getValue(name);
        }
        catch (EvalException e) {
            throw new IllegalStateException("getValue should not throw an exception", e);
        }
    }

    @Override
    public void repr(Printer printer) {
        boolean first = true;
        printer.append("struct(");
        for (String fieldName : Ordering.natural().sortedCopy(this.getFieldNames())) {
            if (!first) {
                printer.append(", ");
            }
            first = false;
            printer.append(fieldName);
            printer.append(" = ");
            printer.repr(this.getValueOrNull(fieldName));
        }
        printer.append(")");
    }

    @Override
    @Nullable
    public Object getValue(String name) throws EvalException {
        return this.objects.get(name);
    }

    @Override
    public ImmutableCollection<String> getFieldNames() {
        return ImmutableList.copyOf(this.objects.keySet());
    }

    @Override
    @Nullable
    public String getErrorMessageForUnknownField(String field) {
        return "";
    }

    public static class FakeStructProviderApi
    implements StructApi.StructProviderApi {
        @Override
        public StructApi createStruct(Dict<String, Object> kwargs, StarlarkThread thread) {
            return new FakeStructApi(kwargs);
        }

        @Override
        public void repr(Printer printer) {
        }
    }
}

