/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.skydoc.fakebuildapi;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.devtools.build.lib.cmdline.Label;
import com.google.devtools.build.lib.cmdline.LabelSyntaxException;
import com.google.devtools.build.lib.starlarkbuildapi.ExecGroupApi;
import com.google.devtools.build.lib.starlarkbuildapi.StarlarkAspectApi;
import com.google.devtools.build.lib.starlarkbuildapi.StarlarkRuleFunctionsApi;
import com.google.devtools.build.skydoc.fakebuildapi.FakeDeepStructure;
import com.google.devtools.build.skydoc.fakebuildapi.FakeDescriptor;
import com.google.devtools.build.skydoc.fakebuildapi.FakeExecGroup;
import com.google.devtools.build.skydoc.fakebuildapi.FakeProviderApi;
import com.google.devtools.build.skydoc.fakebuildapi.FakeStarlarkAspect;
import com.google.devtools.build.skydoc.rendering.AspectInfoWrapper;
import com.google.devtools.build.skydoc.rendering.ProviderInfoWrapper;
import com.google.devtools.build.skydoc.rendering.RuleInfoWrapper;
import com.google.devtools.build.skydoc.rendering.proto.StardocOutputProtos;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.starlark.java.eval.Dict;
import net.starlark.java.eval.EvalException;
import net.starlark.java.eval.Sequence;
import net.starlark.java.eval.Starlark;
import net.starlark.java.eval.StarlarkCallable;
import net.starlark.java.eval.StarlarkFunction;
import net.starlark.java.eval.StarlarkThread;
import net.starlark.java.eval.Tuple;
import net.starlark.java.syntax.Location;

public class FakeStarlarkRuleFunctionsApi
implements StarlarkRuleFunctionsApi {
    private static final FakeDescriptor IMPLICIT_NAME_ATTRIBUTE_DESCRIPTOR = new FakeDescriptor(StardocOutputProtos.AttributeType.NAME, Optional.of("A unique name for this target."), true, ImmutableList.of(), "");
    private final List<RuleInfoWrapper> ruleInfoList;
    private final List<ProviderInfoWrapper> providerInfoList;
    private final List<AspectInfoWrapper> aspectInfoList;

    public FakeStarlarkRuleFunctionsApi(List<RuleInfoWrapper> ruleInfoList, List<ProviderInfoWrapper> providerInfoList, List<AspectInfoWrapper> aspectInfoList) {
        this.ruleInfoList = ruleInfoList;
        this.providerInfoList = providerInfoList;
        this.aspectInfoList = aspectInfoList;
    }

    @Override
    public Object provider(Object doc, Object fields, Object init, StarlarkThread thread) throws EvalException {
        FakeProviderApi fakeProvider = new FakeProviderApi(null);
        ImmutableList.Builder providerFieldInfos = ImmutableList.builder();
        if (fields instanceof Sequence) {
            for (String name : Sequence.cast(fields, String.class, "fields")) {
                providerFieldInfos.add(this.asProviderFieldInfo(name, "(Undocumented)"));
            }
        } else if (fields instanceof Dict) {
            for (Map.Entry<String, String> e : Dict.cast(fields, String.class, String.class, "fields").entrySet()) {
                providerFieldInfos.add(this.asProviderFieldInfo(e.getKey(), e.getValue()));
            }
        }
        this.providerInfoList.add(this.forProviderInfo(fakeProvider, Starlark.toJavaOptional(doc, String.class), providerFieldInfos.build()));
        if (init == Starlark.NONE) {
            return fakeProvider;
        }
        return Tuple.of(new Object[]{fakeProvider, FakeDeepStructure.create("<raw constructor>")});
    }

    public StardocOutputProtos.ProviderFieldInfo asProviderFieldInfo(String name, String docString) {
        return StardocOutputProtos.ProviderFieldInfo.newBuilder().setName(name).setDocString(docString).build();
    }

    public ProviderInfoWrapper forProviderInfo(StarlarkCallable identifier, Optional<String> docString, Collection<StardocOutputProtos.ProviderFieldInfo> fieldInfos) {
        return new ProviderInfoWrapper(identifier, docString, fieldInfos);
    }

    @Override
    public StarlarkCallable rule(StarlarkFunction implementation, Boolean test, Object attrs, Object implicitOutputs, Boolean executable, Boolean outputToGenfiles, Sequence<?> fragments, Sequence<?> hostFragments, Boolean starlarkTestable, Sequence<?> toolchains, boolean useToolchainTransition, Object doc, Sequence<?> providesArg, Sequence<?> execCompatibleWith, Object analysisTest, Object buildSetting, Object cfg, Object execGroups, Object name, StarlarkThread thread) throws EvalException {
        ImmutableMap.Builder<String, FakeDescriptor> attrsMapBuilder = ImmutableMap.builder();
        if (attrs != null && attrs != Starlark.NONE) {
            attrsMapBuilder.putAll((Map<String, FakeDescriptor>)Dict.cast(attrs, String.class, FakeDescriptor.class, "attrs"));
        }
        attrsMapBuilder.put("name", IMPLICIT_NAME_ATTRIBUTE_DESCRIPTOR);
        List attrInfos = attrsMapBuilder.build().entrySet().stream().filter(entry -> !((String)entry.getKey()).startsWith("_")).map(entry -> ((FakeDescriptor)entry.getValue()).asAttributeInfo((String)entry.getKey())).collect(Collectors.toList());
        attrInfos.sort(new AttributeNameComparator());
        RuleDefinitionIdentifier functionIdentifier = new RuleDefinitionIdentifier();
        StardocOutputProtos.RuleInfo.Builder ruleInfo = StardocOutputProtos.RuleInfo.newBuilder().addAllAttribute(attrInfos);
        Starlark.toJavaOptional(doc, String.class).ifPresent(ruleInfo::setDocString);
        Starlark.toJavaOptional(name, String.class).ifPresent(ruleInfo::setRuleName);
        Location loc = thread.getCallerLocation();
        this.ruleInfoList.add(new RuleInfoWrapper(functionIdentifier, loc, ruleInfo));
        return functionIdentifier;
    }

    @Override
    public Label label(Object input, StarlarkThread thread) throws EvalException {
        if (input instanceof Label) {
            return (Label)input;
        }
        try {
            return Label.parseCanonical((String)input);
        }
        catch (LabelSyntaxException e) {
            throw Starlark.errorf("Illegal absolute label syntax: %s", input);
        }
    }

    @Override
    public StarlarkAspectApi aspect(StarlarkFunction implementation, Sequence<?> attributeAspects, Object attrs, Sequence<?> requiredProvidersArg, Sequence<?> requiredAspectProvidersArg, Sequence<?> providesArg, Sequence<?> requiredAspects, Sequence<?> fragments, Sequence<?> hostFragments, Sequence<?> toolchains, boolean useToolchainTransition, Object doc, Boolean applyToFiles, Sequence<?> execCompatibleWith, Object execGroups, StarlarkThread thread) throws EvalException {
        FakeStarlarkAspect fakeAspect = new FakeStarlarkAspect();
        ImmutableMap.Builder<String, FakeDescriptor> attrsMapBuilder = ImmutableMap.builder();
        if (attrs != null && attrs != Starlark.NONE) {
            attrsMapBuilder.putAll((Map<String, FakeDescriptor>)Dict.cast(attrs, String.class, FakeDescriptor.class, "attrs"));
        }
        attrsMapBuilder.put("name", IMPLICIT_NAME_ATTRIBUTE_DESCRIPTOR);
        List attrInfos = attrsMapBuilder.build().entrySet().stream().filter(entry -> !((String)entry.getKey()).startsWith("_")).map(entry -> ((FakeDescriptor)entry.getValue()).asAttributeInfo((String)entry.getKey())).collect(Collectors.toList());
        attrInfos.sort(new AttributeNameComparator());
        ArrayList<String> aspectAttrs = attributeAspects != null ? Sequence.cast(attributeAspects, String.class, "aspectAttrs") : new ArrayList();
        aspectAttrs = aspectAttrs.stream().filter(entry -> !entry.startsWith("_")).collect(Collectors.toList());
        StardocOutputProtos.AspectInfo.Builder aspectInfo = StardocOutputProtos.AspectInfo.newBuilder().addAllAttribute(attrInfos).addAllAspectAttribute(aspectAttrs);
        Starlark.toJavaOptional(doc, String.class).ifPresent(aspectInfo::setDocString);
        this.aspectInfoList.add(new AspectInfoWrapper(fakeAspect, thread.getCallerLocation(), aspectInfo));
        return fakeAspect;
    }

    @Override
    public ExecGroupApi execGroup(Sequence<?> execCompatibleWith, Sequence<?> toolchains, StarlarkThread thread) {
        return new FakeExecGroup();
    }

    public static class AttributeNameComparator
    implements Comparator<StardocOutputProtos.AttributeInfo> {
        @Override
        public int compare(StardocOutputProtos.AttributeInfo o1, StardocOutputProtos.AttributeInfo o2) {
            if (o1.getName().equals("name")) {
                return o2.getName().equals("name") ? 0 : -1;
            }
            if (o2.getName().equals("name")) {
                return 1;
            }
            return o1.getName().compareTo(o2.getName());
        }
    }

    private static class RuleDefinitionIdentifier
    implements StarlarkCallable {
        private static int idCounter = 0;
        private final String name = "RuleDefinitionIdentifier" + idCounter++;

        private RuleDefinitionIdentifier() {
        }

        @Override
        public String getName() {
            return this.name;
        }
    }
}

