/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.skydoc.fakebuildapi;

import com.google.common.collect.ImmutableList;
import com.google.devtools.build.lib.starlarkbuildapi.StarlarkAttrModuleApi;
import com.google.devtools.build.lib.starlarkbuildapi.core.ProviderApi;
import com.google.devtools.build.skydoc.fakebuildapi.FakeDescriptor;
import com.google.devtools.build.skydoc.fakebuildapi.FakeProviderApi;
import com.google.devtools.build.skydoc.rendering.proto.StardocOutputProtos;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.starlark.java.eval.Dict;
import net.starlark.java.eval.EvalException;
import net.starlark.java.eval.Module;
import net.starlark.java.eval.Printer;
import net.starlark.java.eval.Sequence;
import net.starlark.java.eval.Starlark;
import net.starlark.java.eval.StarlarkInt;
import net.starlark.java.eval.StarlarkThread;

public class FakeStarlarkAttrModuleApi
implements StarlarkAttrModuleApi {
    @Override
    public StarlarkAttrModuleApi.Descriptor intAttribute(StarlarkInt defaultInt, Object doc, Boolean mandatory, Sequence<?> values, StarlarkThread thread) throws EvalException {
        return new FakeDescriptor(StardocOutputProtos.AttributeType.INT, Starlark.toJavaOptional(doc, String.class), mandatory, ImmutableList.of(), defaultInt);
    }

    @Override
    public StarlarkAttrModuleApi.Descriptor stringAttribute(Object defaultString, Object doc, Boolean mandatory, Sequence<?> values, StarlarkThread thread) throws EvalException {
        return new FakeDescriptor(StardocOutputProtos.AttributeType.STRING, Starlark.toJavaOptional(doc, String.class), mandatory, ImmutableList.of(), defaultString != null ? "\"" + defaultString + "\"" : null);
    }

    @Override
    public StarlarkAttrModuleApi.Descriptor labelAttribute(Object defaultO, Object doc, Boolean executable, Object allowFiles, Object allowSingleFile, Boolean mandatory, Sequence<?> providers, Object allowRules, Object cfg, Sequence<?> aspects, Object flags, StarlarkThread thread) throws EvalException {
        ArrayList<List<String>> allNameGroups = new ArrayList();
        if (providers != null) {
            allNameGroups = FakeStarlarkAttrModuleApi.allProviderNameGroups(providers, thread);
        }
        return new FakeDescriptor(StardocOutputProtos.AttributeType.LABEL, Starlark.toJavaOptional(doc, String.class), mandatory, allNameGroups, defaultO);
    }

    @Override
    public StarlarkAttrModuleApi.Descriptor stringListAttribute(Boolean mandatory, Boolean allowEmpty, Object defaultList, Object doc, StarlarkThread thread) throws EvalException {
        return new FakeDescriptor(StardocOutputProtos.AttributeType.STRING_LIST, Starlark.toJavaOptional(doc, String.class), mandatory, ImmutableList.of(), defaultList);
    }

    @Override
    public StarlarkAttrModuleApi.Descriptor intListAttribute(Boolean mandatory, Boolean allowEmpty, Sequence<?> defaultList, Object doc, StarlarkThread thread) throws EvalException {
        return new FakeDescriptor(StardocOutputProtos.AttributeType.INT_LIST, Starlark.toJavaOptional(doc, String.class), mandatory, ImmutableList.of(), defaultList);
    }

    @Override
    public StarlarkAttrModuleApi.Descriptor labelListAttribute(Boolean allowEmpty, Object defaultList, Object doc, Object allowFiles, Object allowRules, Sequence<?> providers, Sequence<?> flags, Boolean mandatory, Object cfg, Sequence<?> aspects, StarlarkThread thread) throws EvalException {
        ArrayList<List<String>> allNameGroups = new ArrayList();
        if (providers != null) {
            allNameGroups = FakeStarlarkAttrModuleApi.allProviderNameGroups(providers, thread);
        }
        return new FakeDescriptor(StardocOutputProtos.AttributeType.LABEL_LIST, Starlark.toJavaOptional(doc, String.class), mandatory, allNameGroups, defaultList);
    }

    @Override
    public StarlarkAttrModuleApi.Descriptor labelKeyedStringDictAttribute(Boolean allowEmpty, Object defaultList, Object doc, Object allowFiles, Object allowRules, Sequence<?> providers, Sequence<?> flags, Boolean mandatory, Object cfg, Sequence<?> aspects, StarlarkThread thread) throws EvalException {
        ArrayList<List<String>> allNameGroups = new ArrayList();
        if (providers != null) {
            allNameGroups = FakeStarlarkAttrModuleApi.allProviderNameGroups(providers, thread);
        }
        return new FakeDescriptor(StardocOutputProtos.AttributeType.LABEL_STRING_DICT, Starlark.toJavaOptional(doc, String.class), mandatory, allNameGroups, defaultList);
    }

    @Override
    public StarlarkAttrModuleApi.Descriptor boolAttribute(Boolean defaultO, Object doc, Boolean mandatory, StarlarkThread thread) throws EvalException {
        return new FakeDescriptor(StardocOutputProtos.AttributeType.BOOLEAN, Starlark.toJavaOptional(doc, String.class), mandatory, ImmutableList.of(), Boolean.TRUE.equals(defaultO) ? "True" : "False");
    }

    @Override
    public StarlarkAttrModuleApi.Descriptor outputAttribute(Object doc, Boolean mandatory, StarlarkThread thread) throws EvalException {
        return new FakeDescriptor(StardocOutputProtos.AttributeType.OUTPUT, Starlark.toJavaOptional(doc, String.class), mandatory, ImmutableList.of(), "");
    }

    @Override
    public StarlarkAttrModuleApi.Descriptor outputListAttribute(Boolean allowEmpty, Object doc, Boolean mandatory, StarlarkThread thread) throws EvalException {
        return new FakeDescriptor(StardocOutputProtos.AttributeType.OUTPUT_LIST, Starlark.toJavaOptional(doc, String.class), mandatory, ImmutableList.of(), "");
    }

    @Override
    public StarlarkAttrModuleApi.Descriptor stringDictAttribute(Boolean allowEmpty, Dict<?, ?> defaultO, Object doc, Boolean mandatory, StarlarkThread thread) throws EvalException {
        return new FakeDescriptor(StardocOutputProtos.AttributeType.STRING_DICT, Starlark.toJavaOptional(doc, String.class), mandatory, ImmutableList.of(), defaultO);
    }

    @Override
    public StarlarkAttrModuleApi.Descriptor stringListDictAttribute(Boolean allowEmpty, Dict<?, ?> defaultO, Object doc, Boolean mandatory, StarlarkThread thread) throws EvalException {
        return new FakeDescriptor(StardocOutputProtos.AttributeType.STRING_LIST_DICT, Starlark.toJavaOptional(doc, String.class), mandatory, ImmutableList.of(), defaultO);
    }

    @Override
    public StarlarkAttrModuleApi.Descriptor licenseAttribute(Object defaultO, Object doc, Boolean mandatory, StarlarkThread thread) throws EvalException {
        return new FakeDescriptor(StardocOutputProtos.AttributeType.STRING_LIST, Starlark.toJavaOptional(doc, String.class), mandatory, ImmutableList.of(), defaultO);
    }

    @Override
    public void repr(Printer printer) {
    }

    private static List<List<String>> allProviderNameGroups(Sequence<?> providers, StarlarkThread thread) {
        ArrayList<List<String>> allNameGroups = new ArrayList<List<String>>();
        for (Object object : providers) {
            List<String> providerNameGroup;
            if (object instanceof Sequence) {
                Sequence group = (Sequence)object;
                providerNameGroup = FakeStarlarkAttrModuleApi.parseProviderGroup(group, thread);
                allNameGroups.add(providerNameGroup);
                continue;
            }
            providerNameGroup = FakeStarlarkAttrModuleApi.parseProviderGroup(providers, thread);
            allNameGroups.add(providerNameGroup);
            break;
        }
        return allNameGroups;
    }

    private static List<String> parseProviderGroup(Sequence<?> group, StarlarkThread thread) {
        ArrayList<String> providerNameGroup = new ArrayList<String>();
        for (Object object : group) {
            if (object instanceof ProviderApi) {
                ProviderApi provider = (ProviderApi)object;
                String providerName = FakeStarlarkAttrModuleApi.providerName(provider, thread);
                providerNameGroup.add(providerName);
                continue;
            }
            if (!(object instanceof String)) continue;
            String legacyProvider = (String)object;
            providerNameGroup.add(legacyProvider);
        }
        return providerNameGroup;
    }

    private static String providerName(ProviderApi provider, StarlarkThread thread) {
        Module bzl = Module.ofInnermostEnclosingStarlarkFunction(thread);
        if (provider instanceof FakeProviderApi) {
            return ((FakeProviderApi)provider).getName();
        }
        for (Map.Entry e : bzl.getPredeclaredBindings().entrySet()) {
            if (!provider.equals(e.getValue())) continue;
            return (String)e.getKey();
        }
        return "Unknown Provider";
    }
}

