/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.skydoc;

import com.google.devtools.build.lib.events.Event;
import com.google.devtools.build.lib.events.EventHandler;

class SystemOutEventHandler
implements EventHandler {
    SystemOutEventHandler() {
    }

    @Override
    public void handle(Event event) {
        switch (event.getKind()) {
            case ERROR: 
            case WARNING: 
            case STDERR: {
                System.err.println(this.messageWithLocation(event));
                break;
            }
            case DEBUG: 
            case INFO: 
            case PROGRESS: 
            case STDOUT: {
                System.out.println(this.messageWithLocation(event));
                break;
            }
            default: {
                System.err.println("Unknown message type: " + event);
            }
        }
    }

    private String messageWithLocation(Event event) {
        String location = event.getLocation() == null ? "<no location>" : event.getLocation().toString();
        return location + ": " + event.getMessage();
    }
}

